/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.intellij.psi.PsiAnnotation;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public final class LoggingContributor
implements AstTransformationSupport {
    private static final Map<String, String> loggers;

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        GrModifierList modifierList;
        if (context == null) {
            LoggingContributor.$$$reportNull$$$0(0);
        }
        if ((modifierList = context.getCodeClass().getModifierList()) == null) {
            return;
        }
        for (GrAnnotation annotation : modifierList.getAnnotations()) {
            String qname = annotation.getQualifiedName();
            String logger = loggers.get(qname);
            if (logger == null) continue;
            String fieldName = PsiUtil.getAnnoAttributeValue((PsiAnnotation)annotation, "value", "log");
            GrLightField field2 = new GrLightField(fieldName, logger, context.getCodeClass());
            field2.setNavigationElement(annotation);
            ((GrLightModifierList)field2.getModifierList()).setModifiers("private", "final", "static");
            field2.setOriginInfo("created by @" + annotation.getShortName());
            context.addField(field2);
        }
    }

    static {
        HashMap<String, String> map2 = new HashMap<String, String>(5);
        map2.put("groovy.util.logging.Log", "java.util.logging.Logger");
        map2.put("groovy.util.logging.Commons", "org.apache.commons.logging.Log");
        map2.put("groovy.util.logging.Log4j", "org.apache.log4j.Logger");
        map2.put("groovy.util.logging.Log4j2", "org.apache.logging.log4j.core.Logger");
        map2.put("groovy.util.logging.Slf4j", "org.slf4j.Logger");
        loggers = map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/ast/LoggingContributor", "applyTransformation"));
    }
}

