/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.function.Consumer;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.dsl.ClosureDescriptor;
import org.jetbrains.plugins.groovy.dsl.GdslMembersHolderConsumer;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.dsltop.GdslMembersProvider;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public final class GdkMethodDslProvider
implements GdslMembersProvider {
    public void category(String className, GdslMembersHolderConsumer consumer) {
        GdkMethodDslProvider.processCategoryMethods(className, consumer, false);
    }

    public void category(String className, boolean isStatic, GdslMembersHolderConsumer consumer) {
        GdkMethodDslProvider.processCategoryMethods(className, consumer, isStatic);
    }

    private static void processCategoryMethods(String className, GdslMembersHolderConsumer consumer, boolean isStatic) {
        GlobalSearchScope scope = consumer.getResolveScope();
        PsiClass categoryClass = JavaPsiFacade.getInstance((Project)consumer.getProject()).findClass(className, scope);
        if (categoryClass == null) {
            return;
        }
        final NotNullLazyValue methodsMap = NotNullLazyValue.volatileLazy(() -> GdkMethodHolder.getHolderForClass(categoryClass, isStatic));
        consumer.addMemberHolder(new CustomMembersHolder(){

            @Override
            public boolean processMembers(GroovyClassDescriptor descriptor2, PsiScopeProcessor processor, ResolveState state) {
                return !ResolveUtil.shouldProcessMethods((ElementClassHint)processor.getHint(ElementClassHint.KEY)) || ((GdkMethodHolder)methodsMap.getValue()).processMethods(processor, state, descriptor2.getPsiType(), descriptor2.getProject());
            }

            @Override
            public void consumeClosureDescriptors(GroovyClassDescriptor descriptor2, Consumer<? super ClosureDescriptor> consumer) {
            }
        });
    }
}

