/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.gant.GantScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public final class GantPositionManagerHelper
extends ScriptPositionManagerHelper {
    @Override
    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        if (runtimeName == null) {
            GantPositionManagerHelper.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    public boolean isAppropriateScriptFile(@NotNull GroovyFile scriptFile) {
        if (scriptFile == null) {
            GantPositionManagerHelper.$$$reportNull$$$0(1);
        }
        return GroovyScriptUtil.isSpecificScriptFile(scriptFile, GantScriptType.INSTANCE);
    }

    @Override
    public PsiFile getExtraScriptIfNotFound(@NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (refType == null) {
            GantPositionManagerHelper.$$$reportNull$$$0(2);
        }
        if (runtimeName == null) {
            GantPositionManagerHelper.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GantPositionManagerHelper.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            GantPositionManagerHelper.$$$reportNull$$$0(5);
        }
        try {
            String fileName = StringUtil.getShortName((String)runtimeName);
            PsiFile[] files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + ".gant"), (GlobalSearchScope)scope);
            if (files.length == 0) {
                files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + ".gant"), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            }
            if (files.length == 1) {
                return files[0];
            }
            if (files.length == 0) {
                files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + ".groovy"), (GlobalSearchScope)scope);
                if (files.length == 0) {
                    files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + ".gant"), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                }
                PsiFile candidate = null;
                for (PsiFile file : files) {
                    if (!GroovyScriptUtil.isSpecificScriptFile(file, GantScriptType.INSTANCE)) continue;
                    if (candidate != null) {
                        return null;
                    }
                    candidate = file;
                }
                return candidate;
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAppropriateRuntimeName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAppropriateScriptFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getExtraScriptIfNotFound";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

