/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.ClosureBodyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GrLabelBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.MethodCallWithoutQualifierBlock;
import org.jetbrains.plugins.groovy.formatter.models.spacing.SpacingTokens;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocInlinedTag;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class GroovySpacingProcessorBasic {
    private static final Spacing NO_SPACING_WITH_NEWLINE = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)1);
    private static final Spacing NO_SPACING = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
    private static final Spacing COMMON_SPACING = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)100);
    private static final Spacing COMMON_SPACING_WITH_NL = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)100);
    private static final Spacing LAZY_SPACING = Spacing.createSpacing((int)0, (int)239, (int)0, (boolean)true, (int)100);

    public static Spacing getSpacing(GroovyBlock child1, GroovyBlock child2, FormattingContext context) {
        PsiElement p;
        Spacing actualSpacing;
        ASTNode leftNode = child1.getNode();
        ASTNode rightNode = child2.getNode();
        PsiElement left = leftNode.getPsi();
        PsiElement right = rightNode.getPsi();
        IElementType leftType = leftNode.getElementType();
        IElementType rightType = rightNode.getElementType();
        CommonCodeStyleSettings settings = context.getSettings();
        GroovyCodeStyleSettings groovySettings = context.getGroovySettings();
        if (!GroovySpacingProcessorBasic.mirrorsAst(child1) || !GroovySpacingProcessorBasic.mirrorsAst(child2)) {
            return NO_SPACING;
        }
        if (child2 instanceof ClosureBodyBlock) {
            return settings.SPACE_WITHIN_BRACES ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (child1 instanceof ClosureBodyBlock) {
            return GroovySpacingProcessorBasic.createDependentSpacingForClosure(settings, groovySettings, (GrClosableBlock)left.getParent(), false);
        }
        if (groovySettings.isGroovyDocFormattingAllowed() && leftType == GroovyDocElementTypes.GROOVY_DOC_COMMENT) {
            return COMMON_SPACING_WITH_NL;
        }
        if (right instanceof GrTypeArgumentList) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyTokenTypes.mCOMMA == leftType) {
            return settings.SPACE_AFTER_COMMA ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyTokenTypes.mCOMMA == rightType) {
            return settings.SPACE_BEFORE_COMMA ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyTokenTypes.mSEMI == leftType) {
            return settings.SPACE_AFTER_SEMICOLON ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyTokenTypes.mSEMI == rightType) {
            return settings.SPACE_BEFORE_SEMICOLON ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        }
        if (TokenSets.DOTS.contains(rightType) || GroovyTokenTypes.mCOLON.equals(rightType) && !(right.getParent() instanceof GrConditionalExpression)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (TokenSets.DOTS.contains(leftType)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if ((((Object)((Object)GroovyStubElementTypes.VARIABLE_DECLARATION)).equals(leftType) || ((Object)((Object)GroovyStubElementTypes.VARIABLE_DECLARATION)).equals(rightType)) && !(leftNode.getTreeNext() instanceof PsiErrorElement)) {
            return GroovySpacingProcessorBasic.getStatementSpacing(context);
        }
        if (leftNode.getTreeParent().getElementType() == GroovyTokenTypes.mREGEX_LITERAL || leftNode.getTreeParent().getElementType() == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            return NO_SPACING;
        }
        if (GroovyTokenTypes.mLT.equals(leftType) && GroovyTokenTypes.mLT.equals(rightType) || GroovyTokenTypes.mGT.equals(leftType) && GroovyTokenTypes.mGT.equals(rightType)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (SpacingTokens.PREFIXES.contains(leftType) || SpacingTokens.POSTFIXES.contains(rightType) || SpacingTokens.PREFIXES_OPTIONAL.contains(leftType) && left.getParent() instanceof GrUnaryExpression) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyTokenSets.RANGES.contains(leftType) || GroovyTokenSets.RANGES.contains(rightType)) {
            return NO_SPACING_WITH_NEWLINE;
        }
        if (GroovyDocTokenTypes.mGDOC_ASTERISKS == leftType && GroovyDocTokenTypes.mGDOC_COMMENT_DATA == rightType) {
            if (!groovySettings.isGroovyDocFormattingAllowed()) {
                return LAZY_SPACING;
            }
            String text = rightNode.getText();
            if (!text.isEmpty() && !StringUtil.startsWithChar((CharSequence)text, (char)' ')) {
                return COMMON_SPACING;
            }
            return NO_SPACING;
        }
        if (leftType == GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN && rightType == GroovyDocTokenTypes.mGDOC_COMMENT_DATA) {
            return LAZY_SPACING;
        }
        if (left instanceof GrStatement && right instanceof GrStatement && left.getParent() instanceof GrStatementOwner && right.getParent() instanceof GrStatementOwner) {
            return GroovySpacingProcessorBasic.getStatementSpacing(context);
        }
        Spacing rightSpacing = GroovySpacingProcessorBasic.getGroovyDocBraceSpacing(right);
        Spacing spacing = actualSpacing = rightSpacing == null ? GroovySpacingProcessorBasic.getGroovyDocBraceSpacing(left) : rightSpacing;
        if (actualSpacing != null) {
            if (!groovySettings.isGroovyDocFormattingAllowed()) {
                return LAZY_SPACING;
            }
            return actualSpacing;
        }
        if (leftType == GroovyDocElementTypes.GDOC_INLINED_TAG && rightType == GroovyDocTokenTypes.mGDOC_COMMENT_DATA || leftType == GroovyDocTokenTypes.mGDOC_COMMENT_DATA && rightType == GroovyDocElementTypes.GDOC_INLINED_TAG) {
            if (!groovySettings.isGroovyDocFormattingAllowed()) {
                return LAZY_SPACING;
            }
            return NO_SPACING;
        }
        if (leftType == GroovyElementTypes.CLASS_TYPE_ELEMENT && rightType == GroovyTokenTypes.mTRIPLE_DOT) {
            return NO_SPACING;
        }
        if ((rightType == GroovyTokenTypes.mLT || rightType == GroovyTokenTypes.mGT) && right.getParent() instanceof GrCodeReferenceElement && ((p = right.getParent().getParent()) instanceof GrNewExpression || p instanceof GrAnonymousClassDefinition)) {
            return NO_SPACING;
        }
        return COMMON_SPACING;
    }

    @Nullable
    public static Spacing getGroovyDocBraceSpacing(@NotNull PsiElement grDocInlineTagBrace) {
        IElementType type2;
        if (grDocInlineTagBrace == null) {
            GroovySpacingProcessorBasic.$$$reportNull$$$0(0);
        }
        if ((type2 = grDocInlineTagBrace.getNode().getElementType()) != GroovyDocTokenTypes.mGDOC_INLINE_TAG_START && type2 != GroovyDocTokenTypes.mGDOC_INLINE_TAG_END) {
            return null;
        }
        PsiElement parent2 = grDocInlineTagBrace.getParent();
        if (parent2 instanceof GrDocInlinedTag && (parent2.getFirstChild() == grDocInlineTagBrace || parent2.getLastChild() == grDocInlineTagBrace)) {
            return NO_SPACING;
        }
        return LAZY_SPACING;
    }

    @NotNull
    private static Spacing getStatementSpacing(FormattingContext context) {
        Spacing spacing = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)context.getSettings().KEEP_LINE_BREAKS, (int)context.getSettings().KEEP_BLANK_LINES_IN_CODE);
        if (spacing == null) {
            GroovySpacingProcessorBasic.$$$reportNull$$$0(1);
        }
        return spacing;
    }

    @NotNull
    static Spacing createDependentSpacingForClosure(@NotNull CommonCodeStyleSettings settings, @NotNull GroovyCodeStyleSettings groovySettings, @NotNull GrClosableBlock closure, boolean forArrow) {
        if (settings == null) {
            GroovySpacingProcessorBasic.$$$reportNull$$$0(2);
        }
        if (groovySettings == null) {
            GroovySpacingProcessorBasic.$$$reportNull$$$0(3);
        }
        if (closure == null) {
            GroovySpacingProcessorBasic.$$$reportNull$$$0(4);
        }
        boolean spaceWithinBraces = closure.getParent() instanceof GrStringInjection ? groovySettings.SPACE_WITHIN_GSTRING_INJECTION_BRACES : settings.SPACE_WITHIN_BRACES;
        GrStatement[] statements2 = closure.getStatements();
        if (statements2.length > 0) {
            GrClosableBlock startElem = forArrow ? statements2[0] : closure;
            int start = startElem.getTextRange().getStartOffset();
            int end = statements2[statements2.length - 1].getTextRange().getEndOffset();
            TextRange range = new TextRange(start, end);
            int minSpaces = spaceWithinBraces || forArrow ? 1 : 0;
            int maxSpaces = spaceWithinBraces || forArrow ? 1 : 0;
            Spacing spacing = Spacing.createDependentLFSpacing((int)minSpaces, (int)maxSpaces, (TextRange)range, (boolean)settings.KEEP_LINE_BREAKS, (int)settings.KEEP_BLANK_LINES_IN_CODE);
            if (spacing == null) {
                GroovySpacingProcessorBasic.$$$reportNull$$$0(5);
            }
            return spacing;
        }
        Spacing spacing = spaceWithinBraces || forArrow ? COMMON_SPACING : NO_SPACING_WITH_NEWLINE;
        if (spacing == null) {
            GroovySpacingProcessorBasic.$$$reportNull$$$0(6);
        }
        return spacing;
    }

    private static boolean mirrorsAst(GroovyBlock block) {
        return block.getNode().getTextRange().equals((Object)block.getTextRange()) || block instanceof MethodCallWithoutQualifierBlock || block instanceof ClosureBodyBlock || block instanceof GrLabelBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grDocInlineTagBrace";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/formatter/processors/GroovySpacingProcessorBasic";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovySettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/formatter/processors/GroovySpacingProcessorBasic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementSpacing";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSpacingForClosure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGroovyDocBraceSpacing";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDependentSpacingForClosure";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6 -> new IllegalStateException(string);
        };
    }
}

