/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/editor/actions/GroovyStringBackslashHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "charTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "shouldInsertAdditionalSlash", "", "offset", "", "intellij.groovy"})
public final class GroovyStringBackslashHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (c == '\\' && this.shouldInsertAdditionalSlash(file, (offset = editor.getCaretModel().getOffset()) - 1)) {
            editor.getDocument().insertString(offset, (CharSequence)"\\");
            editor.getSelectionModel().setSelection(offset, offset + 1);
            return TypedHandlerDelegate.Result.DEFAULT;
        }
        TypedHandlerDelegate.Result result2 = super.charTyped(c, project, editor, file);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"charTyped(...)");
        return result2;
    }

    private final boolean shouldInsertAdditionalSlash(PsiFile file, int offset) {
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return false;
        }
        PsiElement literal = psiElement;
        IElementType iElementType = literal.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType tokenType = iElementType;
        return Intrinsics.areEqual((Object)tokenType, (Object)GroovyElementTypes.STRING_SQ) && literal.getTextRange().getEndOffset() - offset == 1 || Intrinsics.areEqual((Object)tokenType, (Object)GroovyElementTypes.STRING_TSQ) && literal.getTextRange().getEndOffset() - offset == 3;
    }
}

