/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.codeInspection.options.CommonOptionPanes;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.util.InvalidDataException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;

public abstract class ConventionInspection
extends BaseInspection {
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    @NonNls
    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    protected String getRegex() {
        return this.m_regex;
    }

    protected int getMinLength() {
        return this.m_minLength;
    }

    protected int getMaxLength() {
        return this.m_maxLength;
    }

    protected boolean isValid(String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (length > this.m_maxLength) {
            return false;
        }
        if ("SerialVersionUID".equals(name)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ConventionInspection.$$$reportNull$$$0(0);
        }
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    @Override
    @NotNull
    public OptPane getGroovyOptionsPane() {
        OptPane optPane = CommonOptionPanes.conventions((String)"m_minLength", (String)"m_maxLength", (String)"m_regex", (OptRegularComponent[])new OptRegularComponent[0]);
        if (optPane == null) {
            ConventionInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValueSet("m_regex", value2 -> {
            try {
                this.m_regexPattern = Pattern.compile(this.m_regex);
            }
            catch (PatternSyntaxException ignore) {
                this.m_regex = this.getDefaultRegex();
                this.m_regexPattern = Pattern.compile(this.m_regex);
            }
        });
        if (optionController == null) {
            ConventionInspection.$$$reportNull$$$0(2);
        }
        return optionController;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/naming/ConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/naming/ConventionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

