/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.JavaLineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInsight.GroovyMarkerTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableDeclarationImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

final class GroovyLineMarkerProvider
extends JavaLineMarkerProvider {
    GroovyLineMarkerProvider() {
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            GroovyLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)element.getProject())) {
            return null;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof PsiNameIdentifierOwner) {
            if (parent2 instanceof GrField && element == ((GrField)parent2).getNameIdentifierGroovy()) {
                for (GrAccessorMethod method : GroovyPropertyUtils.getFieldAccessors((GrField)parent2)) {
                    MethodSignatureBackedByPsiMethod superSignature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
                    if (superSignature == null) continue;
                    PsiMethod superMethod = superSignature.getMethod();
                    boolean overrides = method.hasModifierProperty("abstract") == superMethod.hasModifierProperty("abstract") || superMethod.getBody() != null && GrTraitUtil.isTrait(superMethod.getContainingClass());
                    Icon icon = overrides ? AllIcons.Gutter.OverridingMethod : AllIcons.Gutter.ImplementingMethod;
                    MarkerType type2 = GroovyMarkerTypes.OVERRIDING_PROPERTY_TYPE;
                    return new LineMarkerInfo(element, element.getTextRange(), icon, type2.getTooltip(), type2.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
                }
            } else if (parent2 instanceof GrMethod && element == ((GrMethod)parent2).getNameIdentifierGroovy() && GroovyLineMarkerProvider.hasSuperMethods((GrMethod)element.getParent())) {
                Icon icon = AllIcons.Gutter.OverridingMethod;
                MarkerType type3 = GroovyMarkerTypes.GR_OVERRIDING_METHOD;
                return new LineMarkerInfo(element, element.getTextRange(), icon, type3.getTooltip(), type3.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
            }
        }
        if (DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS && element.getFirstChild() == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!((element1 = element1.getParent()) instanceof PsiMember) && !(element1 instanceof GrVariableDeclarationImpl)) continue;
                isMember = true;
                break;
            }
            if (isMember && !(element1 instanceof PsiAnonymousClass) && !(element1.getParent() instanceof PsiAnonymousClass)) {
                PsiFile file = element1.getContainingFile();
                Document document = file == null ? null : PsiDocumentManager.getInstance((Project)file.getProject()).getLastCommittedDocument(file);
                boolean drawSeparator = false;
                if (document != null) {
                    CharSequence documentChars = document.getCharsSequence();
                    int category = GroovyLineMarkerProvider.getGroovyCategory(element1, documentChars);
                    for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                        int category1 = GroovyLineMarkerProvider.getGroovyCategory(child, documentChars);
                        if (category1 == 0) continue;
                        drawSeparator = category != 1 || category1 != 1;
                        break;
                    }
                }
                if (drawSeparator) {
                    GrDocComment comment = null;
                    if (element1 instanceof GrDocCommentOwner) {
                        comment = ((GrDocCommentOwner)element1).getDocComment();
                    }
                    LineMarkerInfo info = new LineMarkerInfo(element, comment != null ? comment.getTextRange() : element.getTextRange(), null, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                    info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        return null;
    }

    private static boolean hasSuperMethods(@NotNull GrMethod method) {
        GrReflectedMethod[] reflectedMethods;
        if (method == null) {
            GroovyLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((reflectedMethods = method.getReflectedMethods()).length > 0) {
            for (GrReflectedMethod reflectedMethod : reflectedMethods) {
                MethodSignatureBackedByPsiMethod first = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)reflectedMethod, null, (boolean)true, (boolean)false).findFirst();
                if (first == null) continue;
                return true;
            }
            return false;
        }
        return SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
    }

    private static int getGroovyCategory(@NotNull PsiElement element, @NotNull CharSequence documentChars) {
        GrVariable[] variables;
        if (element == null) {
            GroovyLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (documentChars == null) {
            GroovyLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (element instanceof GrVariableDeclarationImpl && (variables = ((GrVariableDeclarationImpl)element).getVariables()).length == 1 && variables[0] instanceof GrField && variables[0].getInitializerGroovy() instanceof GrClosableBlock) {
            return 2;
        }
        if (element instanceof GrField || element instanceof GrTypeParameter) {
            return 1;
        }
        if (element instanceof GrTypeDefinition || element instanceof GrClassInitializer) {
            return 2;
        }
        if (element instanceof GrMethod) {
            int end;
            if (((GrMethod)element).hasModifierProperty("abstract") && (((GrMethod)element).getBlock() == null || !GrTraitUtil.isTrait(((GrMethod)element).getContainingClass()))) {
                return 1;
            }
            TextRange textRange = element.getTextRange();
            int start = textRange.getStartOffset();
            int crlf = StringUtil.getLineBreakCount((CharSequence)documentChars.subSequence(start, end = Math.min(documentChars.length(), textRange.getEndOffset())));
            return crlf == 0 ? 1 : 2;
        }
        return 0;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        PsiElement first;
        if (elements == null) {
            GroovyLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            GroovyLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if ((first = (PsiElement)ContainerUtil.getFirstItem(elements)) != null && DumbService.isDumb((Project)first.getProject())) {
            return;
        }
        HashSet<PsiMethod> methods = new HashSet<PsiMethod>();
        for (PsiElement psiElement : elements) {
            ProgressManager.checkCanceled();
            if (psiElement instanceof GrField) {
                methods.addAll(GroovyPropertyUtils.getFieldAccessors((GrField)psiElement));
                continue;
            }
            if (psiElement instanceof GrMethod) {
                GrReflectedMethod[] reflected = ((GrMethod)psiElement).getReflectedMethods();
                if (reflected.length != 0) {
                    Collections.addAll(methods, reflected);
                    continue;
                }
                methods.add((PsiMethod)psiElement);
                continue;
            }
            if (!(psiElement instanceof PsiClass) || psiElement instanceof PsiTypeParameter) continue;
            result2.addAll(this.collectInheritingClasses((PsiClass)psiElement));
        }
        GroovyLineMarkerProvider.collectOverridingMethods(methods, result2);
    }

    private static void collectOverridingMethods(@NotNull Set<? extends PsiMethod> methods, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (methods == null) {
            GroovyLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            GroovyLineMarkerProvider.$$$reportNull$$$0(7);
        }
        HashSet overridden = new HashSet();
        HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
        for (PsiMethod psiMethod : methods) {
            ProgressManager.checkCanceled();
            PsiClass parentClass = psiMethod.getContainingClass();
            if (parentClass == null || "java.lang.Object".equals(parentClass.getQualifiedName())) continue;
            classes2.add(parentClass);
        }
        for (PsiClass psiClass : classes2) {
            AllOverridingMethodsSearch.search((PsiClass)psiClass).forEach(pair -> {
                ProgressManager.checkCanceled();
                PsiMethod superMethod = (PsiMethod)pair.getFirst();
                if (GroovyLineMarkerProvider.isCorrectTarget(superMethod) && GroovyLineMarkerProvider.isCorrectTarget((PsiMethod)pair.getSecond()) && methods.remove(superMethod)) {
                    overridden.add(PsiImplUtil.handleMirror((PsiElement)superMethod));
                }
                return !methods.isEmpty();
            });
        }
        for (PsiElement psiElement : overridden) {
            Icon icon = AllIcons.Gutter.OverridenMethod;
            PsiElement psiElement2 = PsiImplUtil.handleMirror((PsiElement)psiElement);
            PsiElement range = psiElement2 instanceof GrNamedElement ? ((GrNamedElement)psiElement2).getNameIdentifierGroovy() : psiElement2;
            MarkerType type2 = psiElement2 instanceof GrField ? GroovyMarkerTypes.OVERRIDEN_PROPERTY_TYPE : GroovyMarkerTypes.GR_OVERRIDDEN_METHOD;
            LineMarkerInfo info = new LineMarkerInfo(range, range.getTextRange(), icon, type2.getTooltip(), type2.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            result2.add(info);
        }
    }

    private static boolean isCorrectTarget(@NotNull PsiMethod method) {
        if (method == null) {
            GroovyLineMarkerProvider.$$$reportNull$$$0(8);
        }
        if (method instanceof GrTraitMethod) {
            return false;
        }
        PsiElement navigationElement = method.getNavigationElement();
        return method.isPhysical() || navigationElement.isPhysical() && !(navigationElement instanceof PsiClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentChars";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInsight/GroovyLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuperMethods";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroovyCategory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "collectOverridingMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCorrectTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

