/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.injected.ConcatenationInjectorManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;

public final class GrConcatenation2InjectorAdapter
extends ConcatenationInjectorManager.BaseConcatenation2InjectorAdapter
implements MultiHostInjector {
    private static final List<Class<? extends GrLiteralContainer>> LITERALS = Arrays.asList(GrLiteral.class, GrStringContent.class);

    public GrConcatenation2InjectorAdapter(@NotNull Project project) {
        if (project == null) {
            GrConcatenation2InjectorAdapter.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends GrLiteralContainer>> list = LITERALS;
        if (list == null) {
            GrConcatenation2InjectorAdapter.$$$reportNull$$$0(1);
        }
        return list;
    }

    protected Pair<PsiElement, PsiElement[]> computeAnchorAndOperands(@NotNull PsiElement context) {
        PsiElement anchor;
        PsiElement[] operands;
        if (context == null) {
            GrConcatenation2InjectorAdapter.$$$reportNull$$$0(2);
        }
        PsiElement element = context;
        PsiElement parent2 = context.getParent();
        while (parent2 instanceof GrBinaryExpression && ((GrBinaryExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mPLUS || parent2 instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mPLUS_ASSIGN || parent2 instanceof GrConditionalExpression && ((GrConditionalExpression)parent2).getCondition() != element || parent2 instanceof GrTypeCastExpression || parent2 instanceof GrSafeCastExpression || parent2 instanceof GrParenthesizedExpression || parent2 instanceof GrString) {
            element = parent2;
            parent2 = parent2.getParent();
        }
        if (element instanceof GrBinaryExpression) {
            operands = GrConcatenation2InjectorAdapter.collectBinaryOperands((GrBinaryExpression)element);
            anchor = element;
        } else if (element instanceof GrString) {
            operands = GrConcatenation2InjectorAdapter.collectGStringOperands((GrString)element);
            anchor = element;
        } else if (element instanceof GrAssignmentExpression) {
            GrExpression rvalue = ((GrAssignmentExpression)element).getRValue();
            operands = new PsiElement[]{rvalue == null ? element : rvalue};
            anchor = element;
        } else if (element instanceof GrLiteral && ((GrLiteral)element).isValidHost()) {
            operands = new PsiElement[]{context};
            anchor = context;
        } else {
            return Pair.create((Object)context, (Object)PsiElement.EMPTY_ARRAY);
        }
        return Pair.create((Object)anchor, (Object)operands);
    }

    private static PsiElement[] collectGStringOperands(GrString grString) {
        ArrayList operands = new ArrayList();
        GrConcatenation2InjectorAdapter.processGString(grString, operands);
        return operands.toArray(PsiElement.EMPTY_ARRAY);
    }

    private static void processGString(GrString string, ArrayList<? super PsiElement> operands) {
        ContainerUtil.addAll(operands, (Object[])string.getAllContentParts());
    }

    private static PsiElement[] collectBinaryOperands(GrBinaryExpression expression) {
        ArrayList operands = new ArrayList();
        GrConcatenation2InjectorAdapter.processBinary(expression, operands);
        return operands.toArray(PsiElement.EMPTY_ARRAY);
    }

    private static void processBinary(GrBinaryExpression expression, ArrayList<? super PsiElement> operands) {
        GrExpression left = expression.getLeftOperand();
        GrExpression right = expression.getRightOperand();
        if (left instanceof GrBinaryExpression) {
            GrConcatenation2InjectorAdapter.processBinary((GrBinaryExpression)left, operands);
        } else if (left instanceof GrString) {
            GrConcatenation2InjectorAdapter.processGString((GrString)left, operands);
        } else {
            operands.add(left);
        }
        if (right instanceof GrBinaryExpression) {
            GrConcatenation2InjectorAdapter.processBinary((GrBinaryExpression)right, operands);
        } else if (right instanceof GrString) {
            GrConcatenation2InjectorAdapter.processGString((GrString)right, operands);
        } else if (right != null) {
            operands.add(right);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/groovy/GrConcatenation2InjectorAdapter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/groovy/GrConcatenation2InjectorAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeAnchorAndOperands";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

