/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.P4RootChecker;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.P4ParamsCalculator;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceLocalConnection;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002J2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J\u001d\u0010\r\u001a\u00020\u000e2\u000b\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J2\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/perforce/perforce/P4RootChecker;", "Lcom/intellij/openapi/vcs/VcsRootChecker;", "()V", "collectUnmappedDirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "mappedDirs", "", "projectRoots", "", "detectContextConnectionMappings", "project", "Lcom/intellij/openapi/project/Project;", "detectEnvConnectionParametersFor", "Lorg/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters;", "baseDir", "", "Lorg/jetbrains/annotations/SystemIndependent;", "settings", "Lorg/jetbrains/idea/perforce/perforce/PerforceSettings;", "detectMappingsForConnection", "connection", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "unmappedRoots", "detectProjectMappings", "detectSingletonConnectionMappings", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "isRoot", "", "file", "parseP4Info", "output", "validateRoot", "Companion", "intellij.vcs.perforce"})
@SourceDebugExtension(value={"SMAP\nP4RootChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P4RootChecker.kt\norg/jetbrains/idea/perforce/perforce/P4RootChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,133:1\n766#2:134\n857#2,2:135\n766#2:137\n857#2:138\n858#2:141\n2159#3,2:139\n*S KotlinDebug\n*F\n+ 1 P4RootChecker.kt\norg/jetbrains/idea/perforce/perforce/P4RootChecker\n*L\n103#1:134\n103#1:135,2\n124#1:137\n124#1:138\n124#1:141\n126#1:139,2\n*E\n"})
public final class P4RootChecker
extends VcsRootChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = PerforceVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        return vcsKey;
    }

    public boolean isRoot(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return false;
    }

    public boolean validateRoot(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @NotNull
    public Collection<VirtualFile> detectProjectMappings(@NotNull Project project, @NotNull Collection<? extends VirtualFile> projectRoots, @NotNull Set<? extends VirtualFile> mappedDirs) {
        Collection<VirtualFile> collection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(projectRoots, (String)"projectRoots");
        Intrinsics.checkNotNullParameter(mappedDirs, (String)"mappedDirs");
        try {
            Collection<VirtualFile> collection2;
            PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(project);
            if (connectionManager.isSingletonConnectionUsed()) {
                LOG.debug("detecting for singleton connection");
                collection2 = this.detectSingletonConnectionMappings(project, projectRoots, mappedDirs);
            } else {
                LOG.debug("detecting for context connection");
                collection2 = this.detectContextConnectionMappings(project, projectRoots, mappedDirs);
            }
            collection = collection2;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            collection = CollectionsKt.emptyList();
        }
        Collection<VirtualFile> mappedRoots = collection;
        if (PerforceManager.getInstance(project).isActive()) {
            PerforceConnectionManager.getInstance(project).updateConnections();
        }
        return mappedRoots;
    }

    private final Collection<VirtualFile> detectSingletonConnectionMappings(Project project, Collection<? extends VirtualFile> projectRoots, Set<? extends VirtualFile> mappedDirs) {
        List<VirtualFile> unmappedRoots = this.collectUnmappedDirs(mappedDirs, projectRoots);
        if (unmappedRoots.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PerforceSettings settings = PerforceSettings.getSettings(project);
        SingletonConnection singletonConnection = SingletonConnection.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)singletonConnection, (String)"getInstance(...)");
        P4Connection connection = singletonConnection;
        Intrinsics.checkNotNull((Object)settings);
        return this.detectMappingsForConnection(connection, settings, unmappedRoots);
    }

    private final Collection<VirtualFile> detectContextConnectionMappings(Project project, Collection<? extends VirtualFile> projectRoots, Set<? extends VirtualFile> mappedDirs) {
        String string = project.getBasePath();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String baseDir = string;
        List<VirtualFile> unmappedRoots = this.collectUnmappedDirs(mappedDirs, projectRoots);
        if (unmappedRoots.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PerforceSettings settings = PerforceSettings.getSettings(project);
        Intrinsics.checkNotNull((Object)settings);
        P4ConnectionParameters parameters = this.detectEnvConnectionParametersFor(baseDir, settings);
        LOG.debug("detected connection parameters: " + parameters);
        P4ParametersConnection testConnection = new P4ParametersConnection(parameters, new ConnectionId(null, baseDir));
        return this.detectMappingsForConnection(testConnection, settings, unmappedRoots);
    }

    private final P4ConnectionParameters detectEnvConnectionParametersFor(String baseDir, PerforceSettings settings) {
        P4Connection localConnection = new PerforceLocalConnection(baseDir);
        String[] stringArray = new String[]{"set"};
        ExecResult p4SetOut = localConnection.runP4CommandLine(settings, stringArray, null);
        P4ConnectionParameters defaultParameters = new P4ConnectionParameters();
        P4ConnectionParameters parameters = new P4ConnectionParameters();
        P4ParamsCalculator.parseSetOutput(defaultParameters, parameters, p4SetOut.getStdout());
        return parameters;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> detectMappingsForConnection(P4Connection connection, PerforceSettings settings, List<? extends VirtualFile> unmappedRoots) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"info"};
        ExecResult p4InfoOut = connection.runP4CommandLine(settings, stringArray, null);
        String string = p4InfoOut.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String string2 = this.parseP4Info(string);
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String root = string2;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(root);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile rootFile = virtualFile;
        LOG.debug("found root file: " + rootFile.getPath());
        Iterable $this$filter$iv = unmappedRoots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!VfsUtil.isAncestor((VirtualFile)rootFile, (VirtualFile)it, (boolean)false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String parseP4Info(String output) {
        String result = null;
        for (String line : StringsKt.lineSequence((CharSequence)output)) {
            String path;
            if (!StringsKt.startsWith$default((String)line, (String)"Client root:", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)"Client root:"))).toString()), (String)"toSystemIndependentName(...)");
            if (result != null) {
                LOG.warn("unexpected: two roots in output: '" + result + "' and '" + path + "'");
                return null;
            }
            result = path;
        }
        LOG.debug("parseP4Info - root path: " + result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectUnmappedDirs(Set<? extends VirtualFile> mappedDirs, Collection<? extends VirtualFile> projectRoots) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = projectRoots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block2: {
                void $this$none$iv;
                VirtualFile root = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                Sequence sequence = SequencesKt.generateSequence((Object)root, (Function1)collectUnmappedDirs.1.1.INSTANCE);
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    VirtualFile parent = (VirtualFile)element$iv;
                    boolean bl3 = false;
                    if (!mappedDirs.contains(parent)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger = Logger.getInstance(P4RootChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/perforce/perforce/P4RootChecker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

