/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.demo;

import com.michaelbaranov.microba.calendar.CalendarPane;
import com.michaelbaranov.microba.calendar.DatePicker;
import com.michaelbaranov.microba.calendar.DatePickerCellEditor;
import com.michaelbaranov.microba.calendar.HolidayPolicy;
import com.michaelbaranov.microba.common.AbstractPolicy;
import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.gradienteditor.GradientEditor;
import com.michaelbaranov.microba.marker.MarkerBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Demo
extends JApplet {
    static MarkerBar bar;
    static BoundedTableModel model;
    private static JFrame frame;
    private static JPanel panel;

    public static void main(String[] s) {
        Demo demo = new Demo();
        demo.run();
    }

    private void run() {
        frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("CalendarPane", this.buildCalendarPaneTab());
        tabs.addTab("Gradient", this.buildGradientTab());
        tabs.addTab("CellEditor", this.buildCellEditorTab());
        tabs.addTab("DatePicker", this.buildDatePickerTab());
        frame.getContentPane().add((Component)tabs, "Center");
        frame.setSize(500, 300);
        frame.setVisible(true);
    }

    @Override
    public void start() {
        System.out.println("start");
        super.start();
    }

    @Override
    public void stop() {
        System.out.println("stop");
        super.stop();
    }

    private JComponent buildCalendarPaneTab() {
        JPanel panel = new JPanel();
        final CalendarPane calendarPane = new CalendarPane();
        calendarPane.setHolidayPolicy(new Hol());
        HashMap<String, Color> ov = new HashMap<String, Color>();
        ov.put("calendar.grid.foreground.enabled", Color.ORANGE);
        calendarPane.setColorOverrideMap(ov);
        try {
            calendarPane.setDate(new Date());
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        calendarPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("CalendarPane:" + calendarPane.getDate());
            }
        });
        panel.setLayout(new GridBagLayout());
        panel.add((Component)calendarPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JComponent buildDatePickerTab() {
        JPanel panel = new JPanel();
        final DatePicker datePicker = new DatePicker();
        datePicker.setDateFormat(SimpleDateFormat.getDateTimeInstance());
        datePicker.setEnabled(false);
        datePicker.setKeepTime(true);
        datePicker.setStripTime(false);
        datePicker.setShowNumberOfWeek(true);
        HashMap<String, Color> ov = new HashMap<String, Color>();
        ov.put("calendar.grid.foreground.enabled", Color.ORANGE);
        datePicker.setColorOverrideMap(ov);
        panel.setLayout(new GridBagLayout());
        panel.add((Component)datePicker, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        datePicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("DatePicker:" + datePicker.getDate());
            }
        });
        return panel;
    }

    private JComponent buildCellEditorTab() {
        JPanel panel = new JPanel();
        DatePicker datePicker = new DatePicker();
        datePicker.setDropdownFocusable(true);
        DatePickerCellEditor cellEditor = new DatePickerCellEditor(datePicker);
        cellEditor.setClickCountToStart(2);
        JTable table = new JTable(100, 3);
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane scrollPane = new JScrollPane(table);
        table.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        panel.setLayout(new GridBagLayout());
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JComponent buildGradientTab() {
        JPanel panel = new JPanel();
        JColorChooser colorChooser = new JColorChooser();
        GradientEditor editor = new GradientEditor();
        ColorAdaptor adaptor = new ColorAdaptor(editor, colorChooser);
        panel.add((Component)editor, "North");
        panel.add((Component)colorChooser, "Center");
        MarkerBar bar = new MarkerBar();
        bar.setDataModel(editor.getDataModel());
        bar.setPositionColumn(editor.getColorPositionColumn());
        bar.setColorColumn(editor.getColorColumn());
        bar.setFliped(true);
        bar.setOrientation(1);
        panel.add((Component)bar, "East");
        return panel;
    }

    private class Hol
    extends AbstractPolicy
    implements HolidayPolicy {
        private Hol() {
        }

        @Override
        public String getHollidayName(Object source, Calendar date) {
            return null;
        }

        @Override
        public boolean isHolliday(Object source, Calendar date) {
            return false;
        }

        @Override
        public boolean isWeekend(Object source, Calendar date) {
            return date.get(7) == 1;
        }
    }

    private static class ColorAdaptor
    implements ChangeListener,
    ListSelectionListener {
        private GradientEditor editor;
        private JColorChooser chooser;

        public ColorAdaptor(GradientEditor editor, JColorChooser chooser) {
            this.editor = editor;
            this.chooser = chooser;
            editor.getColorSelectionModel().addListSelectionListener(this);
            chooser.getSelectionModel().addChangeListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index = this.editor.getColorSelectionModel().getLeadSelectionIndex();
            Color c = (Color)this.editor.getDataModel().getValueAt(index, this.editor.getColorColumn());
            this.chooser.setColor(c);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!this.editor.getColorSelectionModel().isSelectionEmpty()) {
                int index = this.editor.getColorSelectionModel().getLeadSelectionIndex();
                this.editor.getDataModel().setValueAt(this.chooser.getColor(), index, this.editor.getColorColumn());
            }
        }
    }
}

