/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.LazyBeanEntry;

final class BeanCache<Q extends Annotation, T>
extends AtomicReference<Object> {
    private static final long serialVersionUID = 1L;
    private Map<Binding<T>, BeanEntry<Q, T>> readCache;
    private volatile boolean mutated;

    BeanCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanEntry<Q, T> create(Q qualifier, Binding<T> binding, int rank) {
        LazyBeanEntry<Q, T> newBean;
        Object n2;
        Object o2;
        do {
            if ((o2 = this.get()) == null) {
                newBean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
                n2 = newBean;
                continue;
            }
            if (o2 instanceof LazyBeanEntry) {
                LazyBeanEntry oldBean = (LazyBeanEntry)o2;
                if (binding == oldBean.binding) {
                    return oldBean;
                }
                newBean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
                n2 = BeanCache.createMap(oldBean, newBean);
                continue;
            }
            BeanCache beanCache = this;
            synchronized (beanCache) {
                Map map2 = (Map)o2;
                newBean = (LazyBeanEntry<Q, T>)map2.get(binding);
                if (newBean == null) {
                    newBean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
                    map2.put(binding, newBean);
                    this.mutated = true;
                }
                return newBean;
            }
        } while (!this.compareAndSet(o2, n2));
        if (n2 instanceof IdentityHashMap) {
            this.mutated = true;
        }
        return newBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Binding<T>, BeanEntry<Q, T>> flush() {
        if (this.mutated) {
            BeanCache beanCache = this;
            synchronized (beanCache) {
                if (this.mutated) {
                    this.readCache = (Map)((IdentityHashMap)this.get()).clone();
                    this.mutated = false;
                }
            }
        }
        return this.readCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Binding<T>> bindings() {
        Object o2 = this.get();
        if (o2 == null) {
            return Collections.EMPTY_SET;
        }
        if (o2 instanceof LazyBeanEntry) {
            return Collections.singleton(((LazyBeanEntry)o2).binding);
        }
        BeanCache beanCache = this;
        synchronized (beanCache) {
            return new ArrayList<Binding<T>>(((Map)o2).keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanEntry<Q, T> remove(Binding<T> binding) {
        LazyBeanEntry oldBean;
        Object n2;
        Object o2;
        do {
            if ((o2 = this.get()) == null) {
                return null;
            }
            if (o2 instanceof LazyBeanEntry) {
                oldBean = (LazyBeanEntry)o2;
                if (binding != oldBean.binding) {
                    return null;
                }
            } else {
                BeanCache beanCache = this;
                synchronized (beanCache) {
                    oldBean = (LazyBeanEntry)((Map)o2).remove(binding);
                    if (oldBean != null) {
                        this.mutated = true;
                    }
                    return oldBean;
                }
            }
            n2 = null;
        } while (!this.compareAndSet(o2, n2));
        return oldBean;
    }

    private static Map createMap(LazyBeanEntry one, LazyBeanEntry two) {
        IdentityHashMap map2 = new IdentityHashMap(10);
        map2.put(one.binding, one);
        map2.put(two.binding, two);
        return map2;
    }
}

