/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public final class CompactDataOutput
implements DataOutput {
    private final OutputStream out;
    private final byte[] writeBuffer = IOUtil.allocReadWriteUTFBuffer();

    public CompactDataOutput(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b2) throws IOException {
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.out.write(b2, off, len);
    }

    @Override
    public void writeBoolean(boolean v2) throws IOException {
        this.out.write(v2 ? 1 : 0);
    }

    @Override
    public void writeByte(int v2) throws IOException {
        this.out.write(v2);
    }

    @Override
    public void writeShort(int v2) throws IOException {
        this.out.write(v2 >>> 8 & 0xFF);
        this.out.write(v2 & 0xFF);
    }

    @Override
    public void writeChar(int v2) throws IOException {
        this.out.write(v2 >>> 8 & 0xFF);
        this.out.write(v2 & 0xFF);
    }

    @Override
    public void writeInt(int val) throws IOException {
        DataInputOutputUtil.writeINT(this, val);
    }

    @Override
    public void writeLong(long v2) throws IOException {
        this.writeBuffer[0] = (byte)(v2 >>> 56);
        this.writeBuffer[1] = (byte)(v2 >>> 48);
        this.writeBuffer[2] = (byte)(v2 >>> 40);
        this.writeBuffer[3] = (byte)(v2 >>> 32);
        this.writeBuffer[4] = (byte)(v2 >>> 24);
        this.writeBuffer[5] = (byte)(v2 >>> 16);
        this.writeBuffer[6] = (byte)(v2 >>> 8);
        this.writeBuffer[7] = (byte)v2;
        this.out.write(this.writeBuffer, 0, 8);
    }

    @Override
    public void writeFloat(float v2) throws IOException {
        this.writeInt(Float.floatToIntBits(v2));
    }

    @Override
    public void writeDouble(double v2) throws IOException {
        this.writeLong(Double.doubleToLongBits(v2));
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            this.out.write((byte)s2.charAt(i2));
        }
    }

    @Override
    public void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char v2 = s2.charAt(i2);
            this.out.write(v2 >>> 8 & 0xFF);
            this.out.write(v2 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String s2) throws IOException {
        IOUtil.writeUTFFast(this.writeBuffer, (DataOutput)this, s2);
    }
}

