/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.IndexStorageLayout;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.ValueSerializationChecker;
import com.intellij.util.indexing.impl.ValueSerializationProblemReporter;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.impl.forward.IntForwardIndexAccessor;
import com.intellij.util.io.MeasurableIndexStore;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class MapReduceIndex<Key, Value, Input>
implements InvertedIndex<Key, Value, Input>,
MeasurableIndexStore {
    private static final Logger LOG = Logger.getInstance(MapReduceIndex.class);
    private static final boolean USE_READ_LOCK_ON_UPDATE = SystemProperties.getBooleanProperty("idea.map.reduce.index.use.read.lock.on.update", false);
    protected final IndexId<Key, Value> myIndexId;
    protected final IndexStorage<Key, Value> myStorage;
    protected final AtomicLong myModificationStamp;
    protected final DataIndexer<Key, Value, Input> myIndexer;
    @Nullable
    private final ValueSerializationChecker<Value, Input> myValueSerializationChecker;
    private final IndexExtension<Key, Value, Input> myExtension;
    @Nullable
    private final ForwardIndex myForwardIndex;
    private final ForwardIndexAccessor<Key, Value> myForwardIndexAccessor;
    private final ReadWriteLock myLock;
    private final boolean myUseIntForwardIndex;
    private volatile boolean myDisposed;
    private final LowMemoryWatcher myLowMemoryFlusher;
    private final RemovedKeyProcessor<Key> myRemovedKeyProcessor;
    private final KeyValueUpdateProcessor<Key, Value> myAddedKeyProcessor;
    private final KeyValueUpdateProcessor<Key, Value> myUpdatedKeyProcessor;

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorageLayout<Key, Value> indexStorageLayout) throws IOException {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(0);
        }
        if (indexStorageLayout == null) {
            MapReduceIndex.$$$reportNull$$$0(1);
        }
        this(extension, indexStorageLayout.openIndexStorage(), indexStorageLayout.openForwardIndex(), indexStorageLayout.getForwardIndexAccessor());
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage2, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) throws IOException {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(2);
        }
        if (storage2 == null) {
            MapReduceIndex.$$$reportNull$$$0(3);
        }
        this(extension, () -> storage2, (ThrowableComputable<? extends ForwardIndex, ? extends IOException>)((ThrowableComputable)() -> forwardIndex), forwardIndexAccessor);
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull ThrowableComputable<? extends IndexStorage<Key, Value>, ? extends IOException> storage2, @Nullable ThrowableComputable<? extends ForwardIndex, ? extends IOException> forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) throws IOException {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(4);
        }
        if (storage2 == null) {
            MapReduceIndex.$$$reportNull$$$0(5);
        }
        this.myModificationStamp = new AtomicLong();
        this.myRemovedKeyProcessor = new RemovedKeyProcessor<Key>(){

            @Override
            public void process(Key key, int inputId) throws StorageException {
                MapReduceIndex.this.incrementModificationStamp();
                MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
            }
        };
        this.myAddedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.incrementModificationStamp();
                MapReduceIndex.this.myStorage.addValue(key, inputId, value);
            }
        };
        this.myUpdatedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.incrementModificationStamp();
                MapReduceIndex.this.myStorage.updateValue(key, inputId, value);
            }
        };
        this.myIndexId = extension.getName();
        this.myExtension = extension;
        this.myIndexer = this.myExtension.getIndexer();
        this.myStorage = (IndexStorage)storage2.compute();
        try {
            this.myForwardIndex = forwardIndex == null ? null : (ForwardIndex)forwardIndex.compute();
        }
        catch (IOException e2) {
            this.tryDispose();
            throw e2;
        }
        this.myForwardIndexAccessor = forwardIndexAccessor;
        this.myUseIntForwardIndex = this.myForwardIndex instanceof IntForwardIndex && this.myForwardIndexAccessor instanceof IntForwardIndexAccessor;
        LOG.assertTrue(this.myForwardIndex instanceof IntForwardIndex == this.myForwardIndexAccessor instanceof IntForwardIndexAccessor, "Invalid index configuration for " + this.myIndexId);
        this.myLock = new ReentrantReadWriteLock();
        this.myValueSerializationChecker = new ValueSerializationChecker(extension, this.getSerializationProblemReporter());
        this.myLowMemoryFlusher = LowMemoryWatcher.register(() -> this.clearCaches());
    }

    public void clearCaches() {
        try {
            ConcurrencyUtil.withLock(this.myLock.readLock(), () -> this.myStorage.clearCaches());
            this.flush();
        }
        catch (Throwable e2) {
            this.requestRebuild(e2);
        }
    }

    @NotNull
    protected ValueSerializationProblemReporter getSerializationProblemReporter() {
        ValueSerializationProblemReporter valueSerializationProblemReporter = ValueSerializationChecker.DEFAULT_SERIALIZATION_PROBLEM_REPORTER;
        if (valueSerializationProblemReporter == null) {
            MapReduceIndex.$$$reportNull$$$0(6);
        }
        return valueSerializationProblemReporter;
    }

    protected void tryDispose() {
        try {
            this.dispose();
        }
        catch (Exception e2) {
            LOG.info(e2);
        }
    }

    @Nullable
    public ForwardIndex getForwardIndex() {
        return this.myForwardIndex;
    }

    public ForwardIndexAccessor<Key, Value> getForwardIndexAccessor() {
        return this.myForwardIndexAccessor;
    }

    @NotNull
    public IndexExtension<Key, Value, Input> getExtension() {
        IndexExtension<Key, Value, Input> indexExtension = this.myExtension;
        if (indexExtension == null) {
            MapReduceIndex.$$$reportNull$$$0(7);
        }
        return indexExtension;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        IndexStorage<Key, Value> indexStorage = this.myStorage;
        if (indexStorage == null) {
            MapReduceIndex.$$$reportNull$$$0(8);
        }
        return indexStorage;
    }

    @NotNull
    public final ReadWriteLock getLock() {
        ReadWriteLock readWriteLock = this.myLock;
        if (readWriteLock == null) {
            MapReduceIndex.$$$reportNull$$$0(9);
        }
        return readWriteLock;
    }

    @Override
    public void clear() {
        ConcurrencyUtil.withLock(this.myLock.writeLock(), () -> {
            try {
                this.incrementModificationStamp();
                this.doClear();
            }
            catch (StorageException | IOException e2) {
                LOG.info(e2);
            }
        });
    }

    protected void doClear() throws StorageException, IOException {
        this.myStorage.clear();
        if (this.myForwardIndex != null) {
            this.myForwardIndex.clear();
        }
    }

    @Override
    public void flush() throws StorageException {
        ConcurrencyUtil.withLock(this.myLock.readLock(), () -> {
            try {
                this.doFlush();
            }
            catch (IOException e2) {
                throw new StorageException(e2);
            }
            catch (RuntimeException e3) {
                Throwable cause = e3.getCause();
                if (cause instanceof StorageException || cause instanceof IOException) {
                    throw new StorageException(cause);
                }
                throw e3;
            }
        });
    }

    public boolean isDirty() {
        if (this.myForwardIndex != null && this.myForwardIndex.isDirty()) {
            return true;
        }
        return this.myStorage.isDirty();
    }

    protected void doFlush() throws IOException, StorageException {
        if (this.myForwardIndex != null) {
            this.myForwardIndex.force();
        }
        this.myStorage.flush();
    }

    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        ConcurrencyUtil.withLock(this.myLock.writeLock(), () -> {
            try {
                this.myDisposed = true;
                this.doDispose();
            }
            catch (StorageException e2) {
                LOG.error(e2);
            }
        });
    }

    @Override
    public int keysCountApproximately() {
        return MeasurableIndexStore.keysCountApproximatelyIfPossible(this.myStorage);
    }

    protected boolean isDisposed() {
        return this.myDisposed;
    }

    protected void doDispose() throws StorageException {
        try {
            this.myStorage.close();
        }
        catch (IOException e2) {
            throw new StorageException(e2);
        }
        finally {
            try {
                if (this.myForwardIndex != null) {
                    this.myForwardIndex.close();
                }
            }
            catch (IOException e3) {
                LOG.error(e3);
            }
        }
    }

    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            MapReduceIndex.$$$reportNull$$$0(10);
        }
        ValueContainer valueContainer = (ValueContainer)ConcurrencyUtil.withLock(this.myLock.readLock(), () -> {
            try {
                if (this.isDisposed()) {
                    ValueContainerImpl valueContainerImpl = ValueContainerImpl.createNewValueContainer();
                    return valueContainerImpl;
                }
                IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
                ValueContainer<Value> valueContainer = this.myStorage.read(key);
                return valueContainer;
            }
            finally {
                IndexDebugProperties.DEBUG_INDEX_ID.set(null);
            }
        });
        if (valueContainer == null) {
            MapReduceIndex.$$$reportNull$$$0(11);
        }
        return valueContainer;
    }

    @Override
    @NotNull
    public Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable Input content) throws MapReduceIndexMappingException, ProcessCanceledException {
        InputData<Key, Value> data2;
        try {
            data2 = this.mapInput(inputId, content);
        }
        catch (ProcessCanceledException | MapReduceIndexMappingException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new MapReduceIndexMappingException(e3, this.myExtension.getClass());
        }
        Computable computable = this.prepareUpdate(inputId, (InputData)data2);
        if (computable == null) {
            MapReduceIndex.$$$reportNull$$$0(12);
        }
        return computable;
    }

    @NotNull
    public IndexUpdateComputable prepareUpdate(int inputId, @NotNull InputData<Key, Value> data2) {
        if (data2 == null) {
            MapReduceIndex.$$$reportNull$$$0(13);
        }
        UpdateData<Key, Value> updateData = new UpdateData<Key, Value>(inputId, data2.getKeyValues(), () -> this.getKeysDiffBuilder(inputId), this.myIndexId, (ThrowableRunnable<? extends IOException>)((ThrowableRunnable)() -> this.updateForwardIndex(inputId, data2)));
        return new IndexUpdateComputable(updateData, data2);
    }

    @ApiStatus.Internal
    protected void checkNonCancellableSection() {
    }

    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data2) throws IOException {
        if (data2 == null) {
            MapReduceIndex.$$$reportNull$$$0(14);
        }
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                ((IntForwardIndex)this.myForwardIndex).putInt(inputId, ((IntForwardIndexAccessor)this.myForwardIndexAccessor).serializeIndexedDataToInt(data2));
            } else {
                this.myForwardIndex.put(inputId, this.myForwardIndexAccessor.serializeIndexedData(data2));
            }
        }
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                InputDataDiffBuilder inputDataDiffBuilder = ((IntForwardIndexAccessor)this.myForwardIndexAccessor).getDiffBuilderFromInt(inputId, ((IntForwardIndex)this.myForwardIndex).getInt(inputId));
                if (inputDataDiffBuilder == null) {
                    MapReduceIndex.$$$reportNull$$$0(15);
                }
                return inputDataDiffBuilder;
            }
            InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.myForwardIndexAccessor.getDiffBuilder(inputId, this.myForwardIndex.get(inputId));
            if (inputDataDiffBuilder == null) {
                MapReduceIndex.$$$reportNull$$$0(16);
            }
            return inputDataDiffBuilder;
        }
        return new EmptyInputDataDiffBuilder(inputId);
    }

    @NotNull
    protected InputData<Key, Value> mapInput(int inputId, @Nullable Input content) {
        if (content == null) {
            InputData inputData = InputData.empty();
            if (inputData == null) {
                MapReduceIndex.$$$reportNull$$$0(17);
            }
            return inputData;
        }
        Map<Key, Value> data2 = this.mapByIndexer(inputId, content);
        if (this.myValueSerializationChecker != null) {
            this.myValueSerializationChecker.checkValueSerialization(data2, content);
        }
        this.checkCanceled();
        return new InputData<Key, Value>(data2);
    }

    @NotNull
    protected Map<Key, Value> mapByIndexer(int inputId, @NotNull Input content) {
        if (content == null) {
            MapReduceIndex.$$$reportNull$$$0(18);
        }
        Map<Key, Value> map2 = this.myIndexer.map(content);
        if (map2 == null) {
            MapReduceIndex.$$$reportNull$$$0(19);
        }
        return map2;
    }

    public abstract void checkCanceled();

    protected abstract void requestRebuild(@NotNull Throwable var1);

    public long getModificationStamp() {
        return this.myModificationStamp.get();
    }

    protected void incrementModificationStamp() {
        this.myModificationStamp.incrementAndGet();
    }

    public void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            MapReduceIndex.$$$reportNull$$$0(20);
        }
        Lock lock = USE_READ_LOCK_ON_UPDATE ? this.myLock.readLock() : this.myLock.writeLock();
        ConcurrencyUtil.withLock(lock, () -> {
            IndexId<?, ?> oldIndexId = IndexDebugProperties.DEBUG_INDEX_ID.get();
            try {
                IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
                boolean hasDifference = updateData.iterateKeys(this.myAddedKeyProcessor, this.myUpdatedKeyProcessor, this.myRemovedKeyProcessor);
                if (hasDifference) {
                    updateData.updateForwardIndex();
                }
            }
            catch (ProcessCanceledException e2) {
                LOG.error("ProcessCanceledException is not expected here!", e2);
                throw e2;
            }
            catch (Throwable e3) {
                throw new StorageException(e3);
            }
            finally {
                IndexDebugProperties.DEBUG_INDEX_ID.set(oldIndexId);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorageLayout";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationProblemReporter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInput";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "mapByIndexer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareUpdate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateForwardIndex";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mapByIndexer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public final class IndexUpdateComputable
    implements Computable<Boolean> {
        private final UpdateData<Key, Value> myUpdateData;
        private final InputData<Key, Value> myInputData;

        private IndexUpdateComputable(@NotNull UpdateData<Key, Value> updateData, InputData<Key, Value> inputData) {
            if (updateData == null) {
                IndexUpdateComputable.$$$reportNull$$$0(0);
            }
            if (inputData == null) {
                IndexUpdateComputable.$$$reportNull$$$0(1);
            }
            this.myUpdateData = updateData;
            this.myInputData = inputData;
        }

        @NotNull
        public InputData<Key, Value> getInputData() {
            InputData inputData = this.myInputData;
            if (inputData == null) {
                IndexUpdateComputable.$$$reportNull$$$0(2);
            }
            return inputData;
        }

        @Override
        public Boolean compute() {
            MapReduceIndex.this.checkNonCancellableSection();
            try {
                MapReduceIndex.this.updateWithMap(this.myUpdateData);
            }
            catch (ProcessCanceledException | StorageException ex) {
                String message = "An exception during updateWithMap(). Index " + MapReduceIndex.this.myIndexId.getName() + " will be rebuilt.";
                if (ex instanceof ProcessCanceledException) {
                    LOG.error(message, ex);
                } else if (IndexDebugProperties.IS_UNIT_TEST_MODE) {
                    LOG.error(message, ex);
                } else {
                    LOG.info(message, ex);
                }
                MapReduceIndex.this.requestRebuild(ex);
                return false;
            }
            catch (Throwable t2) {
                LOG.error("An exception during updateWithMap(). Index " + MapReduceIndex.this.myIndexId.getName(), t2);
                throw t2;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/impl/MapReduceIndex$IndexUpdateComputable";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/impl/MapReduceIndex$IndexUpdateComputable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

