/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.containers.RandomAccessIntContainer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class IdBitSet
implements Cloneable,
RandomAccessIntContainer {
    private static final int SHIFT = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int MASK = 63;
    private long[] bitSlots;
    private int bitsSet;
    private int maxNonZeroSlotIndex;
    private int bitIndexBase = -1;

    IdBitSet(int capacity) {
        this.bitSlots = IdBitSet.allocateArrayForCapacity(IdBitSet.capacityWithReserve(capacity));
    }

    IdBitSet(int[] ids, int idsCount, int additionalCapacityToReserve) {
        this(IdBitSet.calcMinMax(ids, idsCount), additionalCapacityToReserve);
        for (int i2 = 0; i2 < idsCount; ++i2) {
            this.add(ids[i2]);
        }
    }

    IdBitSet(int[] minMax, int additionalCapacityToReserve) {
        int base;
        int min = minMax[0];
        int max = minMax[1];
        this.bitIndexBase = base = IdBitSet.roundDownToSlot(min);
        this.bitSlots = IdBitSet.allocateArrayForCapacity(IdBitSet.capacityWithReserve(max - base) + additionalCapacityToReserve);
    }

    IdBitSet(RandomAccessIntContainer set, int additionalCapacityToReserve) {
        this(IdBitSet.calcMinMax(set), additionalCapacityToReserve);
        IntIdsIterator iterator2 = set.intIterator();
        while (iterator2.hasNext()) {
            this.add(iterator2.next());
        }
    }

    @Override
    public boolean contains(int bitIndex) {
        if (bitIndex < this.bitIndexBase || this.bitIndexBase < 0) {
            return false;
        }
        int wordIndex = (bitIndex -= this.bitIndexBase) >> 6;
        boolean result2 = false;
        if (wordIndex < this.bitSlots.length) {
            result2 = (this.bitSlots[wordIndex] & 1L << (bitIndex & 0x3F)) != 0L;
        }
        return result2;
    }

    @Override
    public boolean add(int bitIndex) {
        boolean set = this.contains(bitIndex);
        if (!set) {
            if (this.bitIndexBase < 0) {
                this.bitIndexBase = IdBitSet.roundDownToSlot(bitIndex);
            } else if (bitIndex < this.bitIndexBase) {
                int newBase = IdBitSet.roundDownToSlot(bitIndex);
                int wordDiff = this.bitIndexBase - newBase >> 6;
                long[] n2 = new long[wordDiff + this.bitSlots.length];
                System.arraycopy(this.bitSlots, 0, n2, wordDiff, this.bitSlots.length);
                this.bitSlots = n2;
                this.bitIndexBase = newBase;
                this.maxNonZeroSlotIndex += wordDiff;
            }
            ++this.bitsSet;
            int wordIndex = (bitIndex -= this.bitIndexBase) >> 6;
            if (wordIndex >= this.bitSlots.length) {
                this.bitSlots = ArrayUtil.realloc(this.bitSlots, Math.max(IdBitSet.capacityWithReserve(this.bitSlots.length), wordIndex + 1));
            }
            int n3 = wordIndex;
            this.bitSlots[n3] = this.bitSlots[n3] | 1L << (bitIndex & 0x3F);
            this.maxNonZeroSlotIndex = Math.max(this.maxNonZeroSlotIndex, wordIndex);
        }
        return !set;
    }

    @Override
    public int size() {
        return this.bitsSet;
    }

    @Override
    public boolean remove(int bitIndex) {
        int wordIndex;
        if (bitIndex < this.bitIndexBase || this.bitIndexBase < 0) {
            return false;
        }
        if (!this.contains(bitIndex)) {
            return false;
        }
        --this.bitsSet;
        int n2 = wordIndex = (bitIndex -= this.bitIndexBase) >> 6;
        this.bitSlots[n2] = this.bitSlots[n2] & (1L << (bitIndex & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        if (wordIndex == this.maxNonZeroSlotIndex) {
            while (this.maxNonZeroSlotIndex >= 0 && this.bitSlots[this.maxNonZeroSlotIndex] == 0L) {
                --this.maxNonZeroSlotIndex;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public IntIdsIterator intIterator() {
        return this.size() == 0 ? ValueContainerImpl.EMPTY_ITERATOR : new Iterator();
    }

    @Override
    public void compact() {
    }

    @Override
    @NotNull
    public IdBitSet ensureContainerCapacity(int diff) {
        IdBitSet idBitSet = this;
        if (idBitSet == null) {
            IdBitSet.$$$reportNull$$$0(0);
        }
        return idBitSet;
    }

    @Override
    public IdBitSet clone() {
        try {
            IdBitSet clone = (IdBitSet)super.clone();
            if (this.bitSlots.length != this.maxNonZeroSlotIndex + 1) {
                this.bitSlots = Arrays.copyOf(this.bitSlots, this.maxNonZeroSlotIndex + 1);
            }
            clone.bitSlots = (long[])this.bitSlots.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Must not happen, since class implements Cloneable", ex);
        }
    }

    private int nextSetBit(int bitIndex) {
        int wordIndex;
        if (this.bitIndexBase < 0) {
            throw new IllegalStateException();
        }
        if (bitIndex >= this.bitIndexBase) {
            bitIndex -= this.bitIndexBase;
        }
        if ((wordIndex = bitIndex >> 6) > this.maxNonZeroSlotIndex) {
            return -1;
        }
        long word = this.bitSlots[wordIndex] & -1L << bitIndex;
        while (word == 0L) {
            if (++wordIndex > this.maxNonZeroSlotIndex) {
                return -1;
            }
            word = this.bitSlots[wordIndex];
        }
        return wordIndex * 64 + Long.numberOfTrailingZeros(word) + this.bitIndexBase;
    }

    public static int sizeInBytes(int max, int min) {
        return IdBitSet.capacityWithReserve((IdBitSet.roundDownToSlot(max) - IdBitSet.roundDownToSlot(min) >> 6) + 1) * 8;
    }

    private static int capacityWithReserve(int length) {
        int capacity = length + 3 * (length / 5);
        if (capacity < 0) {
            throw new IllegalArgumentException("length(=" + length + ") is too big -- i.e. id range is too large to keep in bitset");
        }
        return capacity;
    }

    private static long @NotNull [] allocateArrayForCapacity(int capacityInBits) {
        return new long[(capacityInBits >> 6) + 1];
    }

    private static int roundDownToSlot(int i2) {
        return i2 >> 6 << 6;
    }

    static int @NotNull [] calcMinMax(int[] array, int length) {
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < length; ++i2) {
            max = Math.max(max, array[i2]);
            min = Math.min(min, array[i2]);
        }
        int[] nArray = new int[]{min, max};
        if (nArray == null) {
            IdBitSet.$$$reportNull$$$0(1);
        }
        return nArray;
    }

    private static int[] calcMinMax(RandomAccessIntContainer set) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        IntIdsIterator iterator2 = set.intIterator();
        while (iterator2.hasNext()) {
            int next = iterator2.next();
            min = Math.min(min, next);
            max = Math.max(max, next);
        }
        return new int[]{min, max};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/indexing/containers/IdBitSet";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureContainerCapacity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMinMax";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private final class Iterator
    implements IntIdsIterator {
        private int nextSetBit;

        private Iterator() {
            this.nextSetBit = IdBitSet.this.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.nextSetBit != -1;
        }

        @Override
        public int next() {
            int setBit = this.nextSetBit;
            this.nextSetBit = IdBitSet.this.nextSetBit(setBit + 1);
            return setBit;
        }

        @Override
        public int size() {
            return IdBitSet.this.size();
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new Iterator();
        }
    }
}

