/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.gotoType;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.jetbrains.rd.ide.model.GotoInput;
import com.jetbrains.rd.ide.model.GotoKey;
import com.jetbrains.rd.ide.model.GotoResultListBase;
import com.jetbrains.rd.ide.model.SearchItemData;
import com.jetbrains.rd.ide.model.SearchPopup;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rdclient.gotoType.GotoPopupSession;
import com.jetbrains.rdclient.gotoType.GotoResult;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.SyncEventWithInterrupt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u0001:\u00010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\u0017\u001a\u00020\u0011J?\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110 \u0012\u0004\u0012\u00020\u00190\u001f\u00a2\u0006\u0002\u0010!JQ\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110 \u0012\u0004\u0012\u00020\u00190\u001fH\u0002\u00a2\u0006\u0002\u0010'J-\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110 2\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010)\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020&J\u000e\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000RR\u0010\u000f\u001aF\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00100\u0010j*\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013`\u0014`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/rdclient/gotoType/GotoPopupSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "popupLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "gotoKey", "Lcom/jetbrains/rd/ide/model/GotoKey;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/GotoKey;)V", "perTypeRequestIds", "Ljava/util/concurrent/atomic/AtomicInteger;", "requestLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "sequentialLifetimesLocks", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "shortNameToItemsMap", "Ljava/util/HashMap;", "", "Lcom/jetbrains/rd/ide/model/SearchItemData;", "Lcom/jetbrains/rdclient/gotoType/GotoResult;", "Lkotlin/collections/HashMap;", "getItemByShortName", "", "shortName", "getItemsAsync", "", "lifetime", "text", "searchInLibraries", "", "whenReady", "Lkotlin/Function1;", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)V", "getItemsAsyncFromBackend", "requestId", "", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;ILcom/jetbrains/rdclient/services/IdeBackend;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)V", "getItemsSync", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Ljava/lang/String;Ljava/lang/Boolean;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "getModelSearchPopup", "Lcom/jetbrains/rd/ide/model/SearchPopup;", "getRecentVersionOfResult", "data", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nGotoPopupSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotoPopupSession.kt\ncom/jetbrains/rdclient/gotoType/GotoPopupSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,169:1\n1#2:170\n65#3,4:171\n65#3,4:176\n26#4:175\n*S KotlinDebug\n*F\n+ 1 GotoPopupSession.kt\ncom/jetbrains/rdclient/gotoType/GotoPopupSession\n*L\n50#1:171,4\n122#1:176,4\n109#1:175\n*E\n"})
public final class GotoPopupSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime popupLifetime;
    @NotNull
    private final GotoKey gotoKey;
    @NotNull
    private final HashMap<String, HashMap<SearchItemData, GotoResult>> shortNameToItemsMap;
    @NotNull
    private final SequentialLifetimes requestLifetimes;
    @NotNull
    private final ReentrantReadWriteLock sequentialLifetimesLocks;
    @NotNull
    private AtomicInteger perTypeRequestIds;
    @NotNull
    private static final Logger logger;

    public GotoPopupSession(@NotNull Project project, @NotNull Lifetime popupLifetime, @NotNull GotoKey gotoKey) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)popupLifetime, (String)"popupLifetime");
        Intrinsics.checkNotNullParameter((Object)gotoKey, (String)"gotoKey");
        this.project = project;
        this.popupLifetime = popupLifetime;
        this.gotoKey = gotoKey;
        this.shortNameToItemsMap = new HashMap();
        this.requestLifetimes = new SequentialLifetimes(this.popupLifetime);
        this.sequentialLifetimesLocks = new ReentrantReadWriteLock();
        this.perTypeRequestIds = new AtomicInteger(0);
    }

    @NotNull
    public final SearchPopup getModelSearchPopup(@NotNull IdeBackend backend) {
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        IMutableViewableMap popupModel = backend.getGotoModel().getSearchPopups();
        SearchPopup searchPopup = (SearchPopup)popupModel.get((Object)this.gotoKey);
        if (searchPopup == null) {
            boolean bl;
            GotoPopupSession $this$getModelSearchPopup_u24lambda_u242 = this;
            boolean bl2 = false;
            SearchPopup searchPopup2 = new SearchPopup($this$getModelSearchPopup_u24lambda_u242.gotoKey);
            boolean bl3 = bl = !popupModel.containsKey((Object)$this$getModelSearchPopup_u24lambda_u242.gotoKey);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-GotoPopupSession$getModelSearchPopup$1$22 = false;
                String $i$a$-assert-GotoPopupSession$getModelSearchPopup$1$22 = "May not execute overlapping popup of type " + $this$getModelSearchPopup_u24lambda_u242.gotoKey;
                throw new AssertionError((Object)$i$a$-assert-GotoPopupSession$getModelSearchPopup$1$22);
            }
            ((Map)popupModel).put($this$getModelSearchPopup_u24lambda_u242.gotoKey, searchPopup2);
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl4 = false;
                logger.trace("Putting protocol popup model for type " + $this$getModelSearchPopup_u24lambda_u242.gotoKey);
            }
            $this$getModelSearchPopup_u24lambda_u242.popupLifetime.onTermination((Function0)new Function0<Unit>($this$getModelSearchPopup_u24lambda_u242, (IMutableViewableMap<GotoKey, SearchPopup>)popupModel, searchPopup2){
                final /* synthetic */ GotoPopupSession $this_run;
                final /* synthetic */ IMutableViewableMap<GotoKey, SearchPopup> $popupModel;
                final /* synthetic */ SearchPopup $searchPopup;
                {
                    this.$this_run = $receiver;
                    this.$popupModel = $popupModel;
                    this.$searchPopup = $searchPopup;
                    super(0);
                }

                public final void invoke() {
                    SwingUtilities.invokeLater(() -> getModelSearchPopup.1.3.invoke$lambda$3(this.$this_run, this.$popupModel, this.$searchPopup));
                }

                private static final void invoke$lambda$3$lambda$2(IMutableViewableMap $popupModel, GotoPopupSession $this_run, SearchPopup $searchPopup) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)$popupModel, (String)"$popupModel");
                    Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
                    Intrinsics.checkNotNullParameter((Object)$searchPopup, (String)"$searchPopup");
                    boolean bl2 = bl = $popupModel.get((Object)GotoPopupSession.access$getGotoKey$p($this_run)) == $searchPopup;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-GotoPopupSession$getModelSearchPopup$1$3$1$1$22 = false;
                        String $i$a$-assert-GotoPopupSession$getModelSearchPopup$1$3$1$1$22 = "Removing non-own popup from popup model for goto kind " + GotoPopupSession.access$getGotoKey$p($this_run) + ", bug?";
                        throw new AssertionError((Object)$i$a$-assert-GotoPopupSession$getModelSearchPopup$1$3$1$1$22);
                    }
                    $popupModel.remove((Object)GotoPopupSession.access$getGotoKey$p($this_run));
                    Logger $this$trace$iv = GotoPopupSession.access$getLogger$cp();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl3 = false;
                        logger.trace("Removing protocol model for type " + GotoPopupSession.access$getGotoKey$p($this_run));
                    }
                }

                private static final void invoke$lambda$3(GotoPopupSession $this_run, IMutableViewableMap $popupModel, SearchPopup $searchPopup) {
                    Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
                    Intrinsics.checkNotNullParameter((Object)$popupModel, (String)"$popupModel");
                    Intrinsics.checkNotNullParameter((Object)$searchPopup, (String)"$searchPopup");
                    FocusManagerImpl.getInstance((Project)GotoPopupSession.access$getProject$p($this_run)).doWhenFocusSettlesDown(() -> getModelSearchPopup.1.3.invoke$lambda$3$lambda$2($popupModel, $this_run, $searchPopup));
                }
            });
            searchPopup = searchPopup2;
        }
        return searchPopup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String[] getItemsSync(@NotNull String text, @Nullable Boolean searchInLibraries, @Nullable ProgressIndicator progressIndicator) {
        LifetimeDefinition lifetimeDefinition;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        result2.element = new String[0];
        SyncEventWithInterrupt syncEvent = new SyncEventWithInterrupt();
        ReentrantReadWriteLock reentrantReadWriteLock = this.sequentialLifetimesLocks;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            lifetimeDefinition = this.requestLifetimes.next();
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        LifetimeDefinition getItemsLifetime = lifetimeDefinition;
        ApplicationManager.getApplication().invokeLater(() -> GotoPopupSession.getItemsSync$lambda$5(this, getItemsLifetime, text, searchInLibraries, result2, syncEvent), ModalityState.any());
        SyncEventWithInterrupt.waitFor$default(syncEvent, (Lifetime)getItemsLifetime, false, (Function0)new Function0<Unit>(progressIndicator){
            final /* synthetic */ ProgressIndicator $progressIndicator;
            {
                this.$progressIndicator = $progressIndicator;
                super(0);
            }

            public final void invoke() {
                ProgressIndicator progressIndicator = this.$progressIndicator;
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                ProgressManager.checkCanceled();
                if (ApplicationManagerEx.getApplicationEx().isWriteActionPending()) {
                    throw new ProcessCanceledException();
                }
            }
        }, 2, null);
        return (String[])result2.element;
    }

    public final void getItemsAsync(@NotNull Lifetime lifetime, @NotNull String text, @Nullable Boolean searchInLibraries, @NotNull Function1<? super String[], Unit> whenReady) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(whenReady, (String)"whenReady");
        IdeBackend backend = IdeBackend.Companion.getInstance(this.project);
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)backend.getSolution().isLoaded()))) {
            boolean $i$f$emptyArray = false;
            whenReady.invoke((Object)new String[0]);
            return;
        }
        this.getItemsAsyncFromBackend(lifetime, this.perTypeRequestIds.incrementAndGet(), backend, text, searchInLibraries, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>(whenReady){
            final /* synthetic */ Function1<String[], Unit> $whenReady;
            {
                this.$whenReady = $whenReady;
                super(1);
            }

            public final void invoke(@NotNull String[] resultFromBackend) {
                Intrinsics.checkNotNullParameter((Object)resultFromBackend, (String)"resultFromBackend");
                this.$whenReady.invoke((Object)resultFromBackend);
            }
        }));
    }

    private final void getItemsAsyncFromBackend(Lifetime lifetime, int requestId, IdeBackend backend, String text, Boolean searchInLibraries, Function1<? super String[], Unit> whenReady) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("getItemsAsync.Start text: '" + text + "', kind: '" + this.gotoKey + "', searchInLibraries: '" + searchInLibraries + "'");
        }
        Ref.BooleanRef hadResult = new Ref.BooleanRef();
        lifetime.onTermination((Function0)new Function0<Unit>(hadResult, text, this, searchInLibraries){
            final /* synthetic */ Ref.BooleanRef $hadResult;
            final /* synthetic */ String $text;
            final /* synthetic */ GotoPopupSession this$0;
            final /* synthetic */ Boolean $searchInLibraries;
            {
                this.$hadResult = $hadResult;
                this.$text = $text;
                this.this$0 = $receiver;
                this.$searchInLibraries = $searchInLibraries;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                if (!this.$hadResult.element) {
                    void $this$trace$iv;
                    Logger logger = GotoPopupSession.access$getLogger$cp();
                    String string = this.$text;
                    GotoPopupSession gotoPopupSession = this.this$0;
                    Boolean bl = this.$searchInLibraries;
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        void var7_6 = $this$trace$iv;
                        boolean bl2 = false;
                        var7_6.trace("getItemsAsync.Cancel text: '" + string + "', kind: '" + GotoPopupSession.access$getGotoKey$p(gotoPopupSession) + "', searchInLibraries: '" + bl + "'");
                    }
                }
            }
        });
        SearchPopup modelSearchPopup = this.getModelSearchPopup(backend);
        IAsyncSignal iAsyncSignal = modelSearchPopup.getGetItemsTask();
        IScheduler iScheduler = backend.getProtocol().getScheduler();
        Intrinsics.checkNotNull((Object)iScheduler, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.protocol.IRdDispatcher");
        iAsyncSignal.adviseOn(lifetime, ((IRdDispatcher)iScheduler).getBackgroundScheduler(), (Function1)new Function1<GotoResultListBase, Unit>(hadResult, text, searchInLibraries, this, requestId, whenReady, modelSearchPopup){
            final /* synthetic */ Ref.BooleanRef $hadResult;
            final /* synthetic */ String $text;
            final /* synthetic */ Boolean $searchInLibraries;
            final /* synthetic */ GotoPopupSession this$0;
            final /* synthetic */ int $requestId;
            final /* synthetic */ Function1<String[], Unit> $whenReady;
            final /* synthetic */ SearchPopup $modelSearchPopup;
            {
                this.$hadResult = $hadResult;
                this.$text = $text;
                this.$searchInLibraries = $searchInLibraries;
                this.this$0 = $receiver;
                this.$requestId = $requestId;
                this.$whenReady = $whenReady;
                this.$modelSearchPopup = $modelSearchPopup;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull GotoResultListBase resultFromBackend) {
                void $this$groupByTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)resultFromBackend, (String)"resultFromBackend");
                this.$hadResult.element = true;
                if (!Intrinsics.areEqual((Object)resultFromBackend.getRequestText(), (Object)this.$text) || !Intrinsics.areEqual((Object)resultFromBackend.getRequestScope(), (Object)this.$searchInLibraries) || GotoPopupSession.access$getPerTypeRequestIds$p(this.this$0).get() != this.$requestId) {
                    GotoPopupSession.access$getLogger$cp().trace("Got response for wrong goto request, ignoring it");
                    return;
                }
                GotoPopupSession.access$getLogger$cp().debug("Search items task for " + this.$text + " from " + GotoPopupSession.access$getGotoKey$p(this.this$0) + " is done. Got " + ((Collection)resultFromBackend.getItems()).size() + " items");
                ArrayList<String> result2 = new ArrayList<String>();
                Iterable iterable = resultFromBackend.getItems();
                boolean $i$f$groupBy = false;
                Iterable iterable2 = iterable;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    SearchItemData it = (SearchItemData)element$iv$iv;
                    boolean bl = false;
                    String key$iv$iv = it.getShortName();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                for (Map.Entry<K, V> entry : destination$iv$iv.entrySet()) {
                    void $this$forEach$iv;
                    Object object;
                    String mainText = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    result2.add(mainText);
                    Object $this$getOrPut$iv = GotoPopupSession.access$getShortNameToItemsMap$p(this.this$0);
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(mainText);
                    if (value$iv == null) {
                        boolean bl = false;
                        HashMap<K, V> answer$iv = new HashMap<K, V>();
                        $this$getOrPut$iv.put(mainText, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    HashMap itemsForText = (HashMap)object;
                    $this$getOrPut$iv = value;
                    SearchPopup searchPopup = this.$modelSearchPopup;
                    GotoPopupSession gotoPopupSession = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        SearchItemData itemData = (SearchItemData)element$iv;
                        boolean bl = false;
                        GotoResult it = new GotoResult(itemData, searchPopup, gotoPopupSession);
                        boolean bl3 = false;
                        ((Map)itemsForText).put(itemData, it);
                    }
                }
                Collection $this$toTypedArray$iv = result2;
                boolean bl = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                this.$whenReady.invoke((Object)thisCollection$iv.toArray(new String[0]));
            }
        });
        modelSearchPopup.getInput().set((Object)new GotoInput(text, searchInLibraries, requestId));
    }

    @NotNull
    public final Collection<GotoResult> getItemByShortName(@NotNull String shortName) {
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        HashMap<SearchItemData, GotoResult> hashMap = this.shortNameToItemsMap.get(shortName);
        Collection collection = hashMap != null ? hashMap.values() : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @NotNull
    public final SearchItemData getRecentVersionOfResult(@NotNull SearchItemData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = this.shortNameToItemsMap.get(data.getShortName());
        if (object == null || (object = ((HashMap)object).get(data)) == null || (object = ((GotoResult)object).getSearchItemData()) == null) {
            object = data;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getItemsSync$lambda$5(GotoPopupSession this$0, LifetimeDefinition $getItemsLifetime, String $text, Boolean $searchInLibraries, Ref.ObjectRef $result, SyncEventWithInterrupt $syncEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$getItemsLifetime, (String)"$getItemsLifetime");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$syncEvent, (String)"$syncEvent");
        ReentrantReadWriteLock.ReadLock readLock = this$0.sequentialLifetimesLocks.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            if (!RLifetimeKt.isAlive((Lifetime)((Lifetime)$getItemsLifetime))) {
                return;
            }
            this$0.getItemsAsync((Lifetime)$getItemsLifetime, $text, $searchInLibraries, (Function1<? super String[], Unit>)((Function1)new Function1<String[], Unit>((Ref.ObjectRef<String[]>)$result, $syncEvent){
                final /* synthetic */ Ref.ObjectRef<String[]> $result;
                final /* synthetic */ SyncEventWithInterrupt $syncEvent;
                {
                    this.$result = $result;
                    this.$syncEvent = $syncEvent;
                    super(1);
                }

                public final void invoke(@NotNull String[] it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$result.element = it;
                    this.$syncEvent.set();
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ GotoKey access$getGotoKey$p(GotoPopupSession $this) {
        return $this.gotoKey;
    }

    public static final /* synthetic */ AtomicInteger access$getPerTypeRequestIds$p(GotoPopupSession $this) {
        return $this.perTypeRequestIds;
    }

    public static final /* synthetic */ HashMap access$getShortNameToItemsMap$p(GotoPopupSession $this) {
        return $this.shortNameToItemsMap;
    }

    public static final /* synthetic */ Project access$getProject$p(GotoPopupSession $this) {
        return $this.project;
    }

    static {
        Logger logger = Logger.getInstance(GotoPopupSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GotoPopupSession.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/gotoType/GotoPopupSession$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

