/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSyncStatusTracker;
import com.intellij.settingsSync.config.SettingsSyncOpenSettingsAction;
import com.intellij.settingsSync.config.SettingsSyncStatusActionKt;
import com.intellij.settingsSync.config.SyncStatus;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.SettingsSyncIcons;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncStatusAction;", "Lcom/intellij/settingsSync/config/SettingsSyncOpenSettingsAction;", "Lcom/intellij/ide/actions/SettingsEntryPointAction$NoDots;", "Lcom/intellij/settingsSync/SettingsSyncStatusTracker$Listener;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getStyledStatus", "", "Lorg/jetbrains/annotations/Nls;", "status", "Lcom/intellij/settingsSync/config/SyncStatus;", "syncStatusChanged", "", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "IconCustomizer", "intellij.settingsSync"})
public final class SettingsSyncStatusAction
extends SettingsSyncOpenSettingsAction
implements SettingsEntryPointAction.NoDots,
SettingsSyncStatusTracker.Listener {
    public SettingsSyncStatusAction() {
        SettingsSyncStatusTracker.Companion.getInstance().addListener(this);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation p = presentation;
        if (!SettingsSyncMainKt.isSettingsSyncEnabledByKey()) {
            p.setEnabledAndVisible(false);
            return;
        }
        SyncStatus status = SettingsSyncStatusActionKt.access$getStatus();
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                p.setIcon(SettingsSyncIcons.StatusEnabled);
                break;
            }
            case 2: {
                p.setIcon(SettingsSyncIcons.StatusDisabled);
                break;
            }
            case 3: {
                p.setIcon(AllIcons.General.Error);
            }
        }
        p.setText(this.getStyledStatus(status));
    }

    private final String getStyledStatus(SyncStatus status) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>").append(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync", new Object[0])).append(" ").append("<font color='#");
        String hexColor = UIUtil.colorToHex((Color)JBUI.CurrentTheme.Popup.mnemonicForeground());
        builder.append(hexColor).append("'>");
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                builder.append(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync.is.on", new Object[0]));
                break;
            }
            case 2: {
                builder.append(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync.is.off", new Object[0]));
                break;
            }
            case 3: {
                builder.append(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync.failed", new Object[0]));
            }
        }
        builder.append("</font>");
        return String.valueOf(builder);
    }

    @Override
    public void syncStatusChanged() {
        SettingsEntryPointAction.updateState();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncStatusAction$IconCustomizer;", "Lcom/intellij/ide/actions/SettingsEntryPointAction$IconCustomizer;", "()V", "getCustomIcon", "Ljavax/swing/Icon;", "supplier", "Lcom/intellij/ui/BadgeIconSupplier;", "intellij.settingsSync"})
    public static final class IconCustomizer
    implements SettingsEntryPointAction.IconCustomizer {
        @Nullable
        public Icon getCustomIcon(@NotNull BadgeIconSupplier supplier) {
            Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
            return SettingsSyncStatusActionKt.access$getStatus() == SyncStatus.FAILED ? supplier.getErrorIcon(true) : null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyncStatus.values().length];
            try {
                nArray[SyncStatus.ON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncStatus.OFF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncStatus.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

