/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.storage;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.completion.ml.features.ContextFeaturesStorage;
import com.intellij.completion.ml.performance.MLCompletionPerformanceTracker;
import com.intellij.completion.ml.personalization.UserFactor;
import com.intellij.completion.ml.personalization.UserFactorStorage;
import com.intellij.completion.ml.personalization.UserFactorsManager;
import com.intellij.completion.ml.personalization.session.LookupSessionFactorsStorage;
import com.intellij.completion.ml.sorting.RankingModelWrapper;
import com.intellij.completion.ml.sorting.RankingSupport;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.storage.MutableElementStorage;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.completion.ml.util.LookupElementExtensionsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 A2\u00020\u0001:\u0001AB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010(\u001a\u00020\u0012H\u0016J\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020\nH\u0002J1\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002000\u00142\b\u00101\u001a\u0004\u0018\u000102\u00a2\u0006\u0002\u00103J\u0006\u00104\u001a\u00020*J\u0010\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\rH\u0016J\"\u00107\u001a\u00020*2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002080\u00142\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020=H\u0007J\u0006\u0010>\u001a\u00020\nJ\u0006\u0010?\u001a\u00020*J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010@\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0010\u00a8\u0006B"}, d2={"Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "Lcom/intellij/completion/ml/storage/LookupStorage;", "startedTimestamp", "", "language", "Lcom/intellij/lang/Language;", "model", "Lcom/intellij/completion/ml/sorting/RankingModelWrapper;", "(JLcom/intellij/lang/Language;Lcom/intellij/completion/ml/sorting/RankingModelWrapper;)V", "_loggingEnabled", "", "_userFactors", "", "", "contextFactors", "getContextFactors", "()Ljava/util/Map;", "contextFeaturesStorage", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "item2storage", "", "Lcom/intellij/completion/ml/storage/MutableElementStorage;", "getLanguage", "()Lcom/intellij/lang/Language;", "mlUsed", "getModel", "()Lcom/intellij/completion/ml/sorting/RankingModelWrapper;", "performanceTracker", "Lcom/intellij/completion/ml/performance/MLCompletionPerformanceTracker;", "getPerformanceTracker", "()Lcom/intellij/completion/ml/performance/MLCompletionPerformanceTracker;", "sessionFactors", "Lcom/intellij/completion/ml/personalization/session/LookupSessionFactorsStorage;", "getSessionFactors", "()Lcom/intellij/completion/ml/personalization/session/LookupSessionFactorsStorage;", "shouldReRank", "getStartedTimestamp", "()J", "userFactors", "getUserFactors", "contextProvidersResult", "disableReRanking", "", "experimentWithoutComputingFeatures", "fireElementScored", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "factors", "", "mlScore", "", "(Lcom/intellij/codeInsight/lookup/LookupElement;Ljava/util/Map;Ljava/lang/Double;)V", "fireReorderedUsingMLScores", "getItemStorage", "id", "initContextFactors", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "environment", "Lcom/intellij/openapi/util/UserDataHolderBase;", "initUserFactors", "project", "Lcom/intellij/openapi/project/Project;", "isContextFactorsInitialized", "markLoggingEnabled", "shouldComputeFeatures", "Companion", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nMutableLookupStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableLookupStorage.kt\ncom/intellij/completion/ml/storage/MutableLookupStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,176:1\n1#2:177\n13#3:178\n*S KotlinDebug\n*F\n+ 1 MutableLookupStorage.kt\ncom/intellij/completion/ml/storage/MutableLookupStorage\n*L\n51#1:178\n*E\n"})
public final class MutableLookupStorage
implements LookupStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long startedTimestamp;
    @NotNull
    private final Language language;
    @Nullable
    private final RankingModelWrapper model;
    @Nullable
    private Map<String, String> _userFactors;
    @Nullable
    private ContextFeatures contextFeaturesStorage;
    private boolean mlUsed;
    private boolean shouldReRank;
    private boolean _loggingEnabled;
    @NotNull
    private final MLCompletionPerformanceTracker performanceTracker;
    @NotNull
    private final LookupSessionFactorsStorage sessionFactors;
    @NotNull
    private final Map<String, MutableElementStorage> item2storage;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<MutableLookupStorage> LOOKUP_STORAGE;
    private static volatile boolean alwaysComputeFeaturesInTests;

    public MutableLookupStorage(long startedTimestamp, @NotNull Language language, @Nullable RankingModelWrapper model) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.startedTimestamp = startedTimestamp;
        this.language = language;
        this.model = model;
        this.shouldReRank = this.getModel() != null;
        this.performanceTracker = new MLCompletionPerformanceTracker();
        this.sessionFactors = new LookupSessionFactorsStorage(this.getStartedTimestamp());
        this.item2storage = new LinkedHashMap();
    }

    @Override
    public long getStartedTimestamp() {
        return this.startedTimestamp;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return this.language;
    }

    @Override
    @Nullable
    public RankingModelWrapper getModel() {
        return this.model;
    }

    @Override
    @NotNull
    public Map<String, String> getUserFactors() {
        Map map = this._userFactors;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Override
    @NotNull
    public Map<String, String> getContextFactors() {
        ContextFeatures contextFeatures = this.contextFeaturesStorage;
        Map map = contextFeatures != null ? contextFeatures.asMap() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Override
    @NotNull
    public MLCompletionPerformanceTracker getPerformanceTracker() {
        return this.performanceTracker;
    }

    @Override
    @NotNull
    public LookupSessionFactorsStorage getSessionFactors() {
        return this.sessionFactors;
    }

    @Override
    @NotNull
    public MutableElementStorage getItemStorage(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        MutableElementStorage mutableElementStorage = this.item2storage.computeIfAbsent(id, arg_0 -> MutableLookupStorage.getItemStorage$lambda$0(getItemStorage.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mutableElementStorage, (String)"computeIfAbsent(...)");
        return mutableElementStorage;
    }

    @Override
    public boolean mlUsed() {
        return this.mlUsed;
    }

    public final void fireReorderedUsingMLScores() {
        this.mlUsed = true;
        this.getPerformanceTracker().reorderedByML();
    }

    @Override
    public boolean shouldComputeFeatures() {
        return this.shouldReRank() || ApplicationManager.getApplication().isUnitTestMode() && alwaysComputeFeaturesInTests || this._loggingEnabled && !this.experimentWithoutComputingFeatures();
    }

    @Override
    public boolean shouldReRank() {
        return this.getModel() != null && this.shouldReRank;
    }

    public final void disableReRanking() {
        this.shouldReRank = false;
    }

    public final boolean isContextFactorsInitialized() {
        return this.contextFeaturesStorage != null;
    }

    public final void fireElementScored(@NotNull LookupElement element, @NotNull Map<String, Object> factors, @Nullable Double mlScore) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(factors, (String)"factors");
        this.getItemStorage(LookupElementExtensionsKt.idString(element)).fireElementScored(factors, mlScore);
    }

    @RequiresReadLock
    public final void initUserFactors(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this._userFactors == null) {
            Map userFactorValues = new LinkedHashMap();
            List<UserFactor> userFactors = UserFactorsManager.Companion.getInstance().getAllFactors();
            UserFactorStorage applicationStorage = UserFactorStorage.Companion.getInstance();
            UserFactorStorage projectStorage = UserFactorStorage.Companion.getInstance(project);
            for (UserFactor factor : userFactors) {
                String it;
                if (factor.compute(applicationStorage) != null) {
                    boolean bl = false;
                    userFactorValues.put(factor.getId() + ":App", it);
                }
                if (factor.compute(projectStorage) == null) continue;
                boolean bl = false;
                userFactorValues.put(factor.getId() + ":Project", it);
            }
            this._userFactors = userFactorValues;
        }
    }

    @Override
    @NotNull
    public ContextFeatures contextProvidersResult() {
        ContextFeatures contextFeatures = this.contextFeaturesStorage;
        if (contextFeatures == null) {
            contextFeatures = ContextFeaturesStorage.Companion.getEMPTY();
        }
        return contextFeatures;
    }

    public final void initContextFactors(@NotNull Map<String, MLFeatureValue> contextFactors, @NotNull UserDataHolderBase environment) {
        Intrinsics.checkNotNullParameter(contextFactors, (String)"contextFactors");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (this.isContextFactorsInitialized()) {
            LOG.error("Context factors should be initialized only once");
        } else {
            ContextFeaturesStorage features2 = new ContextFeaturesStorage(contextFactors);
            environment.copyUserDataTo((UserDataHolderBase)features2);
            this.contextFeaturesStorage = features2;
        }
    }

    private final boolean experimentWithoutComputingFeatures() {
        ExperimentInfo experimentInfo = ExperimentStatus.Companion.getInstance().forLanguage(this.getLanguage());
        if (experimentInfo.getInExperiment()) {
            return !experimentInfo.getShouldCalculateFeatures();
        }
        return false;
    }

    public final void markLoggingEnabled() {
        this._loggingEnabled = true;
    }

    private static final MutableElementStorage getItemStorage$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MutableElementStorage)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MutableLookupStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"completion.ml.lookup.storage");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LOOKUP_STORAGE = key;
        alwaysComputeFeaturesInTests = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0007J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J'\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\u0004\b\u0000\u0010\u001c*\u00020\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u0006H\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/completion/ml/storage/MutableLookupStorage$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "LOOKUP_STORAGE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "alwaysComputeFeaturesInTests", "", "get", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "initOrGetLookupStorage", "language", "Lcom/intellij/lang/Language;", "saveAsUserData", "", "storage", "setComputeFeaturesAlways", "value", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getUserData", "T", "key", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "intellij.completionMlRanking"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void setComputeFeaturesAlways(boolean value, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            boolean valueBefore2 = alwaysComputeFeaturesInTests;
            alwaysComputeFeaturesInTests = value;
            Disposer.register((Disposable)parentDisposable, () -> Companion.setComputeFeaturesAlways$lambda$0(valueBefore2));
        }

        @Nullable
        public final MutableLookupStorage get(@NotNull LookupImpl lookup) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            return (MutableLookupStorage)lookup.getUserData(LOOKUP_STORAGE);
        }

        @NotNull
        public final MutableLookupStorage initOrGetLookupStorage(@NotNull LookupImpl lookup, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            MutableLookupStorage existed = this.get(lookup);
            if (existed != null) {
                return existed;
            }
            MutableLookupStorage storage = new MutableLookupStorage(System.currentTimeMillis(), language, RankingSupport.INSTANCE.getRankingModel(language));
            lookup.putUserData(LOOKUP_STORAGE, (Object)storage);
            return storage;
        }

        @Nullable
        public final MutableLookupStorage get(@NotNull CompletionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            MutableLookupStorage storage = (MutableLookupStorage)this.getUserData(parameters, LOOKUP_STORAGE);
            if (storage == null) {
                LookupImpl activeLookup;
                LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
                LookupImpl lookupImpl = activeLookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
                if (activeLookup != null && (storage = this.get(activeLookup)) != null) {
                    LOG.debug("Can't get storage from parameters. Fallback to storage from active lookup");
                    this.saveAsUserData(parameters, storage);
                }
            }
            return storage;
        }

        public final void saveAsUserData(@NotNull CompletionParameters parameters, @NotNull MutableLookupStorage storage) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            CompletionProcess completionProcess = parameters.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)completionProcess, (String)"getProcess(...)");
            CompletionProcess completionProcess2 = completionProcess;
            if (completionProcess2 instanceof UserDataHolder) {
                ((UserDataHolder)completionProcess2).putUserData(LOOKUP_STORAGE, (Object)storage);
            }
        }

        private final <T> T getUserData(CompletionParameters $this$getUserData, Key<T> key) {
            CompletionProcess completionProcess = $this$getUserData.getProcess();
            UserDataHolder userDataHolder = completionProcess instanceof UserDataHolder ? (UserDataHolder)completionProcess : null;
            return (T)(userDataHolder != null ? userDataHolder.getUserData(key) : null);
        }

        private static final void setComputeFeaturesAlways$lambda$0(boolean $valueBefore) {
            alwaysComputeFeaturesInTests = $valueBefore;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

