/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleReferenceInjection {
    @Nullable
    private GradleDslElement myToBeInjected;
    @NotNull
    private PsiElement myPsiInjection;
    @NotNull
    private GradleDslSimpleExpression myOriginElement;
    @NotNull
    private String myName;

    public GradleReferenceInjection(@NotNull GradleDslSimpleExpression originElement, @Nullable GradleDslElement injection, @NotNull PsiElement psiInjection, @NotNull String name2) {
        if (originElement == null) {
            GradleReferenceInjection.$$$reportNull$$$0(0);
        }
        if (psiInjection == null) {
            GradleReferenceInjection.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            GradleReferenceInjection.$$$reportNull$$$0(2);
        }
        if (originElement == injection) {
            throw new IllegalStateException("Can't create a reference injection linking the same element to itself. Element: " + originElement);
        }
        this.myOriginElement = originElement;
        this.myToBeInjected = injection;
        this.myPsiInjection = psiInjection;
        this.myName = name2;
    }

    public boolean isResolved() {
        return this.myToBeInjected != null;
    }

    public void resolveWith(@Nullable GradleDslElement expression) {
        this.myToBeInjected = expression;
    }

    @Nullable
    public GradleDslElement getToBeInjected() {
        return this.myToBeInjected;
    }

    @NotNull
    public GradleDslSimpleExpression getOriginElement() {
        GradleDslSimpleExpression gradleDslSimpleExpression = this.myOriginElement;
        if (gradleDslSimpleExpression == null) {
            GradleReferenceInjection.$$$reportNull$$$0(3);
        }
        return gradleDslSimpleExpression;
    }

    @Nullable
    public GradleDslSimpleExpression getToBeInjectedExpression() {
        return this.myToBeInjected instanceof GradleDslSimpleExpression ? (GradleDslSimpleExpression)this.myToBeInjected : null;
    }

    @NotNull
    public PsiElement getPsiInjection() {
        PsiElement psiElement = this.myPsiInjection;
        if (psiElement == null) {
            GradleReferenceInjection.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GradleReferenceInjection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String injectAll(@NotNull PsiElement psiElement, @NotNull Collection<GradleReferenceInjection> injections) {
        if (psiElement == null) {
            GradleReferenceInjection.$$$reportNull$$$0(6);
        }
        if (injections == null) {
            GradleReferenceInjection.$$$reportNull$$$0(7);
        }
        StringBuilder builder = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(() -> {
            for (PsiElement element : psiElement.getChildren()) {
                Optional<GradleReferenceInjection> filteredInjection = injections.stream().filter(injection -> element == injection.getPsiInjection()).findFirst();
                if (filteredInjection.isPresent()) {
                    GradleDslSimpleExpression expression = filteredInjection.get().getToBeInjectedExpression();
                    if (expression == null) {
                        builder.append(element.getText());
                        continue;
                    }
                    Object value = expression.getValue();
                    builder.append(value == null ? "" : value);
                    continue;
                }
                builder.append(element.getText());
            }
        });
        String string = builder.toString();
        if (string == null) {
            GradleReferenceInjection.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiInjection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/GradleReferenceInjection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/GradleReferenceInjection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiInjection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "injectAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "injectAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 8 -> new IllegalStateException(string);
        };
    }
}

