/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.AppendableDataExternalizer;
import org.jetbrains.kotlin.incremental.storage.CachingLazyStorage;
import org.jetbrains.kotlin.incremental.storage.InMemoryStorageWrapper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001/B'\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\u0016\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eH\u0016J\u0018\u0010!\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\"J'\u0010#\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010$\u001a\u00020\u000b2\b\b\u0002\u0010%\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010&J\u0017\u0010'\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\"J\u0015\u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u0017H\u0016J\u001e\u0010+\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010,\u001a\u0002H-\"\u0004\b\u0002\u0010-*\u0004\u0018\u00010.H\u0002\u00a2\u0006\u0002\u0010\"R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0014j\b\u0012\u0004\u0012\u00028\u0000`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper;", "K", "V", "Lorg/jetbrains/kotlin/incremental/storage/InMemoryStorageWrapper;", "origin", "Lorg/jetbrains/kotlin/incremental/storage/CachingLazyStorage;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "(Lorg/jetbrains/kotlin/incremental/storage/CachingLazyStorage;Lcom/intellij/util/io/DataExternalizer;)V", "inMemoryStorage", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper$ValueWrapper;", "Lkotlin/collections/LinkedHashMap;", "isCleanRequested", "", "keys", "", "getKeys", "()Ljava/util/Collection;", "removedKeys", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "append", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "clean", "close", "contains", "(Ljava/lang/Object;)Z", "flush", "memoryCachesOnly", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getMergedValue", "wrapper", "useOriginValue", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper$ValueWrapper;Z)Ljava/lang/Object;", "getOriginValue", "remove", "(Ljava/lang/Object;)V", "resetInMemoryChanges", "set", "cast", "T", "", "ValueWrapper", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nInMemoryStorageWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryStorageWrapper.kt\norg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1789#2,3:172\n1789#2,3:175\n*S KotlinDebug\n*F\n+ 1 InMemoryStorageWrapper.kt\norg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper\n*L\n147#1:172,3\n151#1:175,3\n*E\n"})
public final class DefaultInMemoryStorageWrapper<K, V>
implements InMemoryStorageWrapper<K, V> {
    @NotNull
    private final CachingLazyStorage<K, V> origin;
    @NotNull
    private final DataExternalizer<V> valueExternalizer;
    @NotNull
    private final LinkedHashMap<K, ValueWrapper> inMemoryStorage;
    @NotNull
    private final HashSet<K> removedKeys;
    private boolean isCleanRequested;

    public DefaultInMemoryStorageWrapper(@NotNull CachingLazyStorage<K, V> origin, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkNotNullParameter(origin, (String)"origin");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        this.origin = origin;
        this.valueExternalizer = valueExternalizer;
        this.inMemoryStorage = new LinkedHashMap();
        this.removedKeys = new HashSet();
    }

    @Override
    @NotNull
    public synchronized Collection<K> getKeys() {
        Collection collection;
        if (this.isCleanRequested) {
            Set<K> set = this.inMemoryStorage.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            collection = set;
        } else {
            Collection collection2 = CollectionsKt.minus((Iterable)this.origin.getKeys(), (Iterable)this.removedKeys);
            Set<K> set = this.inMemoryStorage.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            collection = CollectionsKt.plus((Collection)collection2, (Iterable)set);
        }
        return collection;
    }

    @Override
    public synchronized void resetInMemoryChanges() {
        this.isCleanRequested = false;
        this.inMemoryStorage.clear();
        this.removedKeys.clear();
    }

    @Override
    public synchronized void clean() {
        this.inMemoryStorage.clear();
        this.removedKeys.clear();
        this.isCleanRequested = true;
    }

    @Override
    public synchronized void flush(boolean memoryCachesOnly) {
        if (this.isCleanRequested) {
            this.origin.clean();
        } else {
            for (K entry : this.removedKeys) {
                this.origin.remove(entry);
            }
        }
        for (Map.Entry entry : ((Map)this.inMemoryStorage).entrySet()) {
            Unit unit;
            Object key = entry.getKey();
            ValueWrapper valueWrapper = (ValueWrapper)entry.getValue();
            ValueWrapper valueWrapper2 = valueWrapper;
            if (valueWrapper2 instanceof ValueWrapper.Value) {
                this.origin.set(key, this.cast(((ValueWrapper.Value)valueWrapper).getValue()));
                continue;
            }
            if (!(valueWrapper2 instanceof ValueWrapper.AppendChain)) continue;
            this.origin.append(key, this.getMergedValue(key, valueWrapper, false));
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.origin.get(key);
        }
        this.resetInMemoryChanges();
        this.origin.flush(memoryCachesOnly);
    }

    @Override
    public synchronized void close() {
        this.origin.close();
    }

    @Override
    public synchronized void append(K key, V value2) {
        ValueWrapper.AppendChain appendChain;
        Object[] objectArray;
        if (!(this.valueExternalizer instanceof AppendableDataExternalizer)) {
            boolean $i$a$-check-DefaultInMemoryStorageWrapper$append$22 = false;
            String $i$a$-check-DefaultInMemoryStorageWrapper$append$22 = "`valueExternalizer` should implement the `AppendableDataExternalizer` interface to be able to call `append`";
            throw new IllegalStateException($i$a$-check-DefaultInMemoryStorageWrapper$append$22.toString());
        }
        ValueWrapper currentWrapper = this.inMemoryStorage.get(key);
        if (currentWrapper instanceof ValueWrapper.AppendChain) {
            ((List)this.cast(((ValueWrapper.AppendChain)currentWrapper).getParts())).add(value2);
            return;
        }
        if (currentWrapper instanceof ValueWrapper.Value) {
            objectArray = new Object[]{this.cast(((ValueWrapper.Value)currentWrapper).getValue()), value2};
            ValueWrapper.AppendChain appendChain2 = new ValueWrapper.AppendChain(CollectionsKt.mutableListOf((Object[])objectArray), false);
            appendChain = appendChain2;
        } else {
            objectArray = new Object[]{value2};
            ValueWrapper.AppendChain appendChain3 = new ValueWrapper.AppendChain(CollectionsKt.mutableListOf((Object[])objectArray), true);
            appendChain = appendChain3;
        }
        ValueWrapper.AppendChain newWrapper = appendChain;
        ((Map)this.inMemoryStorage).put(key, newWrapper);
    }

    @Override
    public synchronized void remove(K key) {
        this.removedKeys.add(key);
        this.inMemoryStorage.remove(key);
    }

    @Override
    public synchronized void set(K key, V value2) {
        ((Map)this.inMemoryStorage).put(key, new ValueWrapper.Value<V>(value2));
    }

    @Override
    @Nullable
    public synchronized V get(K key) {
        Object object;
        ValueWrapper wrapper = this.inMemoryStorage.get(key);
        if (wrapper instanceof ValueWrapper.Value) {
            object = this.cast(((ValueWrapper.Value)wrapper).getValue());
        } else if (wrapper instanceof ValueWrapper.AppendChain) {
            Object object2;
            Object mergedValue = object2 = DefaultInMemoryStorageWrapper.getMergedValue$default(this, key, wrapper, false, 4, null);
            boolean bl = false;
            ((Map)this.inMemoryStorage).put(key, new ValueWrapper.Value<Object>(mergedValue));
            object = object2;
        } else {
            object = !this.removedKeys.contains(key) ? this.origin.get(key) : null;
        }
        return (V)object;
    }

    @Override
    public synchronized boolean contains(K key) {
        return ((Map)this.inMemoryStorage).containsKey(key) || !this.removedKeys.contains(key) && this.origin.contains(key);
    }

    /*
     * WARNING - void declaration
     */
    private final V getMergedValue(K key, ValueWrapper wrapper, boolean useOriginValue) {
        Object accumulator$iv;
        if (!(!(wrapper instanceof ValueWrapper.Value))) {
            boolean $i$a$-check-DefaultInMemoryStorageWrapper$getMergedValue$32 = false;
            String $i$a$-check-DefaultInMemoryStorageWrapper$getMergedValue$32 = "There's no need to merge values for " + key;
            throw new IllegalStateException($i$a$-check-DefaultInMemoryStorageWrapper$getMergedValue$32.toString());
        }
        if (!(this.valueExternalizer instanceof AppendableDataExternalizer)) {
            boolean $i$a$-check-DefaultInMemoryStorageWrapper$getMergedValue$42 = false;
            String $i$a$-check-DefaultInMemoryStorageWrapper$getMergedValue$42 = "`valueExternalizer` should implement the `AppendableDataExternalizer` interface to be able to handle `append`";
            throw new IllegalStateException($i$a$-check-DefaultInMemoryStorageWrapper$getMergedValue$42.toString());
        }
        if (wrapper instanceof ValueWrapper.AppendChain) {
            Object t;
            Object element$iv;
            Iterable $this$fold$iv;
            if (useOriginValue && ((ValueWrapper.AppendChain)wrapper).getAppendToOrigin()) {
                Iterable iterable = CollectionsKt.listOfNotNull(this.getOriginValue(key));
                Object initial$iv = ((AppendableDataExternalizer)this.valueExternalizer).createNil();
                boolean $i$f$fold = false;
                Object accumulator$iv2 = initial$iv;
                Iterator iterator2 = $this$fold$iv.iterator();
                while (iterator2.hasNext()) {
                    void p1;
                    Object t2 = element$iv = iterator2.next();
                    Object p0 = accumulator$iv2;
                    boolean bl = false;
                    accumulator$iv2 = DefaultInMemoryStorageWrapper.getMergedValue$merge(this, p0, p1);
                }
                t = accumulator$iv2;
            } else {
                t = ((AppendableDataExternalizer)this.valueExternalizer).createNil();
            }
            Object initial = t;
            $this$fold$iv = (Iterable)this.cast(((ValueWrapper.AppendChain)wrapper).getParts());
            boolean $i$f$fold = false;
            accumulator$iv = initial;
            Iterator iterator3 = $this$fold$iv.iterator();
            while (iterator3.hasNext()) {
                void p1;
                Object element$iv2;
                element$iv = element$iv2 = iterator3.next();
                Object p0 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = DefaultInMemoryStorageWrapper.getMergedValue$merge(this, p0, p1);
            }
        } else {
            throw new IllegalStateException(("In-memory storage contains no value for " + key).toString());
        }
        return (V)accumulator$iv;
    }

    static /* synthetic */ Object getMergedValue$default(DefaultInMemoryStorageWrapper defaultInMemoryStorageWrapper, Object object, ValueWrapper valueWrapper, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return defaultInMemoryStorageWrapper.getMergedValue(object, valueWrapper, bl);
    }

    private final V getOriginValue(K key) {
        return !this.removedKeys.contains(key) ? (V)this.origin.get(key) : null;
    }

    private final <T> T cast(Object $this$cast) {
        return (T)$this$cast;
    }

    private static final <V, K> V getMergedValue$merge(DefaultInMemoryStorageWrapper<K, V> this$0, V acc, V append) {
        return ((AppendableDataExternalizer)this$0.valueExternalizer).append(acc, append);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper$ValueWrapper;", "", "AppendChain", "Value", "Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper$ValueWrapper$AppendChain;", "Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper$ValueWrapper$Value;", "kotlin-build-common"})
    private static interface ValueWrapper {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper$ValueWrapper$AppendChain;", "V", "Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper$ValueWrapper;", "parts", "", "appendToOrigin", "", "(Ljava/util/List;Z)V", "getAppendToOrigin", "()Z", "getParts", "()Ljava/util/List;", "kotlin-build-common"})
        public static final class AppendChain<V>
        implements ValueWrapper {
            @NotNull
            private final List<V> parts;
            private final boolean appendToOrigin;

            public AppendChain(@NotNull List<V> parts, boolean appendToOrigin) {
                Intrinsics.checkNotNullParameter(parts, (String)"parts");
                this.parts = parts;
                this.appendToOrigin = appendToOrigin;
            }

            @NotNull
            public final List<V> getParts() {
                return this.parts;
            }

            public final boolean getAppendToOrigin() {
                return this.appendToOrigin;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper$ValueWrapper$Value;", "V", "Lorg/jetbrains/kotlin/incremental/storage/DefaultInMemoryStorageWrapper$ValueWrapper;", "value", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "kotlin-build-common"})
        public static final class Value<V>
        implements ValueWrapper {
            private final V value;

            public Value(V value2) {
                this.value = value2;
            }

            public final V getValue() {
                return this.value;
            }
        }
    }
}

