/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.packageChecker.model.ModuleModel;
import com.intellij.packageChecker.model.ProjectDependenciesModelSimplified;
import com.intellij.packageChecker.model.ProjectSnapshot;
import com.intellij.packageChecker.service.IgnorableDependenciesServiceKt;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH&J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010\u000b\u001a\u00020\fH&J\b\u0010\u0014\u001a\u00020\u0015H&J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0016H\u0016R \u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lcom/intellij/packageChecker/model/ProjectDependenciesModelSimplified;", "", "modules", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lcom/intellij/packageChecker/model/ModuleModel;", "getModules", "()Lkotlinx/coroutines/flow/StateFlow;", "declaredDependencies", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "module", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/security/package/Package;", "project", "Lcom/intellij/packageChecker/model/ProjectSnapshot;", "psiFile", "Lcom/intellij/psi/PsiFile;", "libraryDependencies", "Lcom/intellij/packageChecker/model/LibraryDependency;", "refresh", "", "Lcom/intellij/openapi/project/Project;", "intellij.packageChecker"})
public interface ProjectDependenciesModelSimplified {
    @NotNull
    public StateFlow<Set<ModuleModel>> getModules();

    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile var1);

    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module var1);

    @NotNull
    default public List<Package> declaredDependencies(@NotNull ProjectSnapshot project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)project.getModules()), (Function1)((Function1)new Function1<Module, List<? extends PackageDeclaration>>(this){
            final /* synthetic */ ProjectDependenciesModelSimplified this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<PackageDeclaration> invoke(@NotNull Module module) {
                void $this$filterNotTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Iterable $this$filterNot$iv = this.this$0.declaredDependencies(module);
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    PackageDeclaration it = (PackageDeclaration)element$iv$iv;
                    boolean bl = false;
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Package package_ = it.getPkg();
                    String string = module.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (IgnorableDependenciesServiceKt.isPackageIgnored(project, package_, string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        })), (Function1)declaredDependencies.2.INSTANCE));
    }

    public void refresh();

    default public void refresh(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.refresh();
    }

    @NotNull
    public List<LibraryDependency> libraryDependencies(@NotNull Module var1);
}

