/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.packageChecker.model.GeneralRepositoryServer;
import com.intellij.packageChecker.model.GeneralRepositoryServerKt;
import com.intellij.packageChecker.model.HttpClientApi;
import com.intellij.packageChecker.model.HttpClientKt;
import com.intellij.packageChecker.model.ResourceUrl;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.ClientData;
import org.jetbrains.security.dto.HashesDto;
import org.jetbrains.security.dto.RequestDto;
import org.jetbrains.security.exceptions.AnalysisException;
import org.jetbrains.security.exceptions.AnalysisExceptionScope;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J>\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001c\"\u0004\b\u0000\u0010\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001a2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u001c0#H\u0082@\u00a2\u0006\u0002\u0010$JV\u0010%\u001a\b\u0012\u0004\u0012\u0002H&0\u001c\"\u0004\b\u0000\u0010&\"\u0004\b\u0001\u0010\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0(2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u001c0#2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H&0*H\u0084@\u00a2\u0006\u0002\u0010+R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/packageChecker/model/GeneralRepositoryServer;", "", "clientData", "Lorg/jetbrains/security/ClientData;", "packagesUrlString", "", "dbBaseUrl", "Lcom/intellij/packageChecker/model/ResourceUrl;", "attemptsToCheck", "", "requestTimeout", "Ljava/time/Duration;", "(Lorg/jetbrains/security/ClientData;Ljava/lang/String;Lcom/intellij/packageChecker/model/ResourceUrl;ILjava/time/Duration;)V", "chunkSize", "httpClient", "Lcom/intellij/packageChecker/model/HttpClientApi;", "getHttpClient", "()Lcom/intellij/packageChecker/model/HttpClientApi;", "httpClient$delegate", "Lkotlin/Lazy;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "createRequestDto", "Lorg/jetbrains/security/dto/RequestDto;", "packageChunk", "", "Lorg/jetbrains/security/package/Package;", "getPackagesFromServer", "DTO", "url", "requestData", "bodyHandler", "Ljava/net/http/HttpResponse$BodyHandler;", "(Ljava/lang/String;Lorg/jetbrains/security/dto/RequestDto;Ljava/net/http/HttpResponse$BodyHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStatusForPackages", "T", "pkgs", "", "transform", "Lkotlin/Function1;", "(Ljava/lang/Iterable;Ljava/net/http/HttpResponse$BodyHandler;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nGeneralRepositoryServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralRepositoryServer.kt\ncom/intellij/packageChecker/model/GeneralRepositoryServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,111:1\n1360#2:112\n1446#2,2:113\n1549#2:116\n1620#2,3:117\n1448#2,3:120\n1549#2:123\n1620#2,3:124\n326#3:115\n*S KotlinDebug\n*F\n+ 1 GeneralRepositoryServer.kt\ncom/intellij/packageChecker/model/GeneralRepositoryServer\n*L\n56#1:112\n56#1:113,2\n65#1:116\n65#1:117,3\n56#1:120,3\n93#1:123\n93#1:124,3\n57#1:115\n*E\n"})
public class GeneralRepositoryServer {
    @NotNull
    private final ClientData clientData;
    @NotNull
    private final String packagesUrlString;
    @NotNull
    private final ResourceUrl dbBaseUrl;
    private final int attemptsToCheck;
    @NotNull
    private final Duration requestTimeout;
    private final int chunkSize;
    private final ObjectMapper objectMapper;
    @NotNull
    private final Lazy httpClient$delegate;

    public GeneralRepositoryServer(@NotNull ClientData clientData, @NotNull String packagesUrlString, @NotNull ResourceUrl dbBaseUrl, int attemptsToCheck, @NotNull Duration requestTimeout) {
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        Intrinsics.checkNotNullParameter((Object)packagesUrlString, (String)"packagesUrlString");
        Intrinsics.checkNotNullParameter((Object)dbBaseUrl, (String)"dbBaseUrl");
        Intrinsics.checkNotNullParameter((Object)requestTimeout, (String)"requestTimeout");
        this.clientData = clientData;
        this.packagesUrlString = packagesUrlString;
        this.dbBaseUrl = dbBaseUrl;
        this.attemptsToCheck = attemptsToCheck;
        this.requestTimeout = requestTimeout;
        this.chunkSize = 4096;
        this.objectMapper = ExtensionsKt.registerKotlinModule$default((ObjectMapper)new ObjectMapper(), null, (int)1, null).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.httpClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HttpClientApi>(this){
            final /* synthetic */ GeneralRepositoryServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HttpClientApi invoke() {
                String string = GeneralRepositoryServer.access$getClientData$p(this.this$0).getJbaUserId();
                if (string == null) {
                    string = GeneralRepositoryServer.access$getClientData$p(this.this$0).getAnonymousToken();
                }
                return new HttpClientApi(HttpClientKt.getHeaderParams(string), GeneralRepositoryServer.access$getRequestTimeout$p(this.this$0));
            }
        }));
    }

    public /* synthetic */ GeneralRepositoryServer(ClientData clientData, String string, ResourceUrl resourceUrl, int n, Duration duration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            LocalDateTime localDateTime = LocalDateTime.now().plusHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"plusHours(...)");
            resourceUrl = new ResourceUrl("https://vulnerability-search.europe-north1-gke.intellij.net", localDateTime);
        }
        if ((n2 & 8) != 0) {
            n = 3;
        }
        if ((n2 & 0x10) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        this(clientData, string, resourceUrl, n, duration);
    }

    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    protected final HttpClientApi getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (HttpClientApi)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final <T, DTO> Object getStatusForPackages(@NotNull Iterable<Package> var1_1, @NotNull HttpResponse.BodyHandler<List<DTO>> var2_2, @NotNull Function1<? super DTO, ? extends T> var3_3, @NotNull Continuation<? super List<? extends T>> var4_4) {
        block22: {
            block21: {
                if (!(var4_4 instanceof getStatusForPackages.1)) ** GOTO lbl-1000
                var25_5 = var4_4;
                if ((var25_5.label & -2147483648) != 0) {
                    var25_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var4_4){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ GeneralRepositoryServer this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.getStatusForPackages(null, null, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var26_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block2 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!(this.attemptsToCheck > 0)) {
                            var6_8 = "Failed requirement.";
                            throw new IllegalArgumentException(var6_8.toString());
                        }
                        $this$flatMap$iv = CollectionsKt.chunked((Iterable)pkgs, (int)this.chunkSize);
                        $i$f$flatMap = false;
                        var7_11 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = false;
                        var10_14 = $this$flatMapTo$iv$iv.iterator();
lbl21:
                        // 2 sources

                        while (var10_14.hasNext()) {
                            element$iv$iv = var10_14.next();
                            pkgChunk = (List)element$iv$iv;
                            $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = false;
                            $i$f$currentCoroutineContext = false;
                            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                            attempt = 0;
                            exception = null;
lbl30:
                            // 3 sources

                            while (attempt < this.attemptsToCheck) {
                                ++attempt;
                                if (pkgChunk.isEmpty()) {
                                    v0 = CollectionsKt.emptyList();
                                    break block21;
                                }
                                $continuation.L$0 = this;
                                $continuation.L$1 = bodyHandler;
                                $continuation.L$2 = transform;
                                $continuation.L$3 = destination$iv$iv;
                                $continuation.L$4 = var10_14;
                                $continuation.L$5 = pkgChunk;
                                $continuation.L$6 = exception;
                                $continuation.I$0 = attempt;
                                $continuation.label = 1;
                                v1 = this.getPackagesFromServer(this.dbBaseUrl.url + this.packagesUrlString, this.createRequestDto(pkgChunk), bodyHandler, (Continuation<? super List<? extends DTO>>)$continuation);
                                ** if (v1 != var26_7) goto lbl50
lbl49:
                                // 1 sources

                                return var26_7;
lbl50:
                                // 1 sources

                                ** GOTO lbl69
                            }
                            break block2;
                        }
                        break block22;
                    }
                    case 1: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = false;
                        attempt = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$6;
                        pkgChunk = (List)$continuation.L$5;
                        var10_14 = (Iterator<T>)$continuation.L$4;
                        destination$iv$iv = (Collection)$continuation.L$3;
                        transform = (Function1)$continuation.L$2;
                        bodyHandler = (HttpResponse.BodyHandler)$continuation.L$1;
                        this = (GeneralRepositoryServer)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl69:
                            // 2 sources

                            $this$map$iv = (Iterable)v1;
                            $i$f$map = false;
                            var18_25 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                destination$iv$iv.add(transform.invoke(item$iv$iv));
                            }
                            v0 = (List)destination$iv$iv;
                            break block21;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = "Failed to check dependencies on server: " + this.dbBaseUrl.url;
                            var18_25 = e;
                            if ((var18_25 instanceof IOException != false ? true : var18_25 instanceof IllegalArgumentException) != false ? true : var18_25 instanceof AnalysisException) {
                                GeneralRepositoryServerKt.access$getLogger$p().warn(message);
                                GeneralRepositoryServerKt.access$getLogger$p().debug((Throwable)e);
                                if (e instanceof AnalysisException) {
                                    v2 = (AnalysisException)e;
                                } else {
                                    v3 = e.getMessage();
                                    if (v3 == null) {
                                        v3 = e.getClass().getSimpleName();
                                    }
                                    var19_26 = v3;
                                    Intrinsics.checkNotNull((Object)var19_26);
                                    v2 = new AnalysisException(message, AnalysisExceptionScope.USER, var19_26);
                                }
                                exception = v2;
                            }
                            $continuation.L$0 = this;
                            $continuation.L$1 = bodyHandler;
                            $continuation.L$2 = transform;
                            $continuation.L$3 = destination$iv$iv;
                            $continuation.L$4 = var10_14;
                            $continuation.L$5 = pkgChunk;
                            $continuation.L$6 = exception;
                            $continuation.I$0 = attempt;
                            $continuation.label = 2;
                            v4 = DelayKt.delay((long)(attempt * 200), $continuation);
                            if (v4 != var26_7) ** GOTO lbl30
                            return var26_7;
                        }
                    }
                    case 2: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = false;
                        attempt = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$6;
                        pkgChunk = (List)$continuation.L$5;
                        var10_14 = (Iterator)$continuation.L$4;
                        destination$iv$iv = (Collection)$continuation.L$3;
                        transform = (Function1)$continuation.L$2;
                        bodyHandler = (HttpResponse.BodyHandler)$continuation.L$1;
                        this = (GeneralRepositoryServer)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        ** GOTO lbl30
                    }
                }
                if (exception != null) {
                    v5 = GeneralRepositoryServerKt.access$getLogger$p();
                    var16_21 = exception.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)var16_21, (String)"getStackTrace(...)");
                    v6 = var16_21;
                    v7 = LineSeparator.getSystemLineSeparator().getSeparatorString();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getSeparatorString(...)");
                    v5.warn(ArraysKt.joinToString$default((Object[])v6, (CharSequence)v7, null, null, (int)0, null, null, (int)62, null));
                }
                v0 = CollectionsKt.emptyList();
            }
            list$iv$iv = v0;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            ** GOTO lbl21
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final RequestDto createRequestDto(List<Package> packageChunk) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = packageChunk;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchKey());
        }
        List packageDTOs = (List)destination$iv$iv;
        return new HashesDto(packageDTOs, this.clientData.getAnonymousToken(), this.clientData.getApplicationMode());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final <DTO> Object getPackagesFromServer(String var1_1, RequestDto var2_2, HttpResponse.BodyHandler<List<DTO>> var3_3, Continuation<? super List<? extends DTO>> var4_4) {
        if (!(var4_4 instanceof getPackagesFromServer.1)) ** GOTO lbl-1000
        var9_5 = var4_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GeneralRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GeneralRepositoryServer.access$getPackagesFromServer(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                requestDataJson = this.objectMapper.writeValueAsString((Object)requestData);
                v0 = this.getHttpClient();
                var7_10 = HttpRequest.BodyPublishers.ofString(requestDataJson);
                Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"ofString(...)");
                $continuation.L$0 = url;
                $continuation.label = 1;
                v1 = v0.post(url, var7_10, bodyHandler, $continuation);
                ** if (v1 != var10_7) goto lbl23
lbl22:
                // 1 sources

                return var10_7;
lbl23:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                url = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl30:
                    // 2 sources

                    var5_11 /* !! */  = ((HttpResponse)v1).body();
                    Intrinsics.checkNotNull(var5_11 /* !! */ );
                    var5_11 /* !! */  = (List)var5_11 /* !! */ ;
                }
                catch (Exception var6_9) {
                    throw new AnalysisException("Failed to check dependencies on server: " + url, AnalysisExceptionScope.USER, null, 4, null);
                }
                return var5_11 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$getPackagesFromServer(GeneralRepositoryServer $this, String url, RequestDto requestData, HttpResponse.BodyHandler bodyHandler2, Continuation $completion) {
        return $this.getPackagesFromServer(url, requestData, bodyHandler2, $completion);
    }

    public static final /* synthetic */ ClientData access$getClientData$p(GeneralRepositoryServer $this) {
        return $this.clientData;
    }

    public static final /* synthetic */ Duration access$getRequestTimeout$p(GeneralRepositoryServer $this) {
        return $this.requestTimeout;
    }
}

