/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.gradle.workaround;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.gradle.workaround.DependencyModificator;
import com.intellij.packageChecker.gradle.workaround.GradleGroovyVulnerablePackageFix;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.dsl.GradleDependencyModificator;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/packageChecker/gradle/workaround/GradleDependencyModificatorPatched;", "Lcom/intellij/packageChecker/gradle/workaround/DependencyModificator;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getArtifactModel", "Lcom/android/tools/idea/gradle/dsl/api/dependencies/ArtifactDependencyModel;", "module", "Lcom/intellij/openapi/module/Module;", "oldDescriptor", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "throwFailToModify", "", "updateDependency", "", "newDescriptor", "updatePsi", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.packageChecker.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleDependencyModificatorPatched.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDependencyModificatorPatched.kt\ncom/intellij/packageChecker/gradle/workaround/GradleDependencyModificatorPatched\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n13#2:68\n13#2:69\n*S KotlinDebug\n*F\n+ 1 GradleDependencyModificatorPatched.kt\ncom/intellij/packageChecker/gradle/workaround/GradleDependencyModificatorPatched\n*L\n28#1:68\n35#1:69\n*E\n"})
public final class GradleDependencyModificatorPatched
implements DependencyModificator {
    @NotNull
    private final Project project;

    public GradleDependencyModificatorPatched(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void updateDependency(@NotNull Module module, @NotNull UnifiedDependency oldDescriptor, @NotNull UnifiedDependency newDescriptor) {
        ArtifactDependencyModel newModel;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)oldDescriptor, (String)"oldDescriptor");
        Intrinsics.checkNotNullParameter((Object)newDescriptor, (String)"newDescriptor");
        ArtifactDependencyModel artifactModel = this.getArtifactModel(module, oldDescriptor);
        if (artifactModel == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GradleDependencyModificator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to update dependency '" + oldDescriptor + "': not found in module " + module.getName());
            return;
        }
        new GradleDependencyModificator(this.project).updateDependency(module, oldDescriptor, newDescriptor);
        ArtifactDependencyModel artifactDependencyModel = newModel = this.getArtifactModel(module, oldDescriptor);
        if (Intrinsics.areEqual((Object)(artifactDependencyModel != null ? artifactDependencyModel.getSpec() : null), (Object)artifactModel.getSpec())) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GradleDependencyModificatorPatched.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Dependency wasn't updated");
            PsiElement psiElement = artifactModel.getRepresentativeContainedPsiElement();
            if (psiElement == null) {
                throw new IllegalStateException("Could not update model without psi");
            }
            PsiElement psiElement2 = psiElement;
            this.updatePsi(psiElement2, oldDescriptor, newDescriptor);
        }
    }

    private final void updatePsi(PsiElement psiElement, UnifiedDependency oldDescriptor, UnifiedDependency newDescriptor) {
        if (!(psiElement instanceof GroovyPsiElement)) {
            throw new IllegalStateException("Unknown PsiElement: " + psiElement);
        }
        Package package_ = JavaPackageUtilKt.toPackage(newDescriptor);
        Intrinsics.checkNotNull((Object)package_);
        new GradleGroovyVulnerablePackageFix(package_).doFix(psiElement);
    }

    private final ArtifactDependencyModel getArtifactModel(Module module, UnifiedDependency oldDescriptor) {
        Object v3;
        block2: {
            GradleBuildModel gradleBuildModel = ProjectBuildModel.get((Project)module.getProject()).getModuleBuildModel(module);
            if (gradleBuildModel == null) {
                this.throwFailToModify(module);
                throw new KotlinNothingValueException();
            }
            GradleBuildModel model = gradleBuildModel;
            List list = model.dependencies().artifacts();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"artifacts(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                ArtifactDependencyModel it = (ArtifactDependencyModel)t;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it.group().valueAsString(), (Object)oldDescriptor.getCoordinates().getGroupId()) && Intrinsics.areEqual((Object)it.name().valueAsString(), (Object)oldDescriptor.getCoordinates().getArtifactId()) && Intrinsics.areEqual((Object)it.version().valueAsString(), (Object)oldDescriptor.getCoordinates().getVersion()) && Intrinsics.areEqual((Object)it.configurationName(), (Object)oldDescriptor.getScope());
                if (!bl2) continue;
                v3 = t;
                break block2;
            }
            v3 = null;
        }
        ArtifactDependencyModel artifactModel = v3;
        return artifactModel;
    }

    private final Void throwFailToModify(Module module) {
        Object[] objectArray = new Object[]{module.getName()};
        throw new IllegalStateException(GradleBundle.message((String)"gradle.dsl.model.fail.to.build", (Object[])objectArray));
    }
}

