/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JLabelTextQuery;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.driver.TextDisplayDriver;
import org.assertj.swing.internal.annotation.InternalApi;

@InternalApi
public class JLabelDriver
extends JComponentDriver
implements TextDisplayDriver<JLabel> {
    private static final String TEXT_PROPERTY = "text";

    public JLabelDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JLabel label, @Nullable String expected) {
        ((TextAssert)TextAssert.verifyThat(this.textOf(label)).as(JLabelDriver.propertyName(label, TEXT_PROPERTY))).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JLabel label, @Nonnull Pattern pattern) {
        ((TextAssert)TextAssert.verifyThat(this.textOf(label)).as(JLabelDriver.propertyName(label, TEXT_PROPERTY))).matches(pattern);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JLabel label) {
        return JLabelTextQuery.textOf(label);
    }
}

