/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detection;

import ai.grazie.detector.ChainLanguageDetector;
import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.word.StandardWordTokenizer;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.config.DetectionContext;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0017\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR5\u0010\u0003\u001a)\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\b0\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/grazie/detection/LangDetector;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lkotlin/Pair;", "", "", "Lorg/jetbrains/annotations/NotNull;", "Lai/grazie/detector/ChainLanguageDetector$ChainDetectionResult;", "detector", "Lai/grazie/detector/ChainLanguageDetector;", "getDetector", "()Lai/grazie/detector/ChainLanguageDetector;", "detector$delegate", "Lkotlin/Lazy;", "textLimit", "", "detectWithDetails", "textToDetect", "isReliable", "getLang", "Lcom/intellij/grazie/jlanguage/Lang;", "text", "getLanguage", "Lai/grazie/nlp/langs/Language;", "updateContext", "", "", "context", "Lcom/intellij/grazie/config/DetectionContext$Local;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLangDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangDetector.kt\ncom/intellij/grazie/detection/LangDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class LangDetector {
    @NotNull
    public static final LangDetector INSTANCE = new LangDetector();
    @NotNull
    private static final Lazy detector$delegate = LazyKt.lazy((Function0)detector.2.INSTANCE);
    @NotNull
    private static final ConcurrentMap<Pair<String, Boolean>, ChainLanguageDetector.ChainDetectionResult> cache;
    private static final int textLimit = 1000;

    private LangDetector() {
    }

    private final ChainLanguageDetector<String> getDetector() {
        Lazy lazy = detector$delegate;
        return (ChainLanguageDetector)lazy.getValue();
    }

    private final ChainLanguageDetector.ChainDetectionResult detectWithDetails(String textToDetect, boolean isReliable) {
        if (!(textToDetect.length() <= 1000)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ChainLanguageDetector.ChainDetectionResult chainDetectionResult = cache.computeIfAbsent((Pair<String, Boolean>)TuplesKt.to((Object)textToDetect, (Object)isReliable), arg_0 -> LangDetector.detectWithDetails$lambda$0(detectWithDetails.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)chainDetectionResult, (String)"computeIfAbsent(...)");
        return chainDetectionResult;
    }

    @Nullable
    public final Language getLanguage(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Language detected = this.detectWithDetails(StringsKt.take((String)text2, (int)1000), false).getResult().getPreferred();
        return detected == Language.UNKNOWN ? null : detected;
    }

    @Nullable
    public final Lang getLang(@NotNull String text2) {
        Lang lang;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Language language = this.getLanguage(text2);
        if (language != null) {
            Object v1;
            block3: {
                Language language2 = language;
                boolean bl = false;
                Iterable iterable = GrazieConfig.Companion.get().getAvailableLanguages();
                for (Object t : iterable) {
                    Lang lang2 = (Lang)((Object)t);
                    boolean bl2 = false;
                    if (!lang2.equalsTo(language2)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            lang = v1;
        } else {
            lang = null;
        }
        return lang;
    }

    public final void updateContext(@NotNull CharSequence text2, @NotNull DetectionContext.Local context) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String textToDetect = ((Object)StringsKt.take((CharSequence)text2, (int)1000)).toString();
        ChainLanguageDetector.ChainDetectionResult details = this.detectWithDetails(textToDetect, true);
        int wordsCount = ((Collection)StandardWordTokenizer.INSTANCE.words(textToDetect)).size();
        context.update(text2.length(), wordsCount, details);
    }

    private static final ChainLanguageDetector.ChainDetectionResult detectWithDetails$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChainLanguageDetector.ChainDetectionResult)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ChainLanguageDetector access$getDetector(LangDetector $this) {
        return $this.getDetector();
    }

    static {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        cache = concurrentMap;
    }
}

