/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays.declarative;

import com.intellij.codeInsight.hints.InlayDumpUtil;
import com.intellij.codeInsight.hints.declarative.InlayActionData;
import com.intellij.codeInsight.hints.declarative.InlayActionPayload;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayProviderPassInfo;
import com.intellij.codeInsight.hints.declarative.PsiPointerInlayActionPayload;
import com.intellij.codeInsight.hints.declarative.StringInlayActionPayload;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeHintsPreviewProvider;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPass;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPassFactory;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayRenderer;
import com.intellij.codeInsight.hints.declarative.impl.InlayMouseArea;
import com.intellij.codeInsight.hints.declarative.impl.InlayPresentationEntry;
import com.intellij.codeInsight.hints.declarative.impl.TextInlayPresentationEntry;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.utils.inlays.InlayHintsProviderTestCase;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J(\u0010\u0011\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J>\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001bR(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/intellij/testFramework/utils/inlays/declarative/DeclarativeInlayHintsProviderTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "()V", "customToStringProvider", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "", "getCustomToStringProvider", "()Lkotlin/jvm/functions/Function1;", "setCustomToStringProvider", "(Lkotlin/jvm/functions/Function1;)V", "applyPassAndCheckResult", "", "pass", "Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPass;", "previewText", "expectedText", "doTestPreview", "providerId", "provider", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "language", "Lcom/intellij/lang/Language;", "doTestProvider", "fileName", "enabledOptions", "", "", "verifyHintsPresence", "intellij.platform.testFramework"})
public abstract class DeclarativeInlayHintsProviderTestCase
extends BasePlatformTestCase {
    @Nullable
    private Function1<? super PsiElement, String> customToStringProvider;

    public final void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider provider, @NotNull Map<String, Boolean> enabledOptions, boolean verifyHintsPresence) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter(enabledOptions, (String)"enabledOptions");
        if (verifyHintsPresence) {
            InlayHintsProviderTestCase.Companion.verifyHintsPresence(expectedText);
        }
        String sourceText = InlayDumpUtil.INSTANCE.removeHints(expectedText);
        this.myFixture.configureByText(fileName, sourceText);
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        Editor editor = this.myFixture.getEditor();
        InlayProviderPassInfo providerInfo = new InlayProviderPassInfo(provider, "provider.id", enabledOptions);
        PsiElement psiElement = (PsiElement)file2;
        Intrinsics.checkNotNull((Object)editor);
        DeclarativeInlayHintsPass pass = new DeclarativeInlayHintsPass(psiElement, editor, CollectionsKt.listOf((Object)providerInfo), false, false, 16, null);
        this.applyPassAndCheckResult(pass, sourceText, expectedText);
    }

    public static /* synthetic */ void doTestProvider$default(DeclarativeInlayHintsProviderTestCase declarativeInlayHintsProviderTestCase, String string, String string2, InlayHintsProvider inlayHintsProvider, Map map, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTestProvider");
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        declarativeInlayHintsProviderTestCase.doTestProvider(string, string2, inlayHintsProvider, map, bl);
    }

    public final void doTestPreview(@Language(value="JAVA") @NotNull String expectedText, @NotNull String providerId, @NotNull InlayHintsProvider provider, @NotNull com.intellij.lang.Language language) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String string = DeclarativeHintsPreviewProvider.INSTANCE.getPreview(language, providerId, provider);
        if (string == null) {
            throw new IllegalStateException(("Preview not found for provider: " + providerId).toString());
        }
        String previewText = string;
        Object object = language.getAssociatedFileType();
        if (object == null || (object = object.getDefaultExtension()) == null) {
            throw new IllegalStateException("language must have extension".toString());
        }
        String fileName = "preview." + (String)object;
        this.myFixture.configureByText(fileName, InlayDumpUtil.INSTANCE.removeHints(previewText));
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        Editor editor = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        DeclarativeInlayHintsPass pass = DeclarativeInlayHintsPassFactory.Companion.createPassForPreview(psiFile, editor, provider, providerId, MapsKt.emptyMap(), false);
        this.applyPassAndCheckResult(pass, previewText, expectedText);
    }

    private final void applyPassAndCheckResult(DeclarativeInlayHintsPass pass, String previewText, String expectedText) {
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ActionUtil.underModalProgress((Project)project2, (String)"", () -> DeclarativeInlayHintsProviderTestCase.applyPassAndCheckResult$lambda$0(pass));
        pass.applyInformationToEditor();
        Function2 function2 = new Function2<EditorCustomElementRenderer, Inlay<?>, String>(this){
            final /* synthetic */ DeclarativeInlayHintsProviderTestCase this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final String invoke(@NotNull EditorCustomElementRenderer renderer, @NotNull Inlay<?> inlay) {
                Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                Intrinsics.checkNotNullParameter(inlay, (String)"<anonymous parameter 1>");
                DeclarativeInlayRenderer cfr_ignored_0 = (DeclarativeInlayRenderer)renderer;
                return ArraysKt.joinToString$default((Object[])((DeclarativeInlayRenderer)renderer).getPresentationList().getEntries(), (CharSequence)"|", null, null, (int)0, null, (Function1)((Function1)new Function1<InlayPresentationEntry, CharSequence>(this.this$0){
                    final /* synthetic */ DeclarativeInlayHintsProviderTestCase this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull InlayPresentationEntry entry) {
                        CharSequence charSequence;
                        block6: {
                            InlayActionPayload inlayActionPayload;
                            InlayActionPayload payload;
                            InlayActionData actionData;
                            String text;
                            block3: {
                                Object object;
                                block5: {
                                    block4: {
                                        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                                        text = ((TextInlayPresentationEntry)entry).getText();
                                        InlayMouseArea inlayMouseArea = entry.getClickArea();
                                        InlayActionData inlayActionData = actionData = inlayMouseArea != null ? inlayMouseArea.getActionData() : null;
                                        inlayActionPayload = payload = inlayActionData != null ? inlayActionData.getPayload() : null;
                                        if (!(inlayActionPayload instanceof PsiPointerInlayActionPayload)) break block3;
                                        object = ((PsiPointerInlayActionPayload)payload).getPointer().getElement();
                                        if (object == null) break block4;
                                        PsiElement psiElement = object;
                                        DeclarativeInlayHintsProviderTestCase declarativeInlayHintsProviderTestCase = this.this$0;
                                        PsiElement it = psiElement;
                                        boolean bl = false;
                                        Function1<PsiElement, String> function1 = declarativeInlayHintsProviderTestCase.getCustomToStringProvider();
                                        String string = function1 != null ? (String)function1.invoke((Object)it) : null;
                                        object = string;
                                        if (string != null) break block5;
                                    }
                                    object = "";
                                }
                                charSequence = (String)object + text;
                                break block6;
                            }
                            charSequence = inlayActionPayload instanceof StringInlayActionPayload ? (CharSequence)("[" + ((StringInlayActionPayload)payload).getText() + ":" + actionData.getHandlerId() + "]" + text) : (CharSequence)text;
                        }
                        return charSequence;
                    }
                }), (int)30, null);
            }
        };
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        Editor editor = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        PsiFile psiFile2 = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Document document = this.myFixture.getDocument(psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        String dump2 = InlayDumpUtil.dumpHintsInternal$default((InlayDumpUtil)InlayDumpUtil.INSTANCE, (String)previewText, null, (Function2)function2, (PsiFile)psiFile, (Editor)editor, (Document)document, (int)0, (int)66, null);
        BasePlatformTestCase.assertEquals((String)((Object)StringsKt.trim((CharSequence)expectedText)).toString(), (String)((Object)StringsKt.trim((CharSequence)dump2)).toString());
    }

    @Nullable
    public final Function1<PsiElement, String> getCustomToStringProvider() {
        return this.customToStringProvider;
    }

    public final void setCustomToStringProvider(@Nullable Function1<? super PsiElement, String> function1) {
        this.customToStringProvider = function1;
    }

    private static final Unit applyPassAndCheckResult$lambda$0(DeclarativeInlayHintsPass $pass) {
        Intrinsics.checkNotNullParameter((Object)$pass, (String)"$pass");
        $pass.doCollectInformation((ProgressIndicator)new EmptyProgressIndicator());
        return Unit.INSTANCE;
    }
}

