/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.artifacts;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class ArtifactsTestUtil {
    public static String printToString(PackagingElement element2, int level) {
        StringBuilder builder = new StringBuilder(StringUtil.repeatSymbol((char)' ', (int)level));
        if (element2 instanceof ArchivePackagingElement) {
            builder.append(((ArchivePackagingElement)element2).getArchiveFileName());
        } else if (element2 instanceof DirectoryPackagingElement) {
            builder.append(((DirectoryPackagingElement)element2).getDirectoryName()).append("/");
        } else {
            builder.append(element2.toString());
        }
        builder.append("\n");
        if (element2 instanceof CompositePackagingElement) {
            for (PackagingElement child : ((CompositePackagingElement)element2).getChildren()) {
                builder.append(ArtifactsTestUtil.printToString(child, level + 1));
            }
        }
        return builder.toString();
    }

    public static void assertLayout(PackagingElement element2, String expected) {
        Assert.assertEquals((Object)ArtifactsTestUtil.adjustMultiLine(expected), (Object)ArtifactsTestUtil.printToString(element2, 0));
    }

    private static String adjustMultiLine(String expected) {
        List strings = StringUtil.split((String)StringUtil.trimStart((String)expected, (String)"\n"), (String)"\n");
        int min = Integer.MAX_VALUE;
        for (String s : strings) {
            int k;
            for (k = 0; k < s.length() && s.charAt(k) == ' '; ++k) {
            }
            min = Math.min(min, k);
        }
        ArrayList<String> lines2 = new ArrayList<String>();
        for (String s : strings) {
            lines2.add(s.substring(min));
        }
        return StringUtil.join(lines2, (String)"\n") + "\n";
    }

    public static void assertLayout(Project project2, String artifactName, String expected) {
        ArtifactsTestUtil.assertLayout((PackagingElement)ArtifactsTestUtil.findArtifact(project2, artifactName).getRootElement(), expected);
    }

    public static void assertOutputPath(Project project2, String artifactName, String expected) {
        Assert.assertEquals((Object)expected, (Object)ArtifactsTestUtil.findArtifact(project2, artifactName).getOutputPath());
    }

    public static void assertOutputFileName(Project project2, String artifactName, String expected) {
        Assert.assertEquals((Object)expected, (Object)ArtifactsTestUtil.findArtifact(project2, artifactName).getRootElement().getName());
    }

    public static void setOutput(Project project2, String artifactName, String outputPath) {
        WriteAction.runAndWait(() -> {
            ModifiableArtifactModel model2 = ArtifactManager.getInstance((Project)project2).createModifiableModel();
            model2.getOrCreateModifiableArtifact(ArtifactsTestUtil.findArtifact(project2, artifactName)).setOutputPath(outputPath);
            model2.commit();
        });
    }

    public static void addArtifactToLayout(Project project2, Artifact parent, Artifact toAdd) {
        WriteAction.runAndWait(() -> {
            ModifiableArtifactModel model2 = ArtifactManager.getInstance((Project)project2).createModifiableModel();
            PackagingElement artifactElement = PackagingElementFactory.getInstance().createArtifactElement(toAdd, project2);
            model2.getOrCreateModifiableArtifact(parent).getRootElement().addOrFindChild(artifactElement);
            model2.commit();
        });
    }

    public static Artifact findArtifact(Project project2, String artifactName) {
        ArtifactManager manager = ArtifactManager.getInstance((Project)project2);
        Artifact artifact = ApplicationManager.getApplication().isReadAccessAllowed() ? manager.findArtifact(artifactName) : (Artifact)ReadAction.compute(() -> manager.findArtifact(artifactName));
        Assert.assertNotNull((String)("'" + artifactName + "' artifact not found"), (Object)artifact);
        return artifact;
    }

    public static void assertManifest(Artifact artifact, PackagingElementResolvingContext context2, @Nullable String mainClass, @Nullable String classpath) {
        CompositePackagingElement rootElement = artifact.getRootElement();
        ArtifactType type = artifact.getArtifactType();
        ArtifactsTestUtil.assertManifest(rootElement, context2, type, mainClass, classpath);
    }

    public static void assertManifest(CompositePackagingElement<?> rootElement, PackagingElementResolvingContext context2, ArtifactType type, @Nullable String mainClass, @Nullable String classpath) {
        VirtualFile file2 = ManifestFileUtil.findManifestFile(rootElement, (PackagingElementResolvingContext)context2, (ArtifactType)type);
        Assert.assertNotNull((Object)file2);
        Manifest manifest = ManifestFileUtil.readManifest((VirtualFile)file2);
        Assert.assertEquals((Object)mainClass, (Object)manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS));
        Assert.assertEquals((Object)classpath, (Object)manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH));
    }
}

