/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.mac;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.nativecerts.NativeTrustedRootsInternalUtils;
import org.jetbrains.nativecerts.mac.CFArrayRefByReference;
import org.jetbrains.nativecerts.mac.CoreFoundationExt;
import org.jetbrains.nativecerts.mac.SecurityFramework;

public class SecurityFrameworkUtil {
    private static final Logger LOGGER = Logger.getLogger(SecurityFrameworkUtil.class.getName());

    public static List<X509Certificate> getTrustedRoots(SecurityFramework.SecTrustSettingsDomain domain) {
        List<X509Certificate> result2 = SecurityFrameworkUtil.SecTrustSettingsCopyCertificates(domain, cert -> SecurityFrameworkUtil.isTrustedRoot(domain, cert));
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder();
            message.append("Received ").append(result2.size()).append(" certificates from trust settings domain ").append((Object)domain);
            for (X509Certificate certificate : result2) {
                message.append("\n  ").append(certificate.getSubjectDN());
            }
            LOGGER.fine(message.toString());
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<X509Certificate> SecTrustSettingsCopyCertificates(@NotNull SecurityFramework.SecTrustSettingsDomain domain, Predicate<SecurityFramework.SecCertificateRef> predicate) {
        CFArrayRefByReference returnedCertArray = new CFArrayRefByReference();
        SecurityFramework.OSStatus rc = SecurityFramework.INSTANCE.SecTrustSettingsCopyCertificates(domain, returnedCertArray);
        if (SecurityFramework.OSStatus.errSecNoTrustSettings.equals((Object)rc)) {
            return Collections.emptyList();
        }
        if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
            throw new IllegalStateException("Getting trust settings for domain " + domain + " failed: " + rc);
        }
        CoreFoundation.CFArrayRef certArray = returnedCertArray.getArray();
        if (certArray == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<X509Certificate> result2 = new ArrayList<X509Certificate>();
            for (int i = 0; i < certArray.getCount(); ++i) {
                SecurityFramework.SecCertificateRef secCertificateRef = new SecurityFramework.SecCertificateRef(certArray.getValueAtIndex(i));
                if (!predicate.test(secCertificateRef)) continue;
                try {
                    result2.add(SecurityFrameworkUtil.getX509Certificate(secCertificateRef));
                    continue;
                }
                catch (Throwable parsingError) {
                    String certificateDescription = CoreFoundation.INSTANCE.CFCopyDescription((CoreFoundation.CFTypeRef)secCertificateRef).stringValue();
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to parse certificate '" + certificateDescription + "'", parsingError));
                }
            }
            ArrayList<X509Certificate> arrayList = result2;
            return arrayList;
        }
        finally {
            certArray.release();
        }
    }

    private static X509Certificate getX509Certificate(SecurityFramework.SecCertificateRef secCertificateRef) {
        CoreFoundation.CFDataRef data = SecurityFramework.INSTANCE.SecCertificateCopyData(secCertificateRef);
        try {
            byte[] bytes = data.getBytePtr().getByteArray(0L, data.getLength());
            X509Certificate x509Certificate = NativeTrustedRootsInternalUtils.parseCertificate(bytes);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            data.release();
        }
    }

    static boolean isSelfSignedCertificate(X509Certificate certificate) {
        if (!certificate.getSubjectX500Principal().equals(certificate.getIssuerX500Principal())) {
            return false;
        }
        try {
            certificate.verify(certificate.getPublicKey());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTrustedRoot(SecurityFramework.SecTrustSettingsDomain domain, SecurityFramework.SecCertificateRef certificateRef) {
        boolean selfSignedCertificate = SecurityFrameworkUtil.isSelfSignedCertificate(SecurityFrameworkUtil.getX509Certificate(certificateRef));
        CFArrayRefByReference trustedSettingsRef = new CFArrayRefByReference();
        SecurityFramework.OSStatus rc = SecurityFramework.INSTANCE.SecTrustSettingsCopyTrustSettings(certificateRef, domain, trustedSettingsRef);
        CoreFoundation.CFArrayRef trustedSettingsArray = trustedSettingsRef.getArray();
        if (SecurityFramework.OSStatus.errSecItemNotFound.equals((Object)rc) || trustedSettingsArray == null) {
            return false;
        }
        String certificateDescription = CoreFoundation.INSTANCE.CFCopyDescription((CoreFoundation.CFTypeRef)certificateRef).stringValue();
        if (LOGGER.isLoggable(Level.FINE)) {
            try {
                CoreFoundation.CFStringRef cfStringRef = CoreFoundation.INSTANCE.CFCopyDescription((CoreFoundation.CFTypeRef)trustedSettingsArray);
                LOGGER.fine("Certificate '" + certificateDescription + "' trusted settings:\n" + cfStringRef.stringValue());
            }
            catch (Throwable t) {
                LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to describe certificate trusted settings", t));
            }
        }
        try {
            if (trustedSettingsArray.getCount() == 0) {
                boolean t = true;
                return t;
            }
            for (int i = 0; i < trustedSettingsArray.getCount(); ++i) {
                SecurityFramework.SecTrustSettingsResult result2;
                CoreFoundation.CFDictionaryRef constraints = new CoreFoundation.CFDictionaryRef(trustedSettingsArray.getValueAtIndex(i));
                CoreFoundation.CFIndex constraintsCount = CoreFoundationExt.INSTANCE.CFDictionaryGetCount(constraints);
                int processedConstrains = 0;
                Pointer value = constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsResult);
                if (value == null) {
                    result2 = SecurityFramework.SecTrustSettingsResult.kSecTrustSettingsResultTrustRoot;
                } else {
                    CoreFoundation.CFNumberRef resultNumber = new CoreFoundation.CFNumberRef(value);
                    result2 = new SecurityFramework.SecTrustSettingsResult(resultNumber.longValue());
                    ++processedConstrains;
                }
                if (!result2.equals((Object)SecurityFramework.SecTrustSettingsResult.kSecTrustSettingsResultTrustRoot)) continue;
                if (!selfSignedCertificate) {
                    LOGGER.warning("Certificate '" + certificateDescription + "' is not self-signed, skipping");
                    continue;
                }
                if (constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsAllowedError) != null) {
                    ++processedConstrains;
                }
                if (constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsPolicyName) != null) {
                    ++processedConstrains;
                }
                if ((value = constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsPolicy)) != null) {
                    SecurityFramework.SecPolicyRef secPolicyRef = new SecurityFramework.SecPolicyRef(value);
                    CoreFoundation.CFDictionaryRef policyDictionaryRef = SecurityFramework.INSTANCE.SecPolicyCopyProperties(secPolicyRef);
                    try {
                        CoreFoundation.CFStringRef policyOidStringRef;
                        Pointer policyOid = policyDictionaryRef.getValue((PointerType)SecurityFramework.kSecPolicyOid);
                        if (policyOid == null || !CoreFoundationExt.INSTANCE.CFEqual((CoreFoundation.CFTypeRef)SecurityFramework.kSecPolicyAppleSSL, (CoreFoundation.CFTypeRef)(policyOidStringRef = new CoreFoundation.CFStringRef(policyOid)))) {
                            continue;
                        }
                    }
                    finally {
                        policyDictionaryRef.release();
                    }
                    ++processedConstrains;
                }
                if (constraintsCount.longValue() != (long)processedConstrains) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            trustedSettingsArray.release();
        }
    }
}

