/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqliteIntPreparedStatement;
import org.jetbrains.sqlite.SqlitePreparedStatement;
import org.jetbrains.sqlite.SqliteStatement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010J-\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/sqlite/StatementCollection;", "", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "(Lorg/jetbrains/sqlite/SqliteConnection;)V", "statements", "", "Lorg/jetbrains/sqlite/SqliteStatement;", "close", "", "performCommit", "", "executeBatch", "prepareIntStatement", "Lorg/jetbrains/sqlite/SqliteIntPreparedStatement;", "sql", "", "prepareStatement", "Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "T", "Lorg/jetbrains/sqlite/Binder;", "binder", "(Ljava/lang/String;Lorg/jetbrains/sqlite/Binder;)Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "intellij.platform.sqlite"})
@SourceDebugExtension(value={"SMAP\nStatementCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatementCollection.kt\norg/jetbrains/sqlite/StatementCollection\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n13#2:45\n*S KotlinDebug\n*F\n+ 1 StatementCollection.kt\norg/jetbrains/sqlite/StatementCollection\n*L\n40#1:45\n*E\n"})
public final class StatementCollection {
    @NotNull
    private final SqliteConnection connection;
    @NotNull
    private final List<SqliteStatement> statements;

    public StatementCollection(@NotNull SqliteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        this.statements = new ArrayList();
    }

    @NotNull
    public final <T extends Binder> SqlitePreparedStatement<T> prepareStatement(@Language(value="SQLite") @NotNull String sql2, @NotNull T binder) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter(binder, (String)"binder");
        SqlitePreparedStatement<T> statement = this.connection.prepareStatement(sql2, binder);
        this.statements.add(statement);
        return statement;
    }

    @NotNull
    public final SqliteIntPreparedStatement prepareIntStatement(@Language(value="SQLite") @NotNull String sql2) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        SqliteIntPreparedStatement statement = new SqliteIntPreparedStatement(this.connection, sql2);
        this.statements.add(statement);
        return statement;
    }

    public final void executeBatch() {
        for (SqliteStatement statement : this.statements) {
            statement.executeBatch();
        }
    }

    public final void close(boolean performCommit) {
        for (SqliteStatement statement : this.statements) {
            try {
                if (performCommit) {
                    statement.executeBatch();
                }
                statement.close();
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(StatementCollection.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)e);
            }
        }
    }
}

