/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapData;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0016J4\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0010\u0010\"\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010$\u0018\u00010#2\u0006\u0010 \u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001dH\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020\u001dH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020)0,2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001dH\u0016J \u0010.\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceMapBase;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "sourceMapData", "Lorg/jetbrains/debugger/sourcemap/SourceMapData;", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "(Lorg/jetbrains/debugger/sourcemap/SourceMapData;Lorg/jetbrains/debugger/sourcemap/SourceResolver;)V", "hasNameMappings", "", "getHasNameMappings", "()Z", "outFile", "", "getOutFile", "()Ljava/lang/String;", "sourceIndexToMappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "getSourceIndexToMappings", "()[Lorg/jetbrains/debugger/sourcemap/MappingList;", "getSourceMapData", "()Lorg/jetbrains/debugger/sourcemap/SourceMapData;", "getSourceResolver", "()Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sources", "Lcom/intellij/util/Url;", "getSources", "()[Lcom/intellij/util/Url;", "findSourceIndex", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "sourceUrl", "resolver", "Lkotlin/Lazy;", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "findSourceMappings", "sourceIndex", "getRawSource", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getSourceContent", "getSourceMappingsInLine", "", "sourceLine", "processSourceMappingsInLine", "mappingProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingsProcessorInLine;", "intellij.platform.scriptDebugger.backend"})
@SourceDebugExtension(value={"SMAP\nSourceMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMap.kt\norg/jetbrains/debugger/sourcemap/SourceMapBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public abstract class SourceMapBase
implements SourceMap {
    @NotNull
    private final SourceMapData sourceMapData;
    @NotNull
    private final SourceResolver sourceResolver;

    public SourceMapBase(@NotNull SourceMapData sourceMapData, @NotNull SourceResolver sourceResolver) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        Intrinsics.checkNotNullParameter((Object)sourceResolver, (String)"sourceResolver");
        this.sourceMapData = sourceMapData;
        this.sourceResolver = sourceResolver;
    }

    @NotNull
    protected final SourceMapData getSourceMapData() {
        return this.sourceMapData;
    }

    @Override
    @NotNull
    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    @Override
    @Nullable
    public String getOutFile() {
        return this.sourceMapData.getFile();
    }

    @Override
    public boolean getHasNameMappings() {
        return this.sourceMapData.getHasNameMappings();
    }

    @NotNull
    protected abstract MappingList[] getSourceIndexToMappings();

    @Override
    @NotNull
    public Url[] getSources() {
        return this.getSourceResolver().getCanonicalizedUrls();
    }

    @Override
    public int findSourceIndex(@NotNull Url sourceUrl, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        int index = this.getSourceResolver().findSourceIndex(sourceUrl, sourceFile, localFileUrlOnly);
        if (index == -1 && resolver != null) {
            int n;
            SourceFileResolver sourceFileResolver = (SourceFileResolver)resolver.getValue();
            if (sourceFileResolver != null) {
                SourceFileResolver it = sourceFileResolver;
                boolean bl = false;
                n = this.getSourceResolver().findSourceIndex$intellij_platform_scriptDebugger_backend(it);
            } else {
                n = -1;
            }
            return n;
        }
        return index;
    }

    @Override
    @NotNull
    public MappingList findSourceMappings(int sourceIndex) {
        MappingList mappingList = this.getSourceIndexToMappings()[sourceIndex];
        Intrinsics.checkNotNull((Object)mappingList);
        return mappingList;
    }

    @Override
    public int findSourceIndex(@NotNull VirtualFile sourceFile, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.getSourceResolver().findSourceIndexByFile$intellij_platform_scriptDebugger_backend(sourceFile, localFileUrlOnly);
    }

    @Override
    @NotNull
    public Iterable<MappingEntry> getSourceMappingsInLine(int sourceIndex, int sourceLine) {
        return this.findSourceMappings(sourceIndex).getMappingsInLine(sourceLine);
    }

    @Override
    public boolean processSourceMappingsInLine(int sourceIndex, int sourceLine, @NotNull MappingsProcessorInLine mappingProcessor) {
        Intrinsics.checkNotNullParameter((Object)mappingProcessor, (String)"mappingProcessor");
        return this.findSourceMappings(sourceIndex).processMappingsInLine(sourceLine, mappingProcessor);
    }

    @Override
    @Nullable
    public String getRawSource(@NotNull MappingEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        int index = entry2.getSource();
        return index < 0 ? null : this.sourceMapData.getSources().get(index);
    }

    @Override
    @Nullable
    public String getSourceContent(@NotNull MappingEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        List<String> sourcesContent = this.sourceMapData.getSourcesContent();
        Collection collection = sourcesContent;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int index = entry2.getSource();
        return index < 0 || index >= sourcesContent.size() ? null : sourcesContent.get(index);
    }

    @Override
    @Nullable
    public String getSourceContent(int sourceIndex) {
        List<String> sourcesContent = this.sourceMapData.getSourcesContent();
        Collection collection = sourcesContent;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return sourceIndex < 0 || sourceIndex >= sourcesContent.size() ? null : sourcesContent.get(sourceIndex);
    }
}

