/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection.custom;

import com.intellij.find.FindModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.SmartList;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpInspectionConfiguration
implements Comparable<RegExpInspectionConfiguration> {
    public List<InspectionPattern> patterns;
    private String name;
    private String description;
    private String uuid;
    private String suppressId;
    private String problemDescriptor;
    private boolean cleanup;

    public RegExpInspectionConfiguration(@NotNull String name) {
        if (name == null) {
            RegExpInspectionConfiguration.$$$reportNull$$$0(0);
        }
        this.name = name;
        this.patterns = new SmartList();
    }

    public RegExpInspectionConfiguration() {
        this.patterns = new SmartList();
    }

    private RegExpInspectionConfiguration(RegExpInspectionConfiguration other) {
        this.patterns = new SmartList();
        for (InspectionPattern pattern2 : other.patterns) {
            this.patterns.add(pattern2.copy());
        }
        this.name = other.name;
        this.description = other.description;
        this.uuid = other.uuid;
        this.suppressId = other.suppressId;
        this.problemDescriptor = other.problemDescriptor;
        this.cleanup = other.cleanup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegExpInspectionConfiguration that = (RegExpInspectionConfiguration)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public RegExpInspectionConfiguration copy() {
        return new RegExpInspectionConfiguration(this);
    }

    public List<InspectionPattern> getPatterns() {
        return this.patterns;
    }

    public void addPattern(InspectionPattern pattern2) {
        if (!this.patterns.contains(pattern2)) {
            this.patterns.add(pattern2);
        }
    }

    public void removePattern(InspectionPattern pattern2) {
        this.patterns.remove(pattern2);
    }

    @NlsSafe
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            RegExpInspectionConfiguration.$$$reportNull$$$0(1);
        }
        if (this.uuid == null && this.name != null) {
            this.uuid = UUID.nameUUIDFromBytes(this.name.getBytes(StandardCharsets.UTF_8)).toString();
        }
        this.name = name;
    }

    @NlsSafe
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description2) {
        this.description = description2;
    }

    public String getUuid() {
        if (this.uuid == null && this.name != null) {
            this.uuid = UUID.nameUUIDFromBytes(this.name.getBytes(StandardCharsets.UTF_8)).toString();
        }
        return this.uuid;
    }

    public void setUuid(@Nullable String uuid) {
        this.uuid = uuid;
    }

    @NlsSafe
    public String getSuppressId() {
        return this.suppressId;
    }

    public void setSuppressId(String suppressId) {
        this.suppressId = suppressId;
    }

    @NlsSafe
    public String getProblemDescriptor() {
        return this.problemDescriptor;
    }

    public void setProblemDescriptor(String problemDescriptor) {
        this.problemDescriptor = problemDescriptor;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    @Override
    public int compareTo(@NotNull RegExpInspectionConfiguration o) {
        int result2;
        if (o == null) {
            RegExpInspectionConfiguration.$$$reportNull$$$0(2);
        }
        if ((result2 = this.name.compareToIgnoreCase(o.name)) == 0) {
            if (this.uuid == null) {
                if (o.uuid != null) {
                    result2 = -1;
                }
            } else {
                result2 = o.uuid == null ? 1 : this.uuid.compareTo(o.uuid);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/regexp/inspection/custom/RegExpInspectionConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class InspectionPattern {
        public static final InspectionPattern EMPTY_REPLACE_PATTERN = new InspectionPattern("", null, FindModel.SearchContext.ANY, "");
        @NotNull
        public String regExp;
        @Nullable
        private FileType fileType;
        @Nullable
        public String _fileType;
        @NotNull
        public FindModel.SearchContext searchContext;
        @Nullable
        public String replacement;

        public InspectionPattern(@NotNull String regExp, @Nullable FileType fileType, @NotNull FindModel.SearchContext searchContext, @Nullable String replacement) {
            if (regExp == null) {
                InspectionPattern.$$$reportNull$$$0(0);
            }
            if (searchContext == null) {
                InspectionPattern.$$$reportNull$$$0(1);
            }
            this.regExp = regExp;
            this.fileType = fileType;
            if (this.fileType != null) {
                this._fileType = this.fileType.getName();
            }
            this.searchContext = searchContext;
            this.replacement = replacement;
        }

        public InspectionPattern() {
        }

        InspectionPattern(InspectionPattern copy) {
            this.regExp = copy.regExp;
            this.fileType = copy.fileType;
            this._fileType = copy._fileType;
            this.searchContext = copy.searchContext;
            this.replacement = copy.replacement;
        }

        public InspectionPattern copy() {
            return new InspectionPattern(this);
        }

        @NlsSafe
        public String regExp() {
            return this.regExp;
        }

        @Nullable
        public FileType fileType() {
            if (this.fileType == null && this._fileType != null) {
                this.fileType = FileTypeManager.getInstance().findFileTypeByName(this._fileType);
                if (this.fileType == null) {
                    this.fileType = UnknownFileType.INSTANCE;
                }
            }
            return this.fileType;
        }

        public FindModel.SearchContext searchContext() {
            return this.searchContext;
        }

        @NlsSafe
        @Nullable
        public String replacement() {
            return this.replacement;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            InspectionPattern that = (InspectionPattern)obj;
            return Objects.equals(this.regExp, that.regExp) && Objects.equals(this.fileType, that.fileType) && Objects.equals(this.searchContext, that.searchContext) && Objects.equals(this.replacement, that.replacement);
        }

        public int hashCode() {
            return Objects.hash(this.regExp, this.fileType, this.searchContext, this.replacement);
        }

        public String toString() {
            return "InspectionPattern[regExp=" + this.regExp + ", fileType=" + this.fileType + ", searchContext=" + this.searchContext + ", replacement=" + this.replacement + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "regExp";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "searchContext";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/inspection/custom/RegExpInspectionConfiguration$InspectionPattern";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

