/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.mns;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.Uri;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.mns.ContextMap;
import com.thaiopensource.validate.mns.ElementsOrAttributes;
import com.thaiopensource.validate.mns.Hashset;
import com.thaiopensource.validate.mns.SchemaReceiverImpl;
import com.thaiopensource.validate.mns.ValidatorImpl;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import com.thaiopensource.xml.sax.XmlBaseHandler;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.StringSplitter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

class SchemaImpl
extends AbstractSchema {
    static final String MNS_URI = "http://www.thaiopensource.com/ns/mns";
    private final Hashtable modeMap = new Hashtable();
    private Mode startMode;
    private static final String DEFAULT_MODE_NAME = "#default";
    private final boolean attributesSchema;
    static /* synthetic */ Class class$com$thaiopensource$validate$mns$SchemaImpl;

    SchemaImpl(boolean bl) {
        this.attributesSchema = bl;
    }

    SchemaFuture installHandlers(XMLReader xMLReader, SchemaReceiverImpl schemaReceiverImpl) {
        Handler handler2 = new Handler(schemaReceiverImpl);
        xMLReader.setContentHandler(handler2);
        return handler2;
    }

    public Validator createValidator(PropertyMap propertyMap) {
        return new ValidatorImpl(this.startMode, propertyMap);
    }

    private Mode lookupCreateMode(String string2) {
        Mode mode = (Mode)this.modeMap.get(string2);
        if (mode == null) {
            mode = new Mode(this.attributesSchema ? ElementsOrAttributes.ELEMENTS : ElementsOrAttributes.NEITHER);
            this.modeMap.put(string2, mode);
        }
        return mode;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Handler
    extends DelegatingContentHandler
    implements SchemaFuture {
        private final SchemaReceiverImpl sr;
        private ElementAction currentElementAction;
        private boolean hadError = false;
        private final ErrorHandler eh;
        private final CountingErrorHandler ceh;
        private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$mns$SchemaImpl == null ? (class$com$thaiopensource$validate$mns$SchemaImpl = SchemaImpl.class$("com.thaiopensource.validate.mns.SchemaImpl")) : class$com$thaiopensource$validate$mns$SchemaImpl);
        private Locator locator;
        private final XmlBaseHandler xmlBaseHandler = new XmlBaseHandler();
        private int foreignDepth = 0;
        private String contextNs;
        private Mode contextMode;
        private String elementNs;
        private String defaultSchemaType;
        private final Stack nameStack = new Stack();
        private boolean isRoot;
        private int pathDepth = 0;
        private Validator validator;

        Handler(SchemaReceiverImpl schemaReceiverImpl) {
            this.sr = schemaReceiverImpl;
            this.eh = ValidateProperty.ERROR_HANDLER.get(schemaReceiverImpl.getProperties());
            this.ceh = new CountingErrorHandler(this.eh);
        }

        public void setDocumentLocator(Locator locator) {
            this.xmlBaseHandler.setLocator(locator);
            this.locator = locator;
        }

        public void startDocument() throws SAXException {
            try {
                PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.sr.getProperties());
                ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, this.ceh);
                this.validator = this.sr.getMnsSchema().createValidator(propertyMapBuilder.toPropertyMap());
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
            catch (IncorrectSchemaException incorrectSchemaException) {
                throw new RuntimeException("internal error in RNG schema for MNS");
            }
            this.setDelegate(this.validator.getContentHandler());
            if (this.locator != null) {
                super.setDocumentLocator(this.locator);
            }
            super.startDocument();
        }

        public Schema getSchema() throws IncorrectSchemaException, SAXException {
            if (this.validator == null || this.ceh.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            Enumeration enumeration = SchemaImpl.this.modeMap.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Mode mode = (Mode)SchemaImpl.this.modeMap.get(string2);
                if (mode.defined || string2.equals(SchemaImpl.DEFAULT_MODE_NAME)) continue;
                this.error("undefined_mode", string2, mode.whereDefined);
            }
            if (this.hadError) {
                throw new IncorrectSchemaException();
            }
            return SchemaImpl.this;
        }

        public RuntimeException unwrapException(RuntimeException runtimeException) throws SAXException, IOException, IncorrectSchemaException {
            if (runtimeException instanceof WrappedIOException) {
                throw ((WrappedIOException)runtimeException).getException();
            }
            return runtimeException;
        }

        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            super.startElement(string2, string3, string4, attributes);
            this.xmlBaseHandler.startElement();
            String string5 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            if (string5 != null) {
                this.xmlBaseHandler.xmlBaseAttribute(string5);
            }
            if (!SchemaImpl.MNS_URI.equals(string2) || this.foreignDepth > 0) {
                ++this.foreignDepth;
                return;
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                return;
            }
            if (string3.equals("rules")) {
                this.parseRules(attributes);
            } else if (string3.equals("cover")) {
                this.parseCover(attributes);
            } else if (string3.equals("context")) {
                this.parseContext(attributes);
            } else if (string3.equals("root")) {
                this.parseRoot(attributes);
            } else if (string3.equals("element")) {
                this.parseElement(attributes);
            } else if (string3.equals("lax")) {
                this.parseLax(attributes);
            } else {
                this.parseValidate(string3.equals("validateAttributes"), attributes);
            }
        }

        public void endElement(String string2, String string3, String string4) throws SAXException {
            super.endElement(string2, string3, string4);
            this.xmlBaseHandler.endElement();
            if (this.foreignDepth > 0) {
                --this.foreignDepth;
                return;
            }
            if (this.pathDepth > 0) {
                --this.pathDepth;
                if (this.pathDepth == 0) {
                    this.endPath();
                }
            }
        }

        private void parseRules(Attributes attributes) {
            String string2 = attributes.getValue("", "startMode");
            if (string2 == null) {
                string2 = SchemaImpl.DEFAULT_MODE_NAME;
            }
            this.defaultSchemaType = this.getSchemaType(attributes);
            SchemaImpl.this.startMode = SchemaImpl.this.lookupCreateMode(string2);
        }

        private void parseCover(Attributes attributes) throws SAXException {
            String string2 = this.getNs(attributes, false);
            this.currentElementAction.covered.add(string2);
        }

        private void parseLax(Attributes attributes) throws SAXException {
            String[] stringArray = this.getInModes(attributes);
            Mode[] modeArray = this.getModes(stringArray);
            ElementsOrAttributes elementsOrAttributes = this.toElementsOrAttributes(attributes.getValue("", "allow"), ElementsOrAttributes.BOTH);
            int n = 0;
            while (n < modeArray.length) {
                if (modeArray[n].strictDefined) {
                    this.error("lax_multiply_defined", stringArray[n]);
                } else {
                    modeArray[n].lax = elementsOrAttributes;
                    modeArray[n].strictDefined = true;
                }
                ++n;
            }
        }

        private void parseValidate(boolean bl, Attributes attributes) throws SAXException {
            String[] stringArray = this.getInModes(attributes);
            Mode[] modeArray = this.getModes(stringArray);
            String string2 = this.getNs(attributes, bl);
            String string3 = this.getSchema(attributes);
            String string4 = this.getSchemaType(attributes);
            if (string4 == null) {
                string4 = this.defaultSchemaType;
            }
            try {
                if (bl) {
                    Schema schema = this.sr.createChildSchema(new InputSource(string3), string4, true);
                    int n = 0;
                    while (n < modeArray.length) {
                        if (modeArray[n].attributesMap.get(string2) != null) {
                            this.error("validate_attributes_multiply_defined", stringArray[n], string2);
                        } else {
                            modeArray[n].attributesMap.put(string2, schema);
                        }
                        ++n;
                    }
                } else {
                    Schema schema = this.sr.createChildSchema(new InputSource(string3), string4, false);
                    this.currentElementAction = new ElementAction(string2, schema, this.getUseMode(attributes), new ContextMap(), this.getPrune(attributes));
                    this.contextNs = string2;
                    int n = 0;
                    while (n < modeArray.length) {
                        if (modeArray[n].elementMap.get(string2) != null) {
                            this.error("validate_element_multiply_defined", stringArray[n], string2);
                        } else {
                            modeArray[n].elementMap.put(string2, this.currentElementAction);
                        }
                        ++n;
                    }
                }
            }
            catch (IncorrectSchemaException incorrectSchemaException) {
                this.hadError = true;
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
        }

        private void parseContext(Attributes attributes) throws SAXException {
            String string2 = this.getNs(attributes, false);
            if (string2 != null) {
                this.contextNs = string2;
            }
            this.elementNs = this.contextNs;
            this.contextMode = this.getUseMode(attributes);
        }

        private void parseRoot(Attributes attributes) throws SAXException {
            String string2 = this.getNs(attributes, false);
            if (string2 != null) {
                this.elementNs = string2;
            }
            this.isRoot = true;
            ++this.pathDepth;
        }

        private void parseElement(Attributes attributes) throws SAXException {
            String string2 = this.getNs(attributes, false);
            if (string2 != null) {
                this.elementNs = string2;
            }
            if (!this.currentElementAction.covered.contains(this.elementNs)) {
                this.error("context_ns_not_covered", this.elementNs);
            }
            this.nameStack.push(new Name(this.elementNs, attributes.getValue("", "name").trim()));
            ++this.pathDepth;
        }

        private void endPath() throws SAXException {
            if (!this.currentElementAction.contextMap.put(this.isRoot, this.nameStack, this.contextMode)) {
                this.error("path_multiply_defined", this.displayPath(this.isRoot, this.nameStack));
            }
            this.elementNs = this.contextNs;
            this.isRoot = false;
            this.nameStack.setSize(0);
        }

        private String displayPath(boolean bl, Stack stack) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = stack.size();
            while (n < n2) {
                Name name;
                if (n > 0 || bl) {
                    stringBuffer.append('/');
                }
                if ((name = (Name)stack.elementAt(n)).getNamespaceUri().length() > 0) {
                    stringBuffer.append('{');
                    stringBuffer.append(name.getNamespaceUri());
                    stringBuffer.append('}');
                }
                stringBuffer.append(name.getLocalName());
                ++n;
            }
            return stringBuffer.toString();
        }

        private String getSchema(Attributes attributes) throws SAXException {
            String string2 = attributes.getValue("", "schema");
            if (Uri.hasFragmentId(string2)) {
                this.error("schema_fragment_id");
            }
            return Uri.resolve(this.xmlBaseHandler.getBaseUri(), Uri.escapeDisallowedChars(string2));
        }

        private String getSchemaType(Attributes attributes) {
            return attributes.getValue("", "schemaType");
        }

        private ElementsOrAttributes getPrune(Attributes attributes) {
            return this.toElementsOrAttributes(attributes.getValue("", "prune"), ElementsOrAttributes.NEITHER);
        }

        private ElementsOrAttributes toElementsOrAttributes(String string2, ElementsOrAttributes elementsOrAttributes) {
            if (string2 == null) {
                return elementsOrAttributes;
            }
            ElementsOrAttributes elementsOrAttributes2 = ElementsOrAttributes.NEITHER;
            if (string2.indexOf("elements") >= 0) {
                elementsOrAttributes2 = elementsOrAttributes2.addElements();
            }
            if (string2.indexOf("attributes") >= 0) {
                elementsOrAttributes2 = elementsOrAttributes2.addAttributes();
            }
            return elementsOrAttributes2;
        }

        private Mode getUseMode(Attributes attributes) {
            Mode mode;
            String string2 = attributes.getValue("", "useMode");
            if (string2 == null) {
                string2 = SchemaImpl.DEFAULT_MODE_NAME;
            }
            if ((mode = SchemaImpl.this.lookupCreateMode(string2)).whereDefined == null && this.locator != null) {
                mode.whereDefined = new LocatorImpl(this.locator);
            }
            return mode;
        }

        private String getNs(Attributes attributes, boolean bl) throws SAXException {
            String string2 = attributes.getValue("", "ns");
            if (!(string2 == null || Uri.isAbsolute(string2) || !bl && string2.equals(""))) {
                this.error("ns_absolute");
            }
            return string2;
        }

        private Mode[] getModes(String[] stringArray) {
            Mode[] modeArray = new Mode[stringArray.length];
            int n = 0;
            while (n < modeArray.length) {
                modeArray[n] = SchemaImpl.this.lookupCreateMode(stringArray[n]);
                modeArray[n].defined = true;
                ++n;
            }
            return modeArray;
        }

        private String[] getInModes(Attributes attributes) {
            String string2 = attributes.getValue("", "inModes");
            if (string2 == null) {
                return new String[]{SchemaImpl.DEFAULT_MODE_NAME};
            }
            return StringSplitter.split(string2);
        }

        void error(String string2) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string2), this.locator));
        }

        void error(String string2, String string3) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string2, string3), this.locator));
        }

        void error(String string2, String string3, Locator locator) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string2, string3), locator));
        }

        void error(String string2, String string3, String string4) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string2, string3, string4), this.locator));
        }
    }

    static class Mode {
        private Locator whereDefined;
        private boolean defined = false;
        private ElementsOrAttributes lax;
        private boolean strictDefined = false;
        private final Hashtable elementMap = new Hashtable();
        private final Hashtable attributesMap = new Hashtable();

        Mode(ElementsOrAttributes elementsOrAttributes) {
            this.lax = elementsOrAttributes;
        }

        ElementsOrAttributes getLax() {
            return this.lax;
        }

        Schema getAttributesSchema(String string2) {
            return (Schema)this.attributesMap.get(string2);
        }

        ElementAction getElementAction(String string2) {
            return (ElementAction)this.elementMap.get(string2);
        }
    }

    static class ElementAction {
        private final Schema schema;
        private final Mode mode;
        private final ContextMap contextMap;
        private final ElementsOrAttributes prune;
        private final Hashset covered = new Hashset();

        ElementAction(String string2, Schema schema, Mode mode, ContextMap contextMap, ElementsOrAttributes elementsOrAttributes) {
            this.schema = schema;
            this.mode = mode;
            this.contextMap = contextMap;
            this.prune = elementsOrAttributes;
            this.covered.add(string2);
        }

        Mode getMode() {
            return this.mode;
        }

        ContextMap getContextMap() {
            return this.contextMap;
        }

        Schema getSchema() {
            return this.schema;
        }

        ElementsOrAttributes getPrune() {
            return this.prune;
        }

        Hashset getCoveredNamespaces() {
            return this.covered;
        }
    }

    private static final class WrappedIOException
    extends RuntimeException {
        private final IOException exception;

        private WrappedIOException(IOException iOException) {
            this.exception = iOException;
        }

        private IOException getException() {
            return this.exception;
        }
    }
}

