/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatternProperties {
    @NotNull
    public final Map<String, JsonSchemaObject> mySchemasMap;
    @NotNull
    public final Map<String, Pattern> myCachedPatterns;
    @NotNull
    public final Map<String, String> myCachedPatternProperties;

    @NotNull
    public Map<String, JsonSchemaObject> getSchemasMap() {
        Map<String, JsonSchemaObject> map = this.mySchemasMap;
        if (map == null) {
            PatternProperties.$$$reportNull$$$0(0);
        }
        return map;
    }

    public PatternProperties(@NotNull Map<String, ? extends JsonSchemaObject> schemasMap) {
        if (schemasMap == null) {
            PatternProperties.$$$reportNull$$$0(1);
        }
        this.mySchemasMap = new HashMap<String, JsonSchemaObject>();
        schemasMap.keySet().forEach(key2 -> this.mySchemasMap.put(StringUtil.unescapeBackSlashes((String)key2), (JsonSchemaObject)schemasMap.get(key2)));
        this.myCachedPatterns = new HashMap<String, Pattern>();
        this.myCachedPatternProperties = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
        this.mySchemasMap.keySet().forEach(key2 -> {
            ProgressManager.checkCanceled();
            Pair<Pattern, String> pair = JsonSchemaObjectReadingUtils.compilePattern(key2);
            if (pair.getSecond() == null) {
                assert (pair.getFirst() != null);
                this.myCachedPatterns.put((String)key2, (Pattern)pair.getFirst());
            }
        });
    }

    @Nullable
    public JsonSchemaObject getPatternPropertySchema(@NotNull String name) {
        String value;
        if (name == null) {
            PatternProperties.$$$reportNull$$$0(2);
        }
        if ((value = this.myCachedPatternProperties.get(name)) != null) {
            assert (this.mySchemasMap.containsKey(value));
            return this.mySchemasMap.get(value);
        }
        value = this.myCachedPatterns.keySet().stream().filter(key2 -> JsonSchemaObjectReadingUtils.matchPattern(this.myCachedPatterns.get(key2), name)).findFirst().orElse(null);
        if (value != null) {
            this.myCachedPatternProperties.put(name, value);
            assert (this.mySchemasMap.containsKey(value));
            return this.mySchemasMap.get(value);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/PatternProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemasMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemasMap";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/PatternProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPatternPropertySchema";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

