/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.text.SemVer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.webSymbols.webTypes.WebTypesLoadUtilKt;
import com.intellij.webSymbols.webTypes.json.WebTypes;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0014R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/webSymbols/webTypes/impl/WebTypesDefinitionsEP;", "Lcom/intellij/openapi/extensions/CustomLoadingExtensionPointBean;", "Lcom/intellij/webSymbols/webTypes/json/WebTypes;", "()V", "enableByDefault", "", "Ljava/lang/Boolean;", "source", "", "createInstance", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getImplementationClassName", "Companion", "intellij.platform.webSymbols"})
public class WebTypesDefinitionsEP
extends CustomLoadingExtensionPointBean<WebTypes> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Attribute(value="source")
    @JvmField
    @Nullable
    public String source;
    @Attribute(value="enableByDefault")
    @JvmField
    @Nullable
    public Boolean enableByDefault;
    @NotNull
    private static final ExtensionPointName<WebTypesDefinitionsEP> EP_NAME = new ExtensionPointName("com.intellij.webSymbols.webTypes");
    @NotNull
    private static final ExtensionPointName<WebTypesDefinitionsEP> EP_NAME_DEPRECATED = new ExtensionPointName("com.intellij.javascript.webTypes");

    @Nullable
    protected String getImplementationClassName() {
        return null;
    }

    @NotNull
    public WebTypes createInstance(@NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        PluginId pluginId = pluginDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        PluginId pluginId2 = pluginId;
        try {
            InputStream inputStream = pluginDescriptor.getClassLoader().getResourceAsStream(this.source);
            if (inputStream == null) {
                throw new PluginException("Cannot find web-types definitions located at '" + this.source + "'", pluginId2);
            }
            InputStream inputStream2 = inputStream;
            WebTypes webTypes = WebTypesLoadUtilKt.readWebTypes(inputStream2);
            if (webTypes.getName() == null) {
                throw new PluginException("Missing package-name in web-types definitions from '" + this.source + "'", pluginId2);
            }
            if (SemVer.parseFromText((String)webTypes.getVersion()) == null) {
                throw new PluginException("Cannot parse version '" + webTypes.getVersion() + "' in web-types definitions from '" + this.source + "'", pluginId2);
            }
            return webTypes;
        }
        catch (IOException e) {
            throw new PluginException("Cannot load web-types definitions from '" + this.source + "': " + e.getMessage(), (Throwable)e, pluginId2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/webSymbols/webTypes/impl/WebTypesDefinitionsEP$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/webSymbols/webTypes/impl/WebTypesDefinitionsEP;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "EP_NAME_DEPRECATED", "getEP_NAME_DEPRECATED$intellij_platform_webSymbols", "intellij.platform.webSymbols"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<WebTypesDefinitionsEP> getEP_NAME() {
            return EP_NAME;
        }

        @NotNull
        public final ExtensionPointName<WebTypesDefinitionsEP> getEP_NAME_DEPRECATED$intellij_platform_webSymbols() {
            return EP_NAME_DEPRECATED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

