/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.patterns;

import com.intellij.util.containers.Stack;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.WebSymbolQualifiedName;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.completion.WebSymbolCodeCompletionItem;
import com.intellij.webSymbols.patterns.WebSymbolsPatternReferenceResolver;
import com.intellij.webSymbols.patterns.WebSymbolsPatternSymbolsResolver;
import com.intellij.webSymbols.query.WebSymbolNameConversionRules;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.webTypes.filters.WebSymbolsFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0016J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006 "}, d2={"Lcom/intellij/webSymbols/patterns/WebSymbolsPatternReferenceResolver;", "Lcom/intellij/webSymbols/patterns/WebSymbolsPatternSymbolsResolver;", "items", "", "Lcom/intellij/webSymbols/patterns/WebSymbolsPatternReferenceResolver$Reference;", "([Lcom/intellij/webSymbols/patterns/WebSymbolsPatternReferenceResolver$Reference;)V", "delegate", "Lcom/intellij/webSymbols/WebSymbol;", "getDelegate", "()Lcom/intellij/webSymbols/WebSymbol;", "[Lcom/intellij/webSymbols/patterns/WebSymbolsPatternReferenceResolver$Reference;", "codeCompletion", "", "Lcom/intellij/webSymbols/completion/WebSymbolCodeCompletionItem;", "name", "", "position", "", "scopeStack", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "queryExecutor", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "getSymbolKinds", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "context", "listSymbols", "expandPatterns", "", "matchName", "Reference", "intellij.platform.webSymbols"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWebSymbolsPatternReferenceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsPatternReferenceResolver.kt\ncom/intellij/webSymbols/patterns/WebSymbolsPatternReferenceResolver\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n9972#2:91\n10394#2,5:92\n9972#2:97\n10394#2,5:98\n*S KotlinDebug\n*F\n+ 1 WebSymbolsPatternReferenceResolver.kt\ncom/intellij/webSymbols/patterns/WebSymbolsPatternReferenceResolver\n*L\n29#1:91\n29#1:92,5\n46#1:97\n46#1:98,5\n*E\n"})
public final class WebSymbolsPatternReferenceResolver
implements WebSymbolsPatternSymbolsResolver {
    @NotNull
    private final Reference[] items;

    public WebSymbolsPatternReferenceResolver(Reference ... items) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        this.items = items;
    }

    @Override
    @NotNull
    public Set<WebSymbolQualifiedKind> getSymbolKinds(@Nullable WebSymbol context) {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])this.items), (Function1)getSymbolKinds.1.INSTANCE));
    }

    @Override
    @Nullable
    public WebSymbol getDelegate() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<WebSymbolCodeCompletionItem> codeCompletion(@NotNull String name, int position, @NotNull Stack<WebSymbolsScope> scopeStack, @NotNull WebSymbolsQueryExecutor queryExecutor) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(scopeStack, (String)"scopeStack");
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        Reference[] $this$flatMap$iv = this.items;
        boolean $i$f$flatMap = false;
        Reference[] referenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = it.codeCompletion(name, scopeStack, queryExecutor, position);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<WebSymbol> matchName(@NotNull String name, @NotNull Stack<WebSymbolsScope> scopeStack, @NotNull WebSymbolsQueryExecutor queryExecutor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(scopeStack, (String)"scopeStack");
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.flatMapIterable((Sequence)ArraysKt.asSequence((Object[])this.items), (Function1)((Function1)new Function1<Reference, List<? extends WebSymbol>>(name, scopeStack, queryExecutor){
            final /* synthetic */ String $name;
            final /* synthetic */ Stack<WebSymbolsScope> $scopeStack;
            final /* synthetic */ WebSymbolsQueryExecutor $queryExecutor;
            {
                this.$name = $name;
                this.$scopeStack = $scopeStack;
                this.$queryExecutor = $queryExecutor;
                super(1);
            }

            @NotNull
            public final List<WebSymbol> invoke(@NotNull Reference it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.resolve(this.$name, this.$scopeStack, this.$queryExecutor);
            }
        })), (Function1)matchName.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<WebSymbol> listSymbols(@NotNull Stack<WebSymbolsScope> scopeStack, @NotNull WebSymbolsQueryExecutor queryExecutor, boolean expandPatterns) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scopeStack, (String)"scopeStack");
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        Reference[] $this$flatMap$iv = this.items;
        boolean $i$f$flatMap = false;
        Reference[] referenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = it.listSymbols(scopeStack, queryExecutor, expandPatterns);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\u0002\u0010\u000eJ2\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u00c6\u0003JS\u0010*\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u00c6\u0001J\u0013\u0010+\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020#H\u00d6\u0001J*\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00032\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u00101\u001a\u00020\bJ*\u00102\u001a\b\u0012\u0004\u0012\u00020/0\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!J\t\u00103\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00064"}, d2={"Lcom/intellij/webSymbols/patterns/WebSymbolsPatternReferenceResolver$Reference;", "", "location", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedName;", "qualifiedKind", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "includeVirtual", "", "includeAbstract", "filter", "Lcom/intellij/webSymbols/webTypes/filters/WebSymbolsFilter;", "nameConversionRules", "Lcom/intellij/webSymbols/query/WebSymbolNameConversionRules;", "(Ljava/util/List;Lcom/intellij/webSymbols/WebSymbolQualifiedKind;ZZLcom/intellij/webSymbols/webTypes/filters/WebSymbolsFilter;Ljava/util/List;)V", "getFilter", "()Lcom/intellij/webSymbols/webTypes/filters/WebSymbolsFilter;", "getIncludeAbstract", "()Z", "getIncludeVirtual", "getLocation", "()Ljava/util/List;", "getNameConversionRules", "getQualifiedKind", "()Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "codeCompletion", "Lcom/intellij/webSymbols/completion/WebSymbolCodeCompletionItem;", "name", "", "scopeStack", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "queryExecutor", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "position", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "listSymbols", "Lcom/intellij/webSymbols/WebSymbol;", "scope", "expandPatterns", "resolve", "toString", "intellij.platform.webSymbols"})
    public static final class Reference {
        @NotNull
        private final List<WebSymbolQualifiedName> location;
        @NotNull
        private final WebSymbolQualifiedKind qualifiedKind;
        private final boolean includeVirtual;
        private final boolean includeAbstract;
        @Nullable
        private final WebSymbolsFilter filter;
        @NotNull
        private final List<WebSymbolNameConversionRules> nameConversionRules;

        public Reference(@NotNull List<WebSymbolQualifiedName> location, @NotNull WebSymbolQualifiedKind qualifiedKind, boolean includeVirtual, boolean includeAbstract, @Nullable WebSymbolsFilter filter2, @NotNull List<? extends WebSymbolNameConversionRules> nameConversionRules) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
            Intrinsics.checkNotNullParameter(nameConversionRules, (String)"nameConversionRules");
            this.location = location;
            this.qualifiedKind = qualifiedKind;
            this.includeVirtual = includeVirtual;
            this.includeAbstract = includeAbstract;
            this.filter = filter2;
            this.nameConversionRules = nameConversionRules;
        }

        public /* synthetic */ Reference(List list2, WebSymbolQualifiedKind webSymbolQualifiedKind, boolean bl, boolean bl2, WebSymbolsFilter webSymbolsFilter, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                webSymbolsFilter = null;
            }
            if ((n & 0x20) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            this(list2, webSymbolQualifiedKind, bl, bl2, webSymbolsFilter, list3);
        }

        @NotNull
        public final List<WebSymbolQualifiedName> getLocation() {
            return this.location;
        }

        @NotNull
        public final WebSymbolQualifiedKind getQualifiedKind() {
            return this.qualifiedKind;
        }

        public final boolean getIncludeVirtual() {
            return this.includeVirtual;
        }

        public final boolean getIncludeAbstract() {
            return this.includeAbstract;
        }

        @Nullable
        public final WebSymbolsFilter getFilter() {
            return this.filter;
        }

        @NotNull
        public final List<WebSymbolNameConversionRules> getNameConversionRules() {
            return this.nameConversionRules;
        }

        @NotNull
        public final List<WebSymbol> resolve(@NotNull String name, @NotNull Stack<WebSymbolsScope> scope, @NotNull WebSymbolsQueryExecutor queryExecutor) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            List<WebSymbol> matches = queryExecutor.withNameConversionRules(this.nameConversionRules).runNameMatchQuery(CollectionsKt.plus((Collection)this.location, (Object)new WebSymbolQualifiedName(this.qualifiedKind.getNamespace(), this.qualifiedKind.getKind(), name)), this.includeVirtual, this.includeAbstract, false, (List<? extends WebSymbolsScope>)((List)scope));
            if (this.filter == null) {
                return matches;
            }
            return this.filter.filterNameMatches(matches, queryExecutor, (List)scope, MapsKt.emptyMap());
        }

        @NotNull
        public final List<WebSymbol> listSymbols(@NotNull Stack<WebSymbolsScope> scope, @NotNull WebSymbolsQueryExecutor queryExecutor, boolean expandPatterns) {
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            List<WebSymbol> symbols = queryExecutor.withNameConversionRules(this.nameConversionRules).runListSymbolsQuery(this.location, this.qualifiedKind, expandPatterns, this.includeVirtual, this.includeAbstract, false, (List)scope);
            if (this.filter == null) {
                return symbols;
            }
            return this.filter.filterNameMatches(symbols, queryExecutor, (List)scope, MapsKt.emptyMap());
        }

        @NotNull
        public final List<WebSymbolCodeCompletionItem> codeCompletion(@NotNull String name, @NotNull Stack<WebSymbolsScope> scopeStack, @NotNull WebSymbolsQueryExecutor queryExecutor, int position) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(scopeStack, (String)"scopeStack");
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            List<WebSymbolCodeCompletionItem> codeCompletions = queryExecutor.withNameConversionRules(this.nameConversionRules).runCodeCompletionQuery(CollectionsKt.plus((Collection)this.location, (Object)new WebSymbolQualifiedName(this.qualifiedKind.getNamespace(), this.qualifiedKind.getKind(), name)), position, this.includeVirtual, (List)scopeStack);
            if (this.filter == null) {
                return codeCompletions;
            }
            return this.filter.filterCodeCompletions(codeCompletions, queryExecutor, (List)scopeStack, MapsKt.emptyMap());
        }

        @NotNull
        public final List<WebSymbolQualifiedName> component1() {
            return this.location;
        }

        @NotNull
        public final WebSymbolQualifiedKind component2() {
            return this.qualifiedKind;
        }

        public final boolean component3() {
            return this.includeVirtual;
        }

        public final boolean component4() {
            return this.includeAbstract;
        }

        @Nullable
        public final WebSymbolsFilter component5() {
            return this.filter;
        }

        @NotNull
        public final List<WebSymbolNameConversionRules> component6() {
            return this.nameConversionRules;
        }

        @NotNull
        public final Reference copy(@NotNull List<WebSymbolQualifiedName> location, @NotNull WebSymbolQualifiedKind qualifiedKind, boolean includeVirtual, boolean includeAbstract, @Nullable WebSymbolsFilter filter2, @NotNull List<? extends WebSymbolNameConversionRules> nameConversionRules) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
            Intrinsics.checkNotNullParameter(nameConversionRules, (String)"nameConversionRules");
            return new Reference(location, qualifiedKind, includeVirtual, includeAbstract, filter2, nameConversionRules);
        }

        public static /* synthetic */ Reference copy$default(Reference reference, List list2, WebSymbolQualifiedKind webSymbolQualifiedKind, boolean bl, boolean bl2, WebSymbolsFilter webSymbolsFilter, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = reference.location;
            }
            if ((n & 2) != 0) {
                webSymbolQualifiedKind = reference.qualifiedKind;
            }
            if ((n & 4) != 0) {
                bl = reference.includeVirtual;
            }
            if ((n & 8) != 0) {
                bl2 = reference.includeAbstract;
            }
            if ((n & 0x10) != 0) {
                webSymbolsFilter = reference.filter;
            }
            if ((n & 0x20) != 0) {
                list3 = reference.nameConversionRules;
            }
            return reference.copy(list2, webSymbolQualifiedKind, bl, bl2, webSymbolsFilter, list3);
        }

        @NotNull
        public String toString() {
            return "Reference(location=" + this.location + ", qualifiedKind=" + this.qualifiedKind + ", includeVirtual=" + this.includeVirtual + ", includeAbstract=" + this.includeAbstract + ", filter=" + this.filter + ", nameConversionRules=" + this.nameConversionRules + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.location).hashCode();
            result2 = result2 * 31 + this.qualifiedKind.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.includeVirtual);
            result2 = result2 * 31 + Boolean.hashCode(this.includeAbstract);
            result2 = result2 * 31 + (this.filter == null ? 0 : this.filter.hashCode());
            result2 = result2 * 31 + ((Object)this.nameConversionRules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Reference)) {
                return false;
            }
            Reference reference = (Reference)other;
            if (!Intrinsics.areEqual(this.location, reference.location)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.qualifiedKind, (Object)reference.qualifiedKind)) {
                return false;
            }
            if (this.includeVirtual != reference.includeVirtual) {
                return false;
            }
            if (this.includeAbstract != reference.includeAbstract) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filter, (Object)reference.filter)) {
                return false;
            }
            return Intrinsics.areEqual(this.nameConversionRules, reference.nameConversionRules);
        }
    }
}

