/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.MatchUtil;
import com.intellij.structuralsearch.XmlMatchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.ListNodeIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XmlMatchingVisitor
extends XmlElementVisitor {
    private final GlobalMatchingVisitor myMatchingVisitor;

    public XmlMatchingVisitor(@NotNull GlobalMatchingVisitor matchingVisitor) {
        if (matchingVisitor == null) {
            XmlMatchingVisitor.$$$reportNull$$$0(0);
        }
        this.myMatchingVisitor = matchingVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XmlMatchingVisitor.$$$reportNull$$$0(1);
        }
        XmlAttribute another = (XmlAttribute)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.getMatchContext().pushResult();
        XmlElement name = attribute.getNameElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(name);
        try {
            if (!this.myMatchingVisitor.setResult(isTypedVar || this.myMatchingVisitor.matchText(name, another.getNameElement()))) {
                return;
            }
            XmlAttributeValue valueElement = attribute.getValueElement();
            this.myMatchingVisitor.setResult(valueElement == null || this.myMatchingVisitor.matchOptionally(valueElement, another.getValueElement()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch(name, isTypedVar, another);
        }
    }

    @Override
    public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
        if (value == null) {
            XmlMatchingVisitor.$$$reportNull$$$0(2);
        }
        XmlAttributeValue another = (XmlAttributeValue)this.myMatchingVisitor.getElement();
        PsiElement pattern2 = XmlMatchUtil.getElementToMatch(value);
        PsiElement match2 = XmlMatchUtil.getElementToMatch(another);
        if (!(pattern2 instanceof XmlToken)) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally(pattern2, match2));
        } else {
            String text2 = value.getValue();
            if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text2)) {
                SubstitutionHandler handler2 = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(text2);
                String text22 = another.getText();
                int offset = StringUtil.isQuotedString((String)text22) ? 1 : 0;
                this.myMatchingVisitor.setResult(handler2.handle(another, offset, text22.length() - offset, this.myMatchingVisitor.getMatchContext()));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(text2, another.getValue()));
            }
        }
    }

    @Override
    public void visitXmlTag(@NotNull XmlTag tag) {
        XmlTagChild[] children2;
        ListNodeIterator matchNodes;
        NodeIterator matchNodes2;
        NodeIterator patternNodes;
        XmlToken name;
        XmlTag another;
        if (tag == null) {
            XmlMatchingVisitor.$$$reportNull$$$0(3);
        }
        if ((another = this.myMatchingVisitor.getElement(XmlTag.class)) == null) {
            return;
        }
        CompiledPattern pattern2 = this.myMatchingVisitor.getMatchContext().getPattern();
        boolean isTypedVar = pattern2.isTypedVar(name = XmlMatchingVisitor.getTagNameToken(tag));
        if (!this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText(tag.getName(), another.getName())) && this.myMatchingVisitor.matchInAnyOrder(tag.getAttributes(), another.getAttributes()))) {
            return;
        }
        XmlTagChild[] children1 = tag.getValue().getChildren();
        if (children1.length != 0 && (children1.length == 1 && pattern2.isTypedVar(children1[0]) ? (patternNodes = SsrFilteringNodeIterator.create(tag.getValue().getChildren())).current() != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(patternNodes, matchNodes2 = SsrFilteringNodeIterator.create(another.getValue().getChildren()))) : (children1.length != 1 || !XmlMatchUtil.isWhiteSpace(children1[0])) && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(patternNodes = new ListNodeIterator(XmlMatchUtil.getElementsToMatch(children1)), matchNodes = new ListNodeIterator(XmlMatchUtil.getElementsToMatch(children2 = another.getValue().getChildren())))))) {
            return;
        }
        if (isTypedVar) {
            SubstitutionHandler handler2 = (SubstitutionHandler)pattern2.getHandler(name);
            this.myMatchingVisitor.setResult(handler2.handle(XmlMatchingVisitor.getTagNameToken(another), this.myMatchingVisitor.getMatchContext()));
        }
    }

    @Override
    public void visitXmlText(@NotNull XmlText text2) {
        if (text2 == null) {
            XmlMatchingVisitor.$$$reportNull$$$0(4);
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text2) ? this.myMatchingVisitor.handleTypedElement(text2, this.myMatchingVisitor.getElement()) : this.myMatchingVisitor.matchSequentially(text2.getFirstChild(), this.myMatchingVisitor.getElement().getFirstChild()));
    }

    @Override
    public void visitXmlToken(@NotNull XmlToken token) {
        if (token == null) {
            XmlMatchingVisitor.$$$reportNull$$$0(5);
        }
        if (token.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
            String text2 = token.getText();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text2) ? this.myMatchingVisitor.handleTypedElement(token, this.myMatchingVisitor.getElement()) : this.myMatchingVisitor.matchText(text2, this.myMatchingVisitor.getElement().getText()));
        }
    }

    @Override
    public void visitXmlComment(@NotNull XmlComment comment) {
        if (comment == null) {
            XmlMatchingVisitor.$$$reportNull$$$0(6);
        }
        super.visitXmlComment(comment);
        PsiElement element = this.myMatchingVisitor.getElement();
        if (!(element instanceof XmlComment)) {
            return;
        }
        XmlComment other = (XmlComment)element;
        XmlToken text2 = XmlUtil.getTokenOfType(comment, XmlTokenType.XML_COMMENT_CHARACTERS);
        assert (text2 != null);
        CompiledPattern pattern2 = this.myMatchingVisitor.getMatchContext().getPattern();
        boolean typedVar = pattern2.isTypedVar(text2);
        if (typedVar) {
            SubstitutionHandler handler2 = (SubstitutionHandler)pattern2.getHandler(text2);
            this.myMatchingVisitor.setResult(handler2.handle(XmlUtil.getTokenOfType(other, XmlTokenType.XML_COMMENT_CHARACTERS), this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(MatchUtil.normalize(text2.getText()), MatchUtil.normalize(other.getCommentText())));
        }
    }

    @Nullable
    private static XmlToken getTagNameToken(XmlTag tag) {
        for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
            XmlToken token;
            IElementType tokenType;
            if (!(child instanceof XmlToken) || (tokenType = (token = (XmlToken)child).getTokenType()) != XmlTokenType.XML_NAME && tokenType != XmlTokenType.XML_TAG_NAME) continue;
            return token;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/XmlMatchingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlAttributeValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlToken";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

