/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.XmlElementPattern;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlNamedElementPattern<T extends XmlElement & PsiNamedElement, Self extends XmlNamedElementPattern<T, Self>>
extends XmlElementPattern<T, Self> {
    public XmlNamedElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            XmlNamedElementPattern.$$$reportNull$$$0(0);
        }
        super(condition);
    }

    protected abstract String getLocalName(T var1);

    protected abstract String getNamespace(T var1);

    public Self withLocalName(@NonNls String localName) {
        return this.withLocalName((ElementPattern<String>)StandardPatterns.string().equalTo((Object)localName));
    }

    public Self withLocalName(String ... localNames) {
        return this.withLocalName((ElementPattern<String>)StandardPatterns.string().oneOf(localNames));
    }

    public Self withLocalName(ElementPattern<String> localName) {
        return (Self)((Object)((XmlNamedElementPattern)this.with((PatternCondition)new PsiNamePatternCondition<T>("withLocalName", localName){

            public String getPropertyValue(@NotNull Object o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                return o instanceof XmlElement ? XmlNamedElementPattern.this.getLocalName((XmlElement)o) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/XmlNamedElementPattern$1", "getPropertyValue"));
            }
        })));
    }

    public Self withNamespace(@NonNls String namespace) {
        return this.withNamespace((ElementPattern<String>)StandardPatterns.string().equalTo((Object)namespace));
    }

    public Self withNamespace(String ... namespaces) {
        return this.withNamespace((ElementPattern<String>)StandardPatterns.string().oneOf(namespaces));
    }

    public Self withNamespace(ElementPattern<String> namespace) {
        return (Self)((Object)((XmlNamedElementPattern)this.with((PatternCondition)new PatternConditionPlus<T, String>("withNamespace", namespace){

            public boolean processValues(T t, ProcessingContext context, PairProcessor<? super String, ? super ProcessingContext> processor) {
                return processor.process((Object)XmlNamedElementPattern.this.getNamespace(t), (Object)context);
            }
        })));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/XmlNamedElementPattern", "<init>"));
    }

    public static class XmlAttributePattern
    extends XmlNamedElementPattern<XmlAttribute, XmlAttributePattern> {
        protected XmlAttributePattern() {
            super(new InitialPatternCondition<XmlAttribute>(XmlAttribute.class){

                public boolean accepts(@Nullable Object o, ProcessingContext context) {
                    return o instanceof XmlAttribute;
                }
            });
        }

        @Override
        protected String getLocalName(XmlAttribute xmlAttribute) {
            return xmlAttribute.getLocalName();
        }

        @Override
        protected String getNamespace(XmlAttribute xmlAttribute) {
            return xmlAttribute.getNamespace();
        }

        public XmlAttributePattern withValue(StringPattern pattern2) {
            return (XmlAttributePattern)this.with((PatternCondition)new PatternConditionPlus<XmlAttribute, String>("withValue", (ElementPattern)pattern2){

                public boolean processValues(XmlAttribute t, ProcessingContext context, PairProcessor<? super String, ? super ProcessingContext> processor) {
                    return processor.process((Object)t.getValue(), (Object)context);
                }
            });
        }
    }
}

