/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.actions;

import com.google.common.base.CharMatcher;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

final class ShowAsJsonAction
extends DumbAwareAction {
    private static final Key<Integer> LINE_KEY = Key.create((String)"jsonFileToLogLineNumber");
    private static final Key<WeakReference<Editor>> EDITOR_REF_KEY = Key.create((String)"jsonFileToConsoleEditor");

    ShowAsJsonAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowAsJsonAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            ShowAsJsonAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null && e.getData(LangDataKeys.CONSOLE_VIEW) != null && new JsonLineExtractor(editor).has();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JsonLineExtractor jsonLineExtractor;
        if (e == null) {
            ShowAsJsonAction.$$$reportNull$$$0(2);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project2 = e.getProject();
        JsonLineExtractor jsonLineExtractor2 = jsonLineExtractor = project2 == null || editor == null ? null : new JsonLineExtractor(editor);
        if (jsonLineExtractor == null || !jsonLineExtractor.has()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        if (ShowAsJsonAction.selectOpened(editor, jsonLineExtractor, fileEditorManager)) {
            return;
        }
        LightVirtualFile virtualFile = new LightVirtualFile(StringUtil.trimMiddle((String)jsonLineExtractor.getPrefix(), (int)50), (Language)JsonLanguage.INSTANCE, jsonLineExtractor.get());
        virtualFile.putUserData(LINE_KEY, (Object)jsonLineExtractor.getLine());
        virtualFile.putUserData(EDITOR_REF_KEY, new WeakReference<Editor>(editor));
        PsiFile file = PsiManager.getInstance((Project)project2).findFile((VirtualFile)virtualFile);
        if (file == null) {
            return;
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)file, true));
        virtualFile.setWritable(false);
        FileEditorManager.getInstance((Project)project2).openFile((VirtualFile)virtualFile, true);
    }

    private static boolean selectOpened(Editor editor, JsonLineExtractor jsonLineExtractor, FileEditorManager fileEditorManager) {
        for (FileEditor fileEditor : fileEditorManager.getAllEditors()) {
            WeakReference editorReference;
            Integer line;
            if (!(fileEditor instanceof TextEditor)) continue;
            TextEditor textEditor = (TextEditor)fileEditor;
            VirtualFile file = FileDocumentManager.getInstance().getFile(textEditor.getEditor().getDocument());
            if (!(file instanceof LightVirtualFile) || (line = (Integer)LINE_KEY.get((UserDataHolder)file)) == null || line.intValue() != jsonLineExtractor.getLine() || SoftReference.dereference((Reference)(editorReference = (WeakReference)EDITOR_REF_KEY.get((UserDataHolder)file))) != editor) continue;
            fileEditorManager.openFile(file, true, true);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/actions/ShowAsJsonAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/actions/ShowAsJsonAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }

    private static final class JsonLineExtractor {
        private int start;
        private int end;
        private Document document;
        private int line;
        private int lineStart;

        private JsonLineExtractor(@NotNull Editor editor) {
            if (editor == null) {
                JsonLineExtractor.$$$reportNull$$$0(0);
            }
            this.start = -1;
            this.end = -1;
            this.line = -1;
            this.lineStart = -1;
            this.doCompute(editor);
        }

        public int getLine() {
            return this.line;
        }

        private void doCompute(@NotNull Editor editor) {
            if (editor == null) {
                JsonLineExtractor.$$$reportNull$$$0(1);
            }
            SelectionModel model = editor.getSelectionModel();
            this.document = editor.getDocument();
            if (!model.hasSelection()) {
                int offset = editor.getCaretModel().getOffset();
                if (offset <= this.document.getTextLength()) {
                    this.line = this.document.getLineNumber(offset);
                    this.lineStart = this.document.getLineStartOffset(this.line);
                    this.getJsonString(this.document, this.document.getLineEndOffset(this.line));
                }
                return;
            }
            this.lineStart = model.getSelectionStart();
            int end = model.getSelectionEnd();
            this.line = this.document.getLineNumber(this.lineStart);
            if (this.line == this.document.getLineNumber(end)) {
                this.getJsonString(this.document, end);
            }
        }

        private void getJsonString(Document document2, int lineEnd) {
            CharSequence documentChars = document2.getCharsSequence();
            int start2 = Holder.JSON_START_MATCHER.indexIn(documentChars, this.lineStart);
            if (start2 < 0) {
                return;
            }
            int end = -1;
            for (int i = lineEnd - 1; i > start2; --i) {
                if (documentChars.charAt(i) != '}') continue;
                end = i;
                break;
            }
            if (end == -1) {
                return;
            }
            this.start = start2;
            this.end = end + 1;
        }

        public CharSequence get() {
            return this.document.getCharsSequence().subSequence(this.start, this.end + 1);
        }

        public boolean has() {
            return this.start != -1;
        }

        public String getPrefix() {
            char c;
            CharSequence chars = this.document.getCharsSequence();
            int end = this.start;
            for (int i = this.start - 1; i > this.lineStart && ((c = chars.charAt(i)) == ':' || Character.isWhitespace(c)); --i) {
                --end;
            }
            return CharMatcher.whitespace().trimFrom(chars.subSequence(this.lineStart, end));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "editor";
            objectArray2[1] = "com/intellij/json/actions/ShowAsJsonAction$JsonLineExtractor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCompute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Holder {
        private static final CharMatcher JSON_START_MATCHER = CharMatcher.is((char)'{');

        private Holder() {
        }
    }
}

