/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.psi.codeInsight.XmlAutoPopupEnabler;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlAutoPopupHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(XmlAutoPopupHandler.class);

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        boolean isXmlLikeFile;
        boolean spaceInTag;
        if (project2 == null) {
            XmlAutoPopupHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XmlAutoPopupHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            XmlAutoPopupHandler.$$$reportNull$$$0(2);
        }
        boolean bl = spaceInTag = (isXmlLikeFile = XmlGtTypedHandler.fileContainsXmlLanguage(file)) && charTyped == ' ';
        if (spaceInTag) {
            PsiElement parent;
            spaceInTag = false;
            PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
            if (at != null && (parent = at.getParent()) instanceof XmlTag) {
                spaceInTag = true;
            }
        }
        if ((charTyped == '<' || charTyped == '{' || charTyped == '/' || spaceInTag) && isXmlLikeFile) {
            XmlAutoPopupHandler.autoPopupXmlLookup(project2, editor);
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
            if (result2 == null) {
                XmlAutoPopupHandler.$$$reportNull$$$0(3);
            }
            return result2;
        }
        TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
        if (result3 == null) {
            XmlAutoPopupHandler.$$$reportNull$$$0(4);
        }
        return result3;
    }

    public static void autoPopupXmlLookup(Project project2, Editor editor) {
        AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor, file -> {
            Language templateDataLanguage;
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)(offset - 1));
            if (lastElement instanceof PsiFile) {
                lastElement = file.findElementAt(offset - 1);
            }
            if (lastElement == null || !lastElement.isValid()) {
                return false;
            }
            if (XmlAutoPopupHandler.doCompleteIfNeeded(offset, file, lastElement)) {
                return true;
            }
            FileViewProvider fileViewProvider = file.getViewProvider();
            PsiElement parent = lastElement.getParent();
            if (fileViewProvider instanceof TemplateLanguageFileViewProvider && (templateDataLanguage = ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage()) != parent.getLanguage()) {
                lastElement = fileViewProvider.findElementAt(offset - 1, templateDataLanguage);
                if (lastElement == null || !lastElement.isValid()) {
                    return false;
                }
                return XmlAutoPopupHandler.doCompleteIfNeeded(offset, file, lastElement);
            }
            return false;
        });
    }

    private static boolean doCompleteIfNeeded(int offset, PsiFile file, PsiElement lastElement) {
        Ref isRelevantLanguage = new Ref();
        Ref isAnt = new Ref();
        String text2 = lastElement.getText();
        int len = offset - lastElement.getTextRange().getStartOffset();
        if (len < text2.length()) {
            if (len < 0) {
                LOG.error("wrong last element calculated: " + lastElement);
                return false;
            }
            text2 = text2.substring(0, len);
        }
        return text2.endsWith("<") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) || text2.equals(" ") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) || text2.endsWith("${") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) && (Boolean)isAnt.get() != false || text2.endsWith("@{") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) && (Boolean)isAnt.get() != false || text2.endsWith("</") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) || ContainerUtil.exists((Iterable)XmlAutoPopupEnabler.EP_NAME.getExtensionList(), p -> p.shouldShowPopup(file, offset));
    }

    private static boolean isLanguageRelevant(PsiElement element, PsiFile file, Ref<Boolean> isRelevantLanguage, Ref<Boolean> isAnt) {
        Boolean result2;
        Boolean isAntFile = (Boolean)isAnt.get();
        if (isAntFile == null) {
            isAntFile = XmlUtil.isAntFile(file);
            isAnt.set((Object)isAntFile);
        }
        if ((result2 = (Boolean)isRelevantLanguage.get()) == null) {
            Language language = element.getLanguage();
            PsiElement parent = element.getParent();
            if (element instanceof PsiWhiteSpace && parent != null) {
                language = parent.getLanguage();
            }
            result2 = language instanceof XMLLanguage || HtmlUtil.supportsXmlTypedHandlers(file) || isAntFile != false;
            isRelevantLanguage.set((Object)result2);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlAutoPopupHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlAutoPopupHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }
}

