/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.schema.YamlJsonSchemaInspectionBase;

public class YamlJsonSchemaDeprecationInspection
extends YamlJsonSchemaInspectionBase {
    @Override
    protected PsiElementVisitor doBuildVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, Collection<PsiElement> roots, final JsonSchemaObject schema) {
        PsiElement sampleElement;
        JsonLikePsiWalker walker;
        if (holder == null) {
            YamlJsonSchemaDeprecationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            YamlJsonSchemaDeprecationInspection.$$$reportNull$$$0(1);
        }
        if ((walker = JsonLikePsiWalker.getWalker((PsiElement)(sampleElement = roots.iterator().next()), (JsonSchemaObject)schema)) == null || schema == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        final Project project = sampleElement.getProject();
        return new YamlPsiElementVisitor(){

            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                if (keyValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.annotate(keyValue);
                super.visitKeyValue(keyValue);
            }

            private void annotate(@NotNull YAMLKeyValue keyValue) {
                PsiElement key;
                if (keyValue == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((key = keyValue.getKey()) == null) {
                    return;
                }
                JsonPointerPosition position = walker.findPosition((PsiElement)keyValue, true);
                if (position == null) {
                    return;
                }
                MatchResult result = new JsonSchemaResolver(project, schema, position, walker.createValueAdapter(key)).detailedResolve();
                for (JsonSchemaObject object : result.mySchemas) {
                    String message = object.getDeprecationMessage();
                    if (message == null) continue;
                    holder.registerProblem(key, YAMLBundle.message((String)"inspections.schema.deprecation.text", (Object[])new Object[]{keyValue.getName(), message}), new LocalQuickFix[0]);
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "keyValue";
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonSchemaDeprecationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitKeyValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "annotate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/yaml/schema/YamlJsonSchemaDeprecationInspection";
        objectArray[2] = "doBuildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

