/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.GenericAttachingConnector;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.spi.TransportService;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;

public class SharedMemoryAttachingConnector
extends GenericAttachingConnector {
    static final String ARG_NAME = "name";

    public SharedMemoryAttachingConnector() throws ReflectiveOperationException {
        super(SharedMemoryAttachingConnector.createSharedMemoryTransportService());
        this.addStringArgument(ARG_NAME, this.getString("memory_attaching.name.label"), this.getString("memory_attaching.name"), "", true);
        this.transport = () -> "dt_shmem";
    }

    @Override
    public VirtualMachine attach(Map<String, ? extends Connector.Argument> arguments) throws IOException, IllegalConnectorArgumentsException {
        String name = this.argument(ARG_NAME, arguments).value();
        return super.attach(name, arguments);
    }

    @Override
    public String name() {
        return VirtualMachineManagerImpl.connectorName("com.jetbrains.jdi.SharedMemoryAttach");
    }

    @Override
    public String description() {
        return this.getString("memory_attaching.description");
    }

    static TransportService createSharedMemoryTransportService() throws ReflectiveOperationException {
        Class<?> c = Class.forName("com.sun.tools.jdi.SharedMemoryTransportService");
        Constructor<?> constructor = c.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return (TransportService)constructor.newInstance(new Object[0]);
    }
}

