/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.JpsGradleModuleExtension;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.JpsGradleModuleExtensionImpl;
import org.jetbrains.jps.incremental.resources.ResourcesBuilder;
import org.jetbrains.jps.incremental.resources.StandardResourceBuilderEnabler;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;

public final class JpsGradleExtensionServiceImpl
extends JpsGradleExtensionService {
    private static final Logger LOG = Logger.getInstance(JpsGradleExtensionServiceImpl.class);
    private static final JpsElementChildRole<JpsSimpleElement<Boolean>> PRODUCTION_ON_TEST_ROLE = JpsElementChildRoleBase.create((String)"gradle production on test");
    private final Map<File, GradleProjectConfiguration> myLoadedConfigs = FileCollectionFactory.createCanonicalFileMap();
    private final Map<File, Boolean> myConfigFileExists = ConcurrentFactoryMap.createMap(key -> key.exists());

    public JpsGradleExtensionServiceImpl() {
        ResourcesBuilder.registerEnabler((StandardResourceBuilderEnabler)new StandardResourceBuilderEnabler(){

            public boolean isResourceProcessingEnabled(JpsModule module) {
                return JpsGradleExtensionServiceImpl.this.getExtension(module) == null;
            }
        });
    }

    @Override
    @Nullable
    public JpsGradleModuleExtension getExtension(@NotNull JpsModule module) {
        if (module == null) {
            JpsGradleExtensionServiceImpl.$$$reportNull$$$0(0);
        }
        return (JpsGradleModuleExtension)module.getContainer().getChild(JpsGradleModuleExtensionImpl.ROLE);
    }

    @Override
    @NotNull
    public JpsGradleModuleExtension getOrCreateExtension(@NotNull JpsModule module, @Nullable String moduleType) {
        JpsGradleModuleExtension extension;
        if (module == null) {
            JpsGradleExtensionServiceImpl.$$$reportNull$$$0(1);
        }
        if ((extension = (JpsGradleModuleExtension)module.getContainer().getChild(JpsGradleModuleExtensionImpl.ROLE)) == null) {
            extension = new JpsGradleModuleExtensionImpl(moduleType);
            module.getContainer().setChild(JpsGradleModuleExtensionImpl.ROLE, (JpsElement)extension);
        }
        JpsGradleModuleExtension jpsGradleModuleExtension = extension;
        if (jpsGradleModuleExtension == null) {
            JpsGradleExtensionServiceImpl.$$$reportNull$$$0(2);
        }
        return jpsGradleModuleExtension;
    }

    @Override
    public void setProductionOnTestDependency(@NotNull JpsDependencyElement dependency, boolean value) {
        if (dependency == null) {
            JpsGradleExtensionServiceImpl.$$$reportNull$$$0(3);
        }
        if (value) {
            dependency.getContainer().setChild(PRODUCTION_ON_TEST_ROLE, (JpsElement)JpsElementFactory.getInstance().createSimpleElement((Object)true));
        } else {
            dependency.getContainer().removeChild(PRODUCTION_ON_TEST_ROLE);
        }
    }

    @Override
    public boolean isProductionOnTestDependency(@NotNull JpsDependencyElement dependency) {
        JpsSimpleElement child;
        if (dependency == null) {
            JpsGradleExtensionServiceImpl.$$$reportNull$$$0(4);
        }
        return (child = (JpsSimpleElement)dependency.getContainer().getChild(PRODUCTION_ON_TEST_ROLE)) != null && (Boolean)child.getData() != false;
    }

    @Override
    public boolean hasGradleProjectConfiguration(@NotNull BuildDataPaths paths) {
        if (paths == null) {
            JpsGradleExtensionServiceImpl.$$$reportNull$$$0(5);
        }
        return this.myConfigFileExists.get(new File(paths.getDataStorageRoot(), "gradle/configuration.xml"));
    }

    @Override
    @NotNull
    public GradleProjectConfiguration getGradleProjectConfiguration(BuildDataPaths paths) {
        File dataStorageRoot = paths.getDataStorageRoot();
        GradleProjectConfiguration gradleProjectConfiguration = this.getGradleProjectConfiguration(dataStorageRoot);
        if (gradleProjectConfiguration == null) {
            JpsGradleExtensionServiceImpl.$$$reportNull$$$0(6);
        }
        return gradleProjectConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GradleProjectConfiguration getGradleProjectConfiguration(@NotNull File dataStorageRoot) {
        GradleProjectConfiguration config;
        if (dataStorageRoot == null) {
            JpsGradleExtensionServiceImpl.$$$reportNull$$$0(7);
        }
        File configFile = new File(dataStorageRoot, "gradle/configuration.xml");
        Map<File, GradleProjectConfiguration> map = this.myLoadedConfigs;
        synchronized (map) {
            config = this.myLoadedConfigs.get(configFile);
            if (config == null) {
                config = new GradleProjectConfiguration();
                if (configFile.exists()) {
                    try {
                        XmlSerializer.deserializeInto((Object)config, (Element)JDOMUtil.load((File)configFile));
                    }
                    catch (Exception e) {
                        LOG.info((Throwable)e);
                    }
                }
                this.myLoadedConfigs.put(configFile, config);
            }
        }
        GradleProjectConfiguration gradleProjectConfiguration = config;
        if (gradleProjectConfiguration == null) {
            JpsGradleExtensionServiceImpl.$$$reportNull$$$0(8);
        }
        return gradleProjectConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gradle/model/impl/JpsGradleExtensionServiceImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gradle/model/impl/JpsGradleExtensionServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateExtension";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleProjectConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateExtension";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProductionOnTestDependency";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isProductionOnTestDependency";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasGradleProjectConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGradleProjectConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

