/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.backend.impl;

import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItemKt;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItemProviderKt;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/navbar/backend/impl/PsiNavBarItem;", "Lcom/intellij/platform/navbar/backend/impl/DefaultNavBarItem;", "Lcom/intellij/psi/PsiElement;", "data", "ownerExtension", "Lcom/intellij/ide/navigationToolbar/NavBarModelExtension;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/ide/navigationToolbar/NavBarModelExtension;)V", "getOwnerExtension", "()Lcom/intellij/ide/navigationToolbar/NavBarModelExtension;", "createPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "getIcon", "Ljavax/swing/Icon;", "getTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "navigateOnClick", "", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "weight", "", "intellij.platform.navbar.backend"})
public final class PsiNavBarItem
extends DefaultNavBarItem<PsiElement> {
    @Nullable
    private final NavBarModelExtension ownerExtension;

    public PsiNavBarItem(@NotNull PsiElement data, @Nullable NavBarModelExtension ownerExtension) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data);
        this.ownerExtension = ownerExtension;
    }

    @Nullable
    public final NavBarModelExtension getOwnerExtension() {
        return this.ownerExtension;
    }

    @Override
    @NotNull
    public Pointer<? extends NavBarItem> createPointer() {
        PsiElement data = (PsiElement)this.getData();
        NavBarModelExtension ownerExtension = this.ownerExtension;
        Pointer pointer = Pointer.delegatingPointer((Pointer)((Pointer)SmartPointersKt.createSmartPointer((PsiElement)data)), arg_0 -> PsiNavBarItem.createPointer$lambda$0((Function1)new Function1<PsiElement, PsiNavBarItem>(ownerExtension){
            final /* synthetic */ NavBarModelExtension $ownerExtension;
            {
                this.$ownerExtension = $ownerExtension;
                super(1);
            }

            public final PsiNavBarItem invoke(PsiElement psi) {
                Intrinsics.checkNotNull((Object)psi);
                return new PsiNavBarItem(psi, this.$ownerExtension);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"delegatingPointer(...)");
        return pointer;
    }

    @Override
    @Nullable
    public NavigationRequest navigationRequest() {
        Object t = this.getData();
        Navigatable navigatable = t instanceof Navigatable ? (Navigatable)t : null;
        return navigatable != null ? navigatable.navigationRequest() : null;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        Icon icon2;
        try {
            Icon icon3;
            Icon icon4 = ((PsiElement)this.getData()).getIcon(0);
            if (icon4 != null) {
                Icon it = icon4;
                boolean bl = false;
                int maxDimension = JBUI.scale((int)32);
                icon3 = IconUtil.cropIcon((Icon)it, (int)maxDimension, (int)maxDimension);
            } else {
                icon3 = null;
            }
            icon2 = icon3;
        }
        catch (IndexNotReadyException e) {
            icon2 = null;
        }
        return icon2;
    }

    @Override
    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        PsiFile psiFile = ((PsiElement)this.getData()).getContainingFile();
        if (psiFile != null) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return new SimpleTextAttributes(null, null, DefaultNavBarItemKt.getNavBarErrorAttributes().getWaveColor(), 0);
            }
            VirtualFile virtualFile2 = virtualFile;
            WolfTheProblemSolver problemSolver = WolfTheProblemSolver.getInstance((Project)((PsiElement)this.getData()).getProject());
            int style = problemSolver.isProblemFile(virtualFile2) ? DefaultNavBarItemKt.getNavBarErrorAttributes().getStyle() : 0;
            Color color = FileStatusManager.getInstance((Project)((PsiElement)this.getData()).getProject()).getStatus(virtualFile2).getColor();
            return new SimpleTextAttributes(null, color, DefaultNavBarItemKt.getNavBarErrorAttributes().getWaveColor(), style);
        }
        if (this.getData() instanceof PsiDirectory) {
            VirtualFile virtualFile = ((PsiDirectory)this.getData()).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            VirtualFile vDir = virtualFile;
            if (vDir.getParent() == null || ProjectRootsUtil.isModuleContentRoot((VirtualFile)vDir, (Project)((PsiDirectory)this.getData()).getProject())) {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
                return simpleTextAttributes;
            }
        }
        if (DefaultNavBarItemKt.access$wolfHasProblemFilesBeneath((PsiElement)this.getData())) {
            return DefaultNavBarItemKt.getNavBarErrorAttributes();
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        return simpleTextAttributes;
    }

    @Override
    public boolean navigateOnClick() {
        Boolean shouldExpandOnClick2 = (Boolean)DefaultNavBarItemProviderKt.fromOldExtensions((Function1)new Function1<NavBarModelExtension, Boolean>(this){
            final /* synthetic */ PsiNavBarItem this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Boolean invoke(@NotNull NavBarModelExtension ext) {
                Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
                return ext.shouldExpandOnClick((PsiElement)this.this$0.getData());
            }
        });
        if (shouldExpandOnClick2 != null) {
            return shouldExpandOnClick2 == false;
        }
        return !(this.getData() instanceof PsiDirectory) && !(this.getData() instanceof PsiDirectoryContainer);
    }

    @Override
    public int weight() {
        PsiElement psiElement = (PsiElement)this.getData();
        return psiElement instanceof PsiDirectoryContainer ? 4 : (psiElement instanceof PsiDirectory ? 4 : (psiElement instanceof PsiFile ? 2 : (psiElement instanceof PsiNamedElement ? 3 : Integer.MAX_VALUE)));
    }

    private static final PsiNavBarItem createPointer$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PsiNavBarItem)$tmp0.invoke(p0);
    }
}

