/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.internal.assertions;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.assertions.data.RgbColor;
import org.assertj.swing.assertions.error.ShouldBeEqualColors;
import org.assertj.swing.assertions.error.ShouldBeEqualImages;
import org.assertj.swing.assertions.error.ShouldHaveDimension;
import org.assertj.swing.assertions.error.ShouldNotBeEqualImages;
import org.assertj.swing.internal.assertions.ColorComparisonResult;

public class Images {
    private static final Images INSTANCE = new Images();
    private static final Offset<Integer> ZERO = Offset.offset(0);
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Images instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Images() {
    }

    public void assertEqual(AssertionInfo info, BufferedImage actual, BufferedImage expected) {
        this.assertEqual(info, actual, expected, ZERO);
    }

    public void assertEqual(AssertionInfo info, BufferedImage actual, BufferedImage expected, Offset<Integer> offset) {
        if (offset == null) {
            throw new NullPointerException("The given offset should not be null");
        }
        if (Objects.areEqual(actual, expected)) {
            return;
        }
        if (actual == null || expected == null) {
            throw this.imagesShouldBeEqual(info, offset);
        }
        if (!this.haveEqualSize(actual, expected)) {
            throw this.imageShouldHaveSize(info, actual, Images.sizeOf(actual), Images.sizeOf(expected));
        }
        ColorComparisonResult haveEqualColor = this.haveEqualColor(actual, expected, offset);
        if (haveEqualColor == ColorComparisonResult.ARE_EQUAL) {
            return;
        }
        throw this.failures.failure(info, this.imagesShouldHaveEqualColor(haveEqualColor, offset));
    }

    private AssertionError imagesShouldBeEqual(AssertionInfo info, Offset<Integer> offset) {
        return this.failures.failure(info, ShouldBeEqualImages.shouldBeEqualImages(offset));
    }

    private ErrorMessageFactory imagesShouldHaveEqualColor(ColorComparisonResult r, Offset<Integer> offset) {
        return ShouldBeEqualColors.shouldBeEqualColors(r.color2, r.color1, r.point, offset);
    }

    public void assertNotEqual(AssertionInfo info, BufferedImage actual, BufferedImage other) {
        if (Objects.areEqual(actual, other)) {
            throw this.imagesShouldNotBeEqual(info);
        }
        if (actual == null || other == null) {
            return;
        }
        if (!this.haveEqualSize(actual, other)) {
            return;
        }
        ColorComparisonResult haveEqualColor = this.haveEqualColor(actual, other, ZERO);
        if (haveEqualColor != ColorComparisonResult.ARE_EQUAL) {
            return;
        }
        throw this.imagesShouldNotBeEqual(info);
    }

    private AssertionError imagesShouldNotBeEqual(AssertionInfo info) {
        return this.failures.failure(info, ShouldNotBeEqualImages.shouldNotBeEqualImages());
    }

    private boolean haveEqualSize(BufferedImage i1, BufferedImage i2) {
        return i1.getWidth() == i2.getWidth() && i1.getHeight() == i2.getHeight();
    }

    private ColorComparisonResult haveEqualColor(BufferedImage i1, BufferedImage i2, Offset<Integer> offset) {
        int w = i1.getWidth();
        int h = i1.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                RgbColor c2;
                RgbColor c1 = RgbColor.color(i1.getRGB(x, y));
                if (c1.isEqualTo(c2 = RgbColor.color(i2.getRGB(x, y)), offset)) continue;
                return ColorComparisonResult.notEqual(c1, c2, x, y);
            }
        }
        return ColorComparisonResult.ARE_EQUAL;
    }

    public void assertHasSize(AssertionInfo info, BufferedImage actual, Dimension size) {
        if (size == null) {
            throw new NullPointerException("The given size should not be null");
        }
        org.assertj.core.internal.Objects.instance().assertNotNull(info, actual);
        Dimension sizeOfActual = Images.sizeOf(actual);
        if (Objects.areEqual(sizeOfActual, size)) {
            return;
        }
        throw this.imageShouldHaveSize(info, actual, sizeOfActual, size);
    }

    private AssertionError imageShouldHaveSize(AssertionInfo info, BufferedImage image, Dimension actual, Dimension expected) {
        return this.failures.failure(info, ShouldHaveDimension.shouldHaveDimension(image, actual, expected));
    }

    @VisibleForTesting
    static Dimension sizeOf(BufferedImage image) {
        return new Dimension(image.getWidth(), image.getHeight());
    }
}

