/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.format.Formatting;

public final class ComponentPreconditions {
    @RunsInCurrentThread
    public static void checkEnabledAndShowing(@Nonnull Component c) {
        ComponentPreconditions.checkEnabled(c);
        ComponentPreconditions.checkShowing(c);
    }

    @RunsInCurrentThread
    public static void checkEnabled(@Nonnull Component c) {
        if (!c.isEnabled()) {
            throw new IllegalStateException(Strings.concat("Expecting component ", Formatting.format(c), " to be enabled"));
        }
    }

    @RunsInCurrentThread
    public static void checkShowing(@Nonnull Component c) {
        if (!c.isShowing()) {
            String msg = String.format("Expecting component %s to be showing on the screen", Formatting.format(c));
            throw new IllegalStateException(msg);
        }
    }

    private ComponentPreconditions() {
    }
}

