/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Sets;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.GenericTypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.hierarchy.ComponentHierarchy;

final class FinderDelegate {
    FinderDelegate() {
    }

    @Nonnull
    @RunsInEDT
    Collection<Component> find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m) {
        LinkedHashSet<Component> found = Sets.newLinkedHashSet();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, Preconditions.checkNotNull(component), found);
        }
        return found;
    }

    @RunsInEDT
    private void find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m, @Nonnull Component root, @Nonnull Set<Component> found) {
        for (Component c : FinderDelegate.childrenOfComponent(root, h)) {
            this.find(h, m, Preconditions.checkNotNull(c), found);
        }
        if (FinderDelegate.isMatching(root, m)) {
            found.add(root);
        }
    }

    @Nonnull
    @RunsInEDT
    private static Collection<Component> childrenOfComponent(@Nonnull Component c, @Nonnull ComponentHierarchy h) {
        Collection children = GuiActionRunner.execute(() -> h.childrenOf(c));
        return Preconditions.checkNotNull(children);
    }

    @RunsInEDT
    private static boolean isMatching(@Nonnull Component c, @Nonnull ComponentMatcher m) {
        Boolean matching = GuiActionRunner.execute(() -> m.matches(c));
        return Preconditions.checkNotNull(matching);
    }

    @Nonnull
    @RunsInEDT
    <T extends Component> Collection<T> find(@Nonnull ComponentHierarchy h, @Nonnull GenericTypeMatcher<T> m) {
        LinkedHashSet found = Sets.newLinkedHashSet();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, Preconditions.checkNotNull(component), found);
        }
        return found;
    }

    @Nonnull
    @RunsInEDT
    private static Collection<? extends Component> rootsOf(@Nonnull ComponentHierarchy h) {
        return Preconditions.checkNotNull(GuiActionRunner.execute(() -> h.roots()));
    }

    @RunsInEDT
    private <T extends Component> void find(@Nonnull ComponentHierarchy h, @Nonnull GenericTypeMatcher<T> m, @Nonnull Component root, Set<T> found) {
        for (Component c : FinderDelegate.childrenOfComponent(root, h)) {
            this.find(h, m, Preconditions.checkNotNull(c), found);
        }
        if (FinderDelegate.isMatching(root, m)) {
            found.add(m.supportedType().cast(root));
        }
    }

    @RunsInEDT
    private static <T extends Component> boolean isMatching(@Nonnull Component c, @Nonnull GenericTypeMatcher<T> m) {
        Boolean matching = GuiActionRunner.execute(() -> m.matches(c));
        return Preconditions.checkNotNull(matching);
    }
}

