/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AfterAssertionErrorCollected;
import org.assertj.core.api.AssertionErrorCollector;
import org.assertj.core.util.Throwables;

public class DefaultAssertionErrorCollector
implements AssertionErrorCollector {
    private volatile boolean wasSuccess = true;
    private List<AssertionError> collectedAssertionErrors = Collections.synchronizedList(new ArrayList());
    private AfterAssertionErrorCollected callback = this;
    private AssertionErrorCollector delegate = null;

    @Override
    public void setDelegate(AssertionErrorCollector delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<AssertionErrorCollector> getDelegate() {
        return Optional.ofNullable(this.delegate);
    }

    @Override
    public void collectAssertionError(AssertionError error) {
        if (this.delegate == null) {
            this.collectedAssertionErrors.add(error);
            this.wasSuccess = false;
        } else {
            this.delegate.collectAssertionError(error);
        }
        this.callback.onAssertionErrorCollected(error);
    }

    @Override
    public List<AssertionError> assertionErrorsCollected() {
        List<AssertionError> errors = this.delegate != null ? this.delegate.assertionErrorsCollected() : Collections.unmodifiableList(this.collectedAssertionErrors);
        return this.decorateErrorsCollected(errors);
    }

    public void setAfterAssertionErrorCollected(AfterAssertionErrorCollected afterAssertionErrorCollected) {
        this.callback = afterAssertionErrorCollected;
    }

    @Override
    public void succeeded() {
        if (this.delegate == null) {
            this.wasSuccess = true;
        } else {
            this.delegate.succeeded();
        }
    }

    @Override
    public boolean wasSuccess() {
        return this.delegate == null ? this.wasSuccess : this.delegate.wasSuccess();
    }

    protected <T extends Throwable> List<T> decorateErrorsCollected(List<? extends T> errors) {
        return Throwables.addLineNumberToErrorMessages(errors);
    }
}

