/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightVisitorBasedInspection;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.commands.PerformanceCommand;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DoHighlighting
extends PerformanceCommand {
    public static final String NAME = "doHighlight";
    public static final String PREFIX = "%doHighlight";
    public static final String SPAN_NAME = "highlighting";
    public static final int MILLIS_IN_NANO = 1000000;

    public DoHighlighting(@NotNull String text2, int line) {
        if (text2 == null) {
            DoHighlighting.$$$reportNull$$$0(0);
        }
        super(text2, line);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            DoHighlighting.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
            Project project = context.getProject();
            Editor editor2 = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor2 == null) {
                actionCallback.reject("Editor is not open");
                return;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
            if (psiFile == null) {
                actionCallback.reject("Missing PSI file in the editor");
                return;
            }
            PsiManager.getInstance((Project)project).dropPsiCaches();
            ReadAction.nonBlocking((Callable)Context.current().wrap(() -> {
                long start = System.nanoTime();
                TraceUtil.runWithSpanThrows((Tracer)PerformanceTestSpan.TRACER, (String)SPAN_NAME, span -> {
                    HighlightVisitorBasedInspection tool = new HighlightVisitorBasedInspection().setHighlightErrorElements(true).setRunAnnotators(true).setRunVisitors(false);
                    InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
                    GlobalInspectionContext globalContext = inspectionManager.createNewGlobalContext();
                    InspectionEngine.runInspectionOnFile((PsiFile)psiFile, (InspectionToolWrapper)new GlobalInspectionToolWrapper((GlobalInspectionTool)tool), (GlobalInspectionContext)globalContext);
                    span.setAttribute("lines", (long)editor2.getDocument().getLineCount());
                    long stop = System.nanoTime();
                    span.setAttribute("timeToLines", (double)(stop - start) / 1000000.0 / (double)Math.max(1, editor2.getDocument().getLineCount()));
                });
                actionCallback.setDone();
                return null;
            })).wrapProgress((ProgressIndicator)new DaemonProgressIndicator()).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            DoHighlighting.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/DoHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/DoHighlighting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

