/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.starter.bus.shared.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.tools.ide.starter.bus.shared.dto.SharedEventDto;
import com.intellij.tools.ide.starter.bus.shared.dto.SubscriberDto;
import com.intellij.tools.ide.starter.bus.shared.server.EventBusServer;
import com.intellij.tools.ide.starter.bus.shared.server.LocalEventBusServer;
import com.intellij.tools.ide.starter.bus.shared.server.LocalEventBusServerKt;
import com.intellij.tools.ide.starter.bus.shared.server.services.EventsFlowService;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/tools/ide/starter/bus/shared/server/LocalEventBusServer;", "Lcom/intellij/tools/ide/starter/bus/shared/server/EventBusServer;", "()V", "currentPortIndex", "", "eventsFlowService", "Lcom/intellij/tools/ide/starter/bus/shared/server/services/EventsFlowService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "port", "getPort", "()I", "portsPool", "", "server", "Lcom/sun/net/httpserver/HttpServer;", "endServer", "", "handleException", "t", "", "exchange", "Lcom/sun/net/httpserver/HttpExchange;", "startServer", "updatePort", "", "intellij.tools.ide.starter.bus"})
@SourceDebugExtension(value={"SMAP\nLocalEventBusServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEventBusServer.kt\ncom/intellij/tools/ide/starter/bus/shared/server/LocalEventBusServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class LocalEventBusServer
implements EventBusServer {
    @NotNull
    public static final LocalEventBusServer INSTANCE = new LocalEventBusServer();
    @NotNull
    private static final List<Integer> portsPool = SequencesKt.toMutableList((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)45654, (Function1)portsPool.1.INSTANCE), (Function1)portsPool.2.INSTANCE));
    private static int currentPortIndex;
    private static EventsFlowService eventsFlowService;
    @NotNull
    private static final ObjectMapper objectMapper;
    private static HttpServer server;

    private LocalEventBusServer() {
    }

    @Override
    public int getPort() {
        return ((Number)portsPool.get(currentPortIndex)).intValue();
    }

    @Override
    public void endServer() {
        if (server != null) {
            HttpServer httpServer = server;
            if (httpServer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"server");
                httpServer = null;
            }
            httpServer.stop(1);
            currentPortIndex = 0;
            LocalEventBusServerKt.access$getLOG$p().info("Server stopped");
        }
    }

    @Override
    public boolean updatePort() {
        if (currentPortIndex == portsPool.size() - 1) {
            return false;
        }
        int n = currentPortIndex;
        currentPortIndex = n + 1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleException(Throwable t, HttpExchange exchange) {
        String string = t.getMessage();
        if (string == null) {
            string = t.toString();
        }
        String response = string;
        exchange.getResponseHeaders().add("Content-Type", "text/plain");
        exchange.sendResponseHeaders(500, response.length());
        OutputStream outputStream = exchange.getResponseBody();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getResponseBody(...)");
        Closeable closeable = outputStream;
        Object object = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object = null;
        try {
            BufferedWriter writer2 = (BufferedWriter)closeable;
            boolean bl = false;
            writer2.write(response);
            writer = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    @Override
    public void startServer() {
        try {
            HttpServer httpServer = HttpServer.create(new InetSocketAddress(this.getPort()), 0);
            Intrinsics.checkNotNullExpressionValue((Object)httpServer, (String)"create(...)");
            server = httpServer;
            eventsFlowService = new EventsFlowService();
            HttpServer httpServer2 = server;
            if (httpServer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"server");
                httpServer2 = null;
            }
            httpServer2.createContext("/postAndWaitProcessing", LocalEventBusServer::startServer$lambda$5);
            HttpServer httpServer3 = server;
            if (httpServer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"server");
                httpServer3 = null;
            }
            httpServer3.createContext("/newSubscriber", LocalEventBusServer::startServer$lambda$9);
            HttpServer httpServer4 = server;
            if (httpServer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"server");
                httpServer4 = null;
            }
            httpServer4.createContext("/getEvents", LocalEventBusServer::startServer$lambda$13);
            HttpServer httpServer5 = server;
            if (httpServer5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"server");
                httpServer5 = null;
            }
            httpServer5.createContext("/processedEvent", LocalEventBusServer::startServer$lambda$17);
            HttpServer httpServer6 = server;
            if (httpServer6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"server");
                httpServer6 = null;
            }
            httpServer6.createContext("/clear", LocalEventBusServer::startServer$lambda$20);
            HttpServer httpServer7 = server;
            if (httpServer7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"server");
                httpServer7 = null;
            }
            httpServer7.start();
            LocalEventBusServerKt.access$getLOG$p().info("Server started on port " + this.getPort());
        }
        catch (BindException bind) {
            LocalEventBusServerKt.access$getLOG$p().info("Port " + this.getPort() + " is busy. Trying use another");
            if (!this.updatePort()) {
                throw new BindException("All ports from ports pool are busy");
            }
            this.startServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startServer$lambda$5$lambda$1(HttpExchange $exchange) {
        LocalEventBusServerKt.access$getLOG$p().debug("Got postAndWait request");
        InputStream inputStream = $exchange.getRequestBody();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getRequestBody(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader p0 = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)p0);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object json = object2;
        EventsFlowService eventsFlowService = LocalEventBusServer.eventsFlowService;
        if (eventsFlowService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventsFlowService");
            eventsFlowService = null;
        }
        Object object3 = objectMapper.readValue((String)json, SharedEventDto.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"readValue(...)");
        eventsFlowService.postAndWaitProcessing((SharedEventDto)object3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startServer$lambda$5$lambda$3(HttpExchange $exchange) {
        LocalEventBusServerKt.access$getLOG$p().debug("Processed postAndWait request");
        String response = "Processed";
        $exchange.sendResponseHeaders(200, response.length());
        OutputStream outputStream = $exchange.getResponseBody();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getResponseBody(...)");
        Closeable closeable = outputStream;
        Object object = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            it.write(response);
            writer = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    private static final Void startServer$lambda$5$lambda$4(HttpExchange $exchange, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        Intrinsics.checkNotNull((Object)$exchange);
        INSTANCE.handleException(it, $exchange);
        return null;
    }

    private static final void startServer$lambda$5(HttpExchange exchange) {
        ((CompletableFuture)CompletableFuture.runAsync(() -> LocalEventBusServer.startServer$lambda$5$lambda$1(exchange)).thenRun(() -> LocalEventBusServer.startServer$lambda$5$lambda$3(exchange))).exceptionally(arg_0 -> LocalEventBusServer.startServer$lambda$5$lambda$4(exchange, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startServer$lambda$9(HttpExchange exchange) {
        AutoCloseable autoCloseable = exchange;
        Throwable throwable = null;
        try {
            HttpExchange it = (HttpExchange)autoCloseable;
            boolean bl = false;
            try {
                InputStream inputStream = exchange.getRequestBody();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getRequestBody(...)");
                Closeable closeable = inputStream;
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    BufferedReader p0 = (BufferedReader)closeable;
                    boolean bl2 = false;
                    object2 = TextStreamsKt.readText((Reader)p0);
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object json = object2;
                SubscriberDto subscriberDto = (SubscriberDto)objectMapper.readValue((String)json, SubscriberDto.class);
                EventsFlowService eventsFlowService = LocalEventBusServer.eventsFlowService;
                if (eventsFlowService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"eventsFlowService");
                    eventsFlowService = null;
                }
                Intrinsics.checkNotNull((Object)subscriberDto);
                eventsFlowService.newSubscriber(subscriberDto);
                String response = "Crated";
                byte[] byArray = response.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                exchange.sendResponseHeaders(200, byArray.length);
                OutputStream outputStream = exchange.getResponseBody();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getResponseBody(...)");
                object2 = outputStream;
                Object object3 = Charsets.UTF_8;
                Writer writer = new OutputStreamWriter((OutputStream)object2, (Charset)object3);
                int n2 = 8192;
                object2 = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n2);
                object3 = null;
                try {
                    BufferedWriter it2 = (BufferedWriter)object2;
                    boolean bl3 = false;
                    it2.write(response);
                    writer = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    object3 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                }
            }
            catch (Throwable t) {
                Intrinsics.checkNotNull((Object)exchange);
                INSTANCE.handleException(t, exchange);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startServer$lambda$13(HttpExchange exchange) {
        AutoCloseable autoCloseable = exchange;
        Throwable throwable = null;
        try {
            HttpExchange it = (HttpExchange)autoCloseable;
            boolean bl = false;
            try {
                Closeable closeable = exchange.getRequestBody();
                Throwable throwable2 = null;
                try {
                    Object requestBody = (InputStream)closeable;
                    boolean bl2 = false;
                    EventsFlowService eventsFlowService = LocalEventBusServer.eventsFlowService;
                    if (eventsFlowService == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"eventsFlowService");
                        eventsFlowService = null;
                    }
                    Intrinsics.checkNotNull((Object)requestBody);
                    InputStream inputStream = requestBody;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream, charset);
                    int n = 8192;
                    requestBody = objectMapper.writeValueAsBytes(eventsFlowService.getEvents(TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)))));
                }
                catch (Throwable requestBody) {
                    throwable2 = requestBody;
                    throw requestBody;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                Object eventsJson = requestBody;
                exchange.sendResponseHeaders(200, ((Object)eventsJson).length);
                closeable = exchange.getResponseBody();
                throwable2 = null;
                try {
                    OutputStream it2 = (OutputStream)closeable;
                    boolean bl3 = false;
                    it2.write((byte[])eventsJson);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
            }
            catch (Throwable t) {
                Intrinsics.checkNotNull((Object)exchange);
                INSTANCE.handleException(t, exchange);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startServer$lambda$17(HttpExchange exchange) {
        AutoCloseable autoCloseable = exchange;
        Throwable throwable = null;
        try {
            HttpExchange it = (HttpExchange)autoCloseable;
            boolean bl = false;
            try {
                int n;
                Closeable requestBody2;
                String response = "Processed";
                Closeable closeable = exchange.getRequestBody();
                Object object = null;
                try {
                    requestBody2 = (InputStream)closeable;
                    n = 0;
                    EventsFlowService eventsFlowService = LocalEventBusServer.eventsFlowService;
                    if (eventsFlowService == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"eventsFlowService");
                        eventsFlowService = null;
                    }
                    Intrinsics.checkNotNull((Object)requestBody2);
                    InputStream inputStream = requestBody2;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream, charset);
                    int n2 = 8192;
                    eventsFlowService.processedEvent(TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2))));
                    requestBody2 = Unit.INSTANCE;
                }
                catch (Throwable requestBody2) {
                    object = requestBody2;
                    throw requestBody2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                byte[] byArray = response.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                exchange.sendResponseHeaders(200, byArray.length);
                OutputStream outputStream = exchange.getResponseBody();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getResponseBody(...)");
                closeable = outputStream;
                object = Charsets.UTF_8;
                requestBody2 = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
                n = 8192;
                closeable = requestBody2 instanceof BufferedWriter ? (BufferedWriter)requestBody2 : new BufferedWriter((Writer)requestBody2, n);
                object = null;
                try {
                    BufferedWriter it2 = (BufferedWriter)closeable;
                    boolean bl2 = false;
                    it2.write(response);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
            catch (Throwable t) {
                Intrinsics.checkNotNull((Object)exchange);
                INSTANCE.handleException(t, exchange);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startServer$lambda$20(HttpExchange exchange) {
        AutoCloseable autoCloseable = exchange;
        Throwable throwable = null;
        try {
            HttpExchange it = (HttpExchange)autoCloseable;
            boolean bl = false;
            try {
                String response = "Cleared";
                EventsFlowService eventsFlowService = LocalEventBusServer.eventsFlowService;
                if (eventsFlowService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"eventsFlowService");
                    eventsFlowService = null;
                }
                eventsFlowService.clear();
                byte[] byArray = response.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                exchange.sendResponseHeaders(200, byArray.length);
                OutputStream outputStream = exchange.getResponseBody();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getResponseBody(...)");
                Closeable closeable = outputStream;
                Object object = Charsets.UTF_8;
                Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
                object = null;
                try {
                    BufferedWriter it2 = (BufferedWriter)closeable;
                    boolean bl2 = false;
                    it2.write(response);
                    writer = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
            catch (Throwable t) {
                Intrinsics.checkNotNull((Object)exchange);
                INSTANCE.handleException(t, exchange);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static {
        objectMapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
    }
}

