/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ParallelRunnerForServer {
    private static <T, R> List<R> executeSequentially(@NotNull Collection<T> collection, @NotNull Function<T, R> method) {
        if (collection == null) {
            ParallelRunnerForServer.$$$reportNull$$$0(0);
        }
        if (method == null) {
            ParallelRunnerForServer.$$$reportNull$$$0(1);
        }
        ArrayList<R> result = new ArrayList<R>();
        for (T item : collection) {
            result.add(method.apply(item));
        }
        return result;
    }

    private static <T, R> List<R> executeInParallel(@NotNull Collection<T> collection, @NotNull Function<T, R> method) {
        if (collection == null) {
            ParallelRunnerForServer.$$$reportNull$$$0(2);
        }
        if (method == null) {
            ParallelRunnerForServer.$$$reportNull$$$0(3);
        }
        ConcurrentHashMap.KeySetView runtimeExceptions = ConcurrentHashMap.newKeySet();
        List result = collection.parallelStream().map(item -> {
            try {
                return new Pair((Object)true, method.apply(item));
            }
            catch (RuntimeException ex) {
                runtimeExceptions.add(ex);
                return new Pair((Object)false, null);
            }
        }).filter(pair -> (Boolean)pair.getFirst()).map(pair -> pair.second).collect(Collectors.toList());
        if (!runtimeExceptions.isEmpty()) {
            throw (RuntimeException)runtimeExceptions.stream().reduce((ex1, ex2) -> {
                ex1.addSuppressed((Throwable)ex2);
                return ex1;
            }).get();
        }
        return result;
    }

    public static <T, R> List<R> execute(boolean inParallel, @NotNull Collection<T> collection, @NotNull Function<T, R> method) {
        if (collection == null) {
            ParallelRunnerForServer.$$$reportNull$$$0(4);
        }
        if (method == null) {
            ParallelRunnerForServer.$$$reportNull$$$0(5);
        }
        return inParallel ? ParallelRunnerForServer.executeInParallel(collection, method) : ParallelRunnerForServer.executeSequentially(collection, method);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/server/ParallelRunnerForServer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeSequentially";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInParallel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

