/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.math;

import io.kinference.attribute.Attribute;
import io.kinference.core.data.tensor.KITensor;
import io.kinference.core.operators.math.GeluVer1;
import io.kinference.ndarray.arrays.MutableDoubleNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArrayCore;
import io.kinference.ndarray.arrays.NumberNDArrayCore;
import io.kinference.ndarray.arrays.pointers.DoublePointer;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.tiled.DoubleTiledArray;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.ndarray.extensions.DoubleExtensionsKt;
import io.kinference.ndarray.extensions.FloatExtensionsKt;
import io.kinference.operator.Operator;
import io.kinference.operator.OperatorInfo;
import io.kinference.operator.VersionInfo;
import io.kinference.primitives.types.DataType;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fBM\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\u000e\u0082\u0001\u0001\u0010\u00a8\u0006\u0011"}, d2={"Lio/kinference/core/operators/math/Gelu;", "Lio/kinference/operator/Operator;", "Lio/kinference/core/data/tensor/KITensor;", "name", "", "info", "Lio/kinference/operator/OperatorInfo;", "attributes", "", "Lio/kinference/attribute/Attribute;", "", "inputs", "", "outputs", "(Ljava/lang/String;Lio/kinference/operator/OperatorInfo;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "Companion", "Lio/kinference/core/operators/math/GeluVer1;", "inference-core"})
public abstract class Gelu
extends Operator<KITensor, KITensor> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double SQRT2 = Math.sqrt(2.0);
    @NotNull
    private static final VersionInfo DEFAULT_VERSION = new VersionInfo(1, 0, 2, null);

    private Gelu(String name, OperatorInfo info, Map<String, Attribute<Object>> attributes, List<String> inputs, List<String> outputs) {
        super(name, info, attributes, inputs, outputs);
    }

    public /* synthetic */ Gelu(String name, OperatorInfo info, Map attributes, List inputs, List outputs, DefaultConstructorMarker $constructor_marker) {
        this(name, info, attributes, inputs, outputs);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJV\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/kinference/core/operators/math/Gelu$Companion;", "", "()V", "DEFAULT_VERSION", "Lio/kinference/operator/VersionInfo;", "SQRT2", "", "gelu", "Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "array", "Lio/kinference/ndarray/arrays/MutableNumberNDArrayCore;", "invoke", "Lio/kinference/core/operators/math/GeluVer1;", "name", "", "version", "", "attributes", "", "Lio/kinference/attribute/Attribute;", "inputs", "", "outputs", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)Lio/kinference/core/operators/math/GeluVer1;", "inference-core"})
    @SourceDebugExtension(value={"SMAP\nGelu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gelu.kt\nio/kinference/core/operators/math/Gelu$Companion\n+ 2 FloatPointer.kt\nio/kinference/ndarray/arrays/pointers/FloatPointerKt\n+ 3 DoublePointer.kt\nio/kinference/ndarray/arrays/pointers/DoublePointerKt\n*L\n1#1,72:1\n175#2,18:73\n175#3,18:91\n*S KotlinDebug\n*F\n+ 1 Gelu.kt\nio/kinference/core/operators/math/Gelu$Companion\n*L\n24#1:73,18\n31#1:91,18\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NumberNDArrayCore gelu(@NotNull MutableNumberNDArrayCore array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            DataType type = array.getType();
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    int offset$iv;
                    float[] block$iv;
                    FloatPointer pointer;
                    MutableFloatNDArray cfr_ignored_0 = (MutableFloatNDArray)array;
                    FloatPointer floatPointer = pointer = FloatTiledArray.pointer$default(((MutableFloatNDArray)array).getArray(), 0, 1, null);
                    int count$iv = array.getLinearSize();
                    boolean $i$f$map = false;
                    for (int end$iv = count$iv; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        void $this$map$iv;
                        block$iv = $this$map$iv.getCurrentBlock();
                        if (block$iv.length <= (offset$iv = $this$map$iv.getIndexInBlock()) + end$iv) {
                            $this$map$iv.blockIncrement();
                        } else {
                            $this$map$iv.setIndexInBlock($this$map$iv.getIndexInBlock() + end$iv);
                        }
                        int index$iv = offset$iv;
                        int n = Math.min(block$iv.length, offset$iv + end$iv);
                        while (index$iv < n) {
                            void it;
                            float f;
                            float f2 = block$iv[index$iv];
                            int n2 = index$iv++;
                            float[] fArray = block$iv;
                            boolean bl = false;
                            fArray[n2] = f = 0.5f * it * (1.0f + FloatExtensionsKt.erf((float)(it / (float)SQRT2)));
                        }
                    }
                    break;
                }
                case 2: {
                    int offset$iv;
                    double[] block$iv;
                    DoublePointer pointer;
                    MutableDoubleNDArray cfr_ignored_1 = (MutableDoubleNDArray)array;
                    DoublePointer $this$map$iv = pointer = DoubleTiledArray.pointer$default(((MutableDoubleNDArray)array).getArray(), 0, 1, null);
                    int count$iv = array.getLinearSize();
                    boolean $i$f$map = false;
                    for (int end$iv = count$iv; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = $this$map$iv.getCurrentBlock();
                        if (block$iv.length <= (offset$iv = $this$map$iv.getIndexInBlock()) + end$iv) {
                            $this$map$iv.blockIncrement();
                        } else {
                            $this$map$iv.setIndexInBlock($this$map$iv.getIndexInBlock() + end$iv);
                        }
                        int index$iv = offset$iv;
                        int n = Math.min(block$iv.length, offset$iv + end$iv);
                        while (index$iv < n) {
                            double d;
                            double it = block$iv[index$iv];
                            int n3 = index$iv++;
                            double[] dArray = block$iv;
                            boolean bl = false;
                            dArray[n3] = d = 0.5 * it * (1.0 + DoubleExtensionsKt.erf(it / SQRT2));
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + type);
                }
            }
            return array;
        }

        @NotNull
        public final GeluVer1 invoke(@NotNull String name, @Nullable Integer version, @NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            Integer n = version;
            int n2 = n != null ? n.intValue() : DEFAULT_VERSION.getSinceVersion();
            IntRange intRange = GeluVer1.Companion.getVERSION$inference_core().asRange();
            int n3 = intRange.getFirst();
            if (!(n2 <= intRange.getLast() ? n3 <= n2 : false)) {
                throw new IllegalStateException(("Unsupported version of Gelu operator: " + version).toString());
            }
            return new GeluVer1(name, attributes, inputs, outputs);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DataType.values().length];
                try {
                    nArray[DataType.FLOAT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataType.DOUBLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

